/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import java.util.Iterator;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.actions.OpenResourceAction;
import org.eclipse.ui.actions.RefreshAction;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.ResourceNavigatorActionGroup;

public class WorkspaceActionGroup
extends ResourceNavigatorActionGroup {
    private BuildAction buildAction;
    private BuildAction rebuildAction;
    private OpenResourceAction openProjectAction;
    private CloseResourceAction closeProjectAction;
    private RefreshAction refreshAction;
    static /* synthetic */ Class class$org$eclipse$core$resources$IProject;

    public WorkspaceActionGroup(IResourceNavigator navigator) {
        super(navigator);
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.BUILD_PROJECT.getId(), (IAction)this.buildAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.REBUILD_PROJECT.getId(), (IAction)this.rebuildAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.OPEN_PROJECT.getId(), (IAction)this.openProjectAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_PROJECT.getId(), (IAction)this.closeProjectAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean isProjectSelection = true;
        boolean hasOpenProjects = false;
        boolean hasClosedProjects = false;
        boolean hasBuilder = true;
        Iterator resources = selection.iterator();
        while (resources.hasNext() && (!hasOpenProjects || !hasClosedProjects || hasBuilder || isProjectSelection)) {
            Object next = resources.next();
            IProject project = null;
            if (next instanceof IProject) {
                project = (IProject)next;
            } else if (next instanceof IAdaptable) {
                project = (IProject)((IAdaptable)next).getAdapter(class$org$eclipse$core$resources$IProject == null ? WorkspaceActionGroup.class$("org.eclipse.core.resources.IProject") : class$org$eclipse$core$resources$IProject);
            }
            if (project == null) {
                isProjectSelection = false;
                continue;
            }
            if (project.isOpen()) {
                hasOpenProjects = true;
                if (!hasBuilder || this.hasBuilder(project)) continue;
                hasBuilder = false;
                continue;
            }
            hasClosedProjects = true;
            hasBuilder = false;
        }
        if (!selection.isEmpty() && isProjectSelection && !ResourcesPlugin.getWorkspace().isAutoBuilding() && hasBuilder) {
            this.buildAction.selectionChanged(selection);
            menu.add((IAction)this.buildAction);
        }
        if (!hasClosedProjects) {
            this.refreshAction.selectionChanged(selection);
            menu.add((IAction)this.refreshAction);
        }
        if (isProjectSelection) {
            if (hasClosedProjects) {
                this.openProjectAction.selectionChanged(selection);
                menu.add((IAction)this.openProjectAction);
            }
            if (hasOpenProjects) {
                this.closeProjectAction.selectionChanged(selection);
                menu.add((IAction)this.closeProjectAction);
            }
        }
    }

    public void handleKeyPressed(KeyEvent event) {
        if (event.keyCode == 0x100000E && event.stateMask == 0) {
            if (this.refreshAction.isEnabled()) {
                this.refreshAction.refreshAll();
            }
            event.doit = false;
        }
    }

    boolean hasBuilder(IProject project) {
        try {
            ICommand[] commands = project.getDescription().getBuildSpec();
            if (commands.length > 0) {
                return true;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    protected void makeActions() {
        Shell shell = this.navigator.getSite().getShell();
        this.openProjectAction = new OpenResourceAction(shell);
        this.closeProjectAction = new CloseResourceAction(shell);
        this.refreshAction = new RefreshAction(shell);
        this.refreshAction.setDisabledImageDescriptor(this.getImageDescriptor("dlcl16/refresh_nav.gif"));
        this.refreshAction.setImageDescriptor(this.getImageDescriptor("elcl16/refresh_nav.gif"));
        this.buildAction = new BuildAction(shell, 10);
        this.rebuildAction = new BuildAction(shell, 6);
    }

    public void updateActionBars() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.refreshAction.selectionChanged(selection);
        this.buildAction.selectionChanged(selection);
        this.rebuildAction.selectionChanged(selection);
        this.openProjectAction.selectionChanged(selection);
        this.closeProjectAction.selectionChanged(selection);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

