/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerList;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;
import org.eclipse.ui.views.markers.internal.Messages;

public class MarkerFilter {
    private static final String TAG_DIALOG_SECTION = "filter";
    private static final String TAG_ENABLED = "enabled";
    private static final String TAG_FILTER_ON_MARKER_LIMIT = "filterOnMarkerLimit";
    private static final String TAG_MARKER_LIMIT = "markerLimit";
    private static final String TAG_ON_RESOURCE = "onResource";
    private static final String TAG_SELECTED_TYPES = "selectedType";
    private static final String TAG_WORKING_SET = "workingSet";
    private static final String TAG_TYPES_DELIMITER = ":";
    static final int ON_ANY_RESOURCE = 0;
    static final int ON_SELECTED_RESOURCE_ONLY = 1;
    static final int ON_SELECTED_RESOURCE_AND_CHILDREN = 2;
    static final int ON_ANY_RESOURCE_OF_SAME_PROJECT = 3;
    static final int ON_WORKING_SET = 4;
    static final int DEFAULT_MARKER_LIMIT = 100;
    static final boolean DEFAULT_FILTER_ON_MARKER_LIMIT = true;
    static final int DEFAULT_ON_RESOURCE = 0;
    static final boolean DEFAULT_ACTIVATION_STATUS = true;
    protected List rootTypes = new ArrayList();
    protected List selectedTypes = new ArrayList();
    protected IWorkingSet workingSet;
    protected int onResource;
    protected boolean filterOnMarkerLimit;
    protected boolean enabled;
    protected int markerLimit;
    private MarkerTypesModel typesModel = new MarkerTypesModel();
    private IResource[] focusResource;
    private Set cachedWorkingSet;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    MarkerFilter(String[] rootTypes) {
        for (int i = 0; i < rootTypes.length; ++i) {
            MarkerType type = this.typesModel.getType(rootTypes[i]);
            if (this.rootTypes.contains(type)) continue;
            this.rootTypes.add(type);
        }
    }

    private void addAllSubTypes() {
        for (int i = 0; i < this.rootTypes.size(); ++i) {
            MarkerType rootType = (MarkerType)this.rootTypes.get(i);
            this.addAllSubTypes(rootType);
        }
    }

    private void addAllSubTypes(MarkerType type) {
        if (type == null) {
            return;
        }
        if (!this.selectedTypes.contains(type)) {
            this.selectedTypes.add(type);
        }
        MarkerType[] subTypes = type.getSubtypes();
        for (int i = 0; i < subTypes.length; ++i) {
            this.addAllSubTypes(subTypes[i]);
        }
    }

    private List findMarkers(IResource[] resources, int depth, int limit, IProgressMonitor mon, boolean ignoreExceptions) throws CoreException {
        if (resources == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ConcreteMarker> resultList = new ArrayList<ConcreteMarker>(resources.length * 2);
        HashSet typesToSearch = new HashSet(this.selectedTypes.size());
        HashSet<MarkerType> includeAllSubtypes = new HashSet<MarkerType>(this.selectedTypes.size());
        typesToSearch.addAll(this.selectedTypes);
        Iterator iter = this.selectedTypes.iterator();
        while (iter.hasNext()) {
            MarkerType type = (MarkerType)iter.next();
            List<MarkerType> subtypes = Arrays.asList(type.getAllSubTypes());
            if (!this.selectedTypes.containsAll(subtypes)) continue;
            typesToSearch.removeAll(subtypes);
            includeAllSubtypes.add(type);
        }
        mon.beginTask(Messages.getString("MarkerFilter.searching"), typesToSearch.size() * resources.length);
        HashSet<IResource> resourcesToSearch = new HashSet<IResource>();
        for (int idx = 0; idx < resources.length; ++idx) {
            IResource next = resources[idx];
            if (!next.exists()) continue;
            if (resourcesToSearch.contains(next)) {
                mon.worked(typesToSearch.size());
                continue;
            }
            resourcesToSearch.add(next);
        }
        for (int resourceIdx = 0; resourceIdx < resources.length; ++resourceIdx) {
            iter = typesToSearch.iterator();
            IResource resource = resources[resourceIdx];
            if (!resource.isAccessible()) continue;
            if (depth == 2) {
                boolean found = false;
                for (IContainer parent = resource.getParent(); parent != null; parent = parent.getParent()) {
                    if (!resourcesToSearch.contains(parent)) continue;
                    found = true;
                }
                if (found) continue;
            }
            while (iter.hasNext()) {
                MarkerType markerType = (MarkerType)iter.next();
                IMarker[] markers = resource.findMarkers(markerType.getId(), includeAllSubtypes.contains(markerType), depth);
                mon.worked(1);
                for (int idx = 0; idx < markers.length; ++idx) {
                    ConcreteMarker marker;
                    try {
                        marker = MarkerList.createMarker(markers[idx]);
                    }
                    catch (CoreException e) {
                        if (ignoreExceptions) continue;
                        throw e;
                    }
                    if (limit != -1 && resultList.size() >= limit) {
                        return resultList;
                    }
                    if (!this.selectMarker(marker)) continue;
                    resultList.add(marker);
                }
            }
        }
        mon.done();
        return resultList;
    }

    protected boolean selectMarker(ConcreteMarker marker) {
        return true;
    }

    ConcreteMarker[] findMarkers(IProgressMonitor mon, boolean ignoreExceptions) throws CoreException {
        List unfiltered = Collections.EMPTY_LIST;
        if (!this.isEnabled()) {
            unfiltered = this.findMarkers(new IResource[]{ResourcesPlugin.getWorkspace().getRoot()}, 2, -1, mon, ignoreExceptions);
        } else {
            int limit = -1;
            switch (this.getOnResource()) {
                case 0: {
                    unfiltered = this.findMarkers(new IResource[]{ResourcesPlugin.getWorkspace().getRoot()}, 2, limit, mon, ignoreExceptions);
                    break;
                }
                case 1: {
                    unfiltered = this.findMarkers(this.focusResource, 0, limit, mon, ignoreExceptions);
                    break;
                }
                case 2: {
                    unfiltered = this.findMarkers(this.focusResource, 2, limit, mon, ignoreExceptions);
                    break;
                }
                case 3: {
                    unfiltered = this.findMarkers((IResource[])MarkerFilter.getProjects(this.focusResource), 2, limit, mon, ignoreExceptions);
                    break;
                }
                case 4: {
                    unfiltered = this.findMarkers(this.getResourcesInWorkingSet(), 2, limit, mon, ignoreExceptions);
                }
            }
        }
        if (unfiltered == null) {
            unfiltered = Collections.EMPTY_LIST;
        }
        return unfiltered.toArray(new ConcreteMarker[unfiltered.size()]);
    }

    IResource[] getResourcesInWorkingSet() {
        if (this.workingSet == null) {
            return new IResource[0];
        }
        IAdaptable[] elements = this.workingSet.getElements();
        ArrayList<IResource> result = new ArrayList<IResource>(elements.length);
        for (int idx = 0; idx < elements.length; ++idx) {
            IResource next = (IResource)elements[idx].getAdapter(class$org$eclipse$core$resources$IResource == null ? MarkerFilter.class$("org.eclipse.core.resources.IResource") : class$org$eclipse$core$resources$IResource);
            if (next == null) continue;
            result.add(next);
        }
        return result.toArray(new IResource[result.size()]);
    }

    private Set getWorkingSetAsSetOfPaths() {
        if (this.cachedWorkingSet == null) {
            HashSet result = new HashSet();
            this.addResourcesAndChildren(result, this.getResourcesInWorkingSet());
            this.cachedWorkingSet = result;
        }
        return this.cachedWorkingSet;
    }

    private void addResourcesAndChildren(HashSet result, IResource[] resources) {
        for (int idx = 0; idx < resources.length; ++idx) {
            IResource currentResource = resources[idx];
            result.add(currentResource.getFullPath().toString());
            if (!(currentResource instanceof IContainer)) continue;
            IContainer cont = (IContainer)currentResource;
            try {
                this.addResourcesAndChildren(result, cont.members());
                continue;
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
    }

    static IProject[] getProjects(IResource[] resources) {
        if (resources == null) {
            return new IProject[0];
        }
        Collection projects = MarkerFilter.getProjectsAsCollection(resources);
        return projects.toArray(new IProject[projects.size()]);
    }

    static Collection getProjectsAsCollection(IResource[] resources) {
        HashSet<IProject> projects = new HashSet<IProject>();
        for (int idx = 0; idx < resources.length; ++idx) {
            projects.add(resources[idx].getProject());
        }
        return projects;
    }

    public boolean select(ConcreteMarker marker) {
        if (!this.isEnabled()) {
            return true;
        }
        return this.selectByType(marker) && this.selectBySelection(marker) && this.selectMarker(marker);
    }

    private boolean selectByType(ConcreteMarker marker) {
        return this.selectedTypes.contains(this.typesModel.getType(marker.getType()));
    }

    private boolean selectBySelection(ConcreteMarker marker) {
        block10: {
            block12: {
                IResource resource;
                block11: {
                    block9: {
                        if (this.onResource == 0 || marker == null) {
                            return true;
                        }
                        if (this.focusResource == null) {
                            return true;
                        }
                        resource = marker.getResource();
                        if (this.onResource != 4) break block9;
                        if (this.workingSet == null) {
                            return true;
                        }
                        if (resource != null) {
                            return this.isEnclosed(resource);
                        }
                        break block10;
                    }
                    if (this.onResource != 3) break block11;
                    IProject project = resource.getProject();
                    if (project == null) {
                        return false;
                    }
                    for (int i = 0; i < this.focusResource.length; ++i) {
                        IProject selectedProject = this.focusResource[i].getProject();
                        if (selectedProject == null || !project.equals(selectedProject)) continue;
                        return true;
                    }
                    break block10;
                }
                if (this.onResource != 1) break block12;
                for (int i = 0; i < this.focusResource.length; ++i) {
                    if (!resource.equals(this.focusResource[i])) continue;
                    return true;
                }
                break block10;
            }
            if (this.onResource != 2) break block10;
            for (int i = 0; i < this.focusResource.length; ++i) {
                for (IResource parentResource = resource; parentResource != null; parentResource = parentResource.getParent()) {
                    if (!parentResource.equals(this.focusResource[i])) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isEnclosed(IResource element) {
        if (this.workingSet == null) {
            return false;
        }
        Set workingSetPaths = this.getWorkingSetAsSetOfPaths();
        return workingSetPaths.contains(element.getFullPath().toString());
    }

    int getMarkerLimit() {
        return this.markerLimit;
    }

    void setMarkerLimit(int markerLimit) {
        this.markerLimit = markerLimit;
    }

    int getOnResource() {
        return this.onResource;
    }

    void setOnResource(int onResource) {
        if (onResource >= 0 && onResource <= 4) {
            this.onResource = onResource;
        }
    }

    IResource[] getFocusResource() {
        return this.focusResource;
    }

    public void setFocusResource(IResource[] resources) {
        this.focusResource = resources;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    boolean getFilterOnMarkerLimit() {
        return this.filterOnMarkerLimit;
    }

    List getRootTypes() {
        return this.rootTypes;
    }

    List getSelectedTypes() {
        return this.selectedTypes;
    }

    IWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    void setFilterOnMarkerLimit(boolean filterOnMarkerLimit) {
        this.filterOnMarkerLimit = filterOnMarkerLimit;
    }

    void setSelectedTypes(List selectedTypes) {
        this.selectedTypes = selectedTypes;
    }

    void setWorkingSet(IWorkingSet workingSet) {
        this.workingSet = workingSet;
        this.cachedWorkingSet = null;
    }

    void resetState() {
        this.enabled = true;
        this.filterOnMarkerLimit = true;
        this.markerLimit = 100;
        this.onResource = 0;
        this.selectedTypes.clear();
        this.addAllSubTypes();
        this.setWorkingSet(null);
    }

    public void restoreState(IDialogSettings dialogSettings) {
        this.resetState();
        IDialogSettings settings = dialogSettings.getSection(TAG_DIALOG_SECTION);
        if (settings != null) {
            String setting = settings.get(TAG_ENABLED);
            if (setting != null) {
                this.enabled = Boolean.valueOf(setting);
            }
            if ((setting = settings.get(TAG_FILTER_ON_MARKER_LIMIT)) != null) {
                this.filterOnMarkerLimit = Boolean.valueOf(setting);
            }
            if ((setting = settings.get(TAG_MARKER_LIMIT)) != null) {
                try {
                    this.markerLimit = Integer.parseInt(setting);
                }
                catch (NumberFormatException eNumberFormat) {
                    // empty catch block
                }
            }
            if ((setting = settings.get(TAG_ON_RESOURCE)) != null) {
                try {
                    this.onResource = Integer.parseInt(setting);
                }
                catch (NumberFormatException eNumberFormat) {
                    // empty catch block
                }
            }
            if ((setting = settings.get(TAG_SELECTED_TYPES)) != null) {
                this.selectedTypes.clear();
                StringTokenizer stringTokenizer = new StringTokenizer(setting);
                while (stringTokenizer.hasMoreTokens()) {
                    MarkerType markerType = this.typesModel.getType(stringTokenizer.nextToken(TAG_TYPES_DELIMITER));
                    if (markerType == null || this.selectedTypes.contains(markerType)) continue;
                    this.selectedTypes.add(markerType);
                }
            }
            if ((setting = settings.get(TAG_WORKING_SET)) != null) {
                this.setWorkingSet(WorkbenchPlugin.getDefault().getWorkingSetManager().getWorkingSet(setting));
            }
        }
    }

    public void saveState(IDialogSettings dialogSettings) {
        if (dialogSettings != null) {
            IDialogSettings settings = dialogSettings.getSection(TAG_DIALOG_SECTION);
            if (settings == null) {
                settings = dialogSettings.addNewSection(TAG_DIALOG_SECTION);
            }
            settings.put(TAG_ENABLED, this.enabled);
            settings.put(TAG_FILTER_ON_MARKER_LIMIT, this.filterOnMarkerLimit);
            settings.put(TAG_MARKER_LIMIT, this.markerLimit);
            settings.put(TAG_ON_RESOURCE, this.onResource);
            String markerTypeIds = "";
            for (int i = 0; i < this.selectedTypes.size(); ++i) {
                MarkerType markerType = (MarkerType)this.selectedTypes.get(i);
                markerTypeIds = markerTypeIds + markerType.getId() + TAG_TYPES_DELIMITER;
            }
            settings.put(TAG_SELECTED_TYPES, markerTypeIds);
            if (this.workingSet != null) {
                settings.put(TAG_WORKING_SET, this.workingSet.getName());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

