/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.framelist;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.framelist.FrameList;

public abstract class FrameAction
extends Action {
    private FrameList frameList;
    private IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            FrameAction.this.handlePropertyChange(event);
        }
    };

    protected FrameAction(FrameList frameList) {
        this.frameList = frameList;
        frameList.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void dispose() {
        this.frameList.removePropertyChangeListener(this.propertyChangeListener);
    }

    public FrameList getFrameList() {
        return this.frameList;
    }

    static ImageDescriptor getImageDescriptor(String relativePath) {
        String iconPath = "icons/full/";
        try {
            AbstractUIPlugin plugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
            URL installURL = plugin.getDescriptor().getInstallURL();
            URL url = new URL(installURL, iconPath + relativePath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    protected void handlePropertyChange(PropertyChangeEvent event) {
        this.update();
    }

    public void update() {
    }
}

