/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.dialogs.EditorsPreferencePage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class IDEEditorsPreferencePage
extends EditorsPreferencePage {
    private String defaultEnc;
    private Button defaultEncodingButton;
    private Button otherEncodingButton;
    private Combo encodingCombo;

    protected Control createContents(Composite parent) {
        Composite composite = this.createComposite(parent);
        this.createEditorHistoryGroup(composite);
        this.createSpace(composite);
        this.createShowMultipleEditorTabsPref(composite);
        this.createCloseEditorsOnExitPref(composite);
        this.createEditorReuseGroup(composite);
        this.createSpace(composite);
        this.createEncodingGroup(composite);
        this.updateValidState();
        return composite;
    }

    private void createEncodingGroup(Composite parent) {
        String enc;
        boolean isDefault;
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        GridData data = new GridData(768);
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setText(IDEWorkbenchMessages.getString("WorkbenchPreference.encoding"));
        group.setFont(font);
        SelectionAdapter buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IDEEditorsPreferencePage.this.updateEncodingState(IDEEditorsPreferencePage.this.defaultEncodingButton.getSelection());
                IDEEditorsPreferencePage.this.updateValidState();
            }
        };
        this.defaultEncodingButton = new Button((Composite)group, 16);
        this.defaultEnc = System.getProperty("file.encoding", "UTF-8");
        this.defaultEncodingButton.setText(IDEWorkbenchMessages.format("WorkbenchPreference.defaultEncoding", new String[]{this.defaultEnc}));
        data = new GridData();
        data.horizontalSpan = 2;
        this.defaultEncodingButton.setLayoutData((Object)data);
        this.defaultEncodingButton.addSelectionListener((SelectionListener)buttonListener);
        this.defaultEncodingButton.setFont(font);
        this.otherEncodingButton = new Button((Composite)group, 16);
        this.otherEncodingButton.setText(IDEWorkbenchMessages.getString("WorkbenchPreference.otherEncoding"));
        this.otherEncodingButton.addSelectionListener((SelectionListener)buttonListener);
        this.otherEncodingButton.setFont(font);
        this.encodingCombo = new Combo((Composite)group, 0);
        data = new GridData();
        data.widthHint = this.convertWidthInCharsToPixels(15);
        this.encodingCombo.setFont(font);
        this.encodingCombo.setLayoutData((Object)data);
        this.encodingCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IDEEditorsPreferencePage.this.updateValidState();
            }
        });
        ArrayList<String> encodings = new ArrayList<String>();
        int n = 0;
        try {
            n = Integer.parseInt(IDEWorkbenchMessages.getString("WorkbenchPreference.numDefaultEncodings"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        for (int i = 0; i < n; ++i) {
            String enc2 = IDEWorkbenchMessages.getString("WorkbenchPreference.defaultEncoding" + (i + 1), null);
            if (enc2 == null) continue;
            encodings.add(enc2);
        }
        if (!encodings.contains(this.defaultEnc)) {
            encodings.add(this.defaultEnc);
        }
        boolean bl = isDefault = (enc = ResourcesPlugin.getPlugin().getPluginPreferences().getString("encoding")) == null || enc.length() == 0;
        if (!isDefault && !encodings.contains(enc)) {
            encodings.add(enc);
        }
        Collections.sort(encodings);
        for (int i = 0; i < encodings.size(); ++i) {
            this.encodingCombo.add((String)encodings.get(i));
        }
        this.encodingCombo.setText(isDefault ? this.defaultEnc : enc);
        this.updateEncodingState(isDefault);
    }

    protected void updateValidState() {
        super.updateValidState();
        if (!this.isValid()) {
            return;
        }
        if (!this.isEncodingValid()) {
            this.setErrorMessage(IDEWorkbenchMessages.getString("WorkbenchPreference.unsupportedEncoding"));
            this.setValid(false);
        }
    }

    private boolean isEncodingValid() {
        return this.defaultEncodingButton.getSelection() || this.isValidEncoding(this.encodingCombo.getText());
    }

    private boolean isValidEncoding(String enc) {
        try {
            new String(new byte[0], enc);
            return true;
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
    }

    private void updateEncodingState(boolean useDefault) {
        this.defaultEncodingButton.setSelection(useDefault);
        this.otherEncodingButton.setSelection(!useDefault);
        this.encodingCombo.setEnabled(!useDefault);
        this.updateValidState();
    }

    protected void performDefaults() {
        this.updateEncodingState(true);
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.hasNewEncoding()) {
            String enc = this.defaultEncodingButton.getSelection() ? null : this.encodingCombo.getText();
            try {
                ResourcesPlugin.getWorkspace().getRoot().setDefaultCharset(enc, null);
            }
            catch (CoreException exception) {
                ErrorDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.getString("IDEEditorsPreferencePageEncodingError"), (String)exception.getMessage(), (IStatus)exception.getStatus());
                return false;
            }
        }
        return super.performOk();
    }

    private boolean hasNewEncoding() {
        String enc = ResourcesPlugin.getPlugin().getPluginPreferences().getString("encoding");
        if (this.defaultEncodingButton.getSelection()) {
            return enc != null && enc.length() > 0;
        }
        return !enc.equals(this.encodingCombo.getText());
    }
}

