/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.actions.GlobalBuildAction;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.SimpleListContentProvider;

public class BuildOrderPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IWorkbench workbench;
    private Button defaultOrderButton;
    private Label buildLabel;
    private List buildList;
    private Composite buttonComposite;
    private IntegerFieldEditor maxItersField;
    private String[] defaultBuildOrder;
    private String[] customBuildOrder;
    private boolean notCheckedBuildOrder = true;
    private final String UP_LABEL = IDEWorkbenchMessages.getString("BuildOrderPreference.up");
    private final String DOWN_LABEL = IDEWorkbenchMessages.getString("BuildOrderPreference.down");
    private final String ADD_LABEL = IDEWorkbenchMessages.getString("BuildOrderPreference.add");
    private final String REMOVE_LABEL = IDEWorkbenchMessages.getString("BuildOrderPreference.remove");
    private final String PROJECT_SELECTION_MESSAGE = IDEWorkbenchMessages.getString("BuildOrderPreference.selectOtherProjects");
    private final String DEFAULTS_LABEL = IDEWorkbenchMessages.getString("BuildOrderPreference.useDefaults");
    private final String LIST_LABEL = IDEWorkbenchMessages.getString("BuildOrderPreference.projectBuildOrder");
    private final String NOTE_LABEL = IDEWorkbenchMessages.getString("Preference.note");
    private final String REMOVE_MESSAGE = IDEWorkbenchMessages.getString("BuildOrderPreference.removeNote");
    private boolean defaultOrderInitiallySelected;
    private IPropertyChangeListener validityChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("field_editor_is_valid")) {
                BuildOrderPreferencePage.this.updateValidState();
            }
        }
    };

    private void addProject() {
        String[] currentItems = this.buildList.getItems();
        IProject[] allProjects = this.getWorkspace().getRoot().getProjects();
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }
        };
        SimpleListContentProvider contentsProvider = new SimpleListContentProvider();
        contentsProvider.setElements(this.sortedDifference(allProjects, currentItems));
        ListSelectionDialog dialog = new ListSelectionDialog(this.getShell(), (Object)this, (IStructuredContentProvider)contentsProvider, (ILabelProvider)labelProvider, this.PROJECT_SELECTION_MESSAGE);
        if (dialog.open() != 0) {
            return;
        }
        Object[] result = dialog.getResult();
        int currentItemsLength = currentItems.length;
        int resultLength = result.length;
        String[] newItems = new String[currentItemsLength + resultLength];
        System.arraycopy(currentItems, 0, newItems, 0, currentItemsLength);
        System.arraycopy(result, 0, newItems, currentItemsLength, result.length);
        this.buildList.setItems(newItems);
    }

    private void updateValidState() {
        this.setValid(this.maxItersField.isValid());
    }

    private void createBuildOrderList(Composite composite, boolean enabled) {
        Font font = composite.getFont();
        this.buildLabel = new Label(composite, 0);
        this.buildLabel.setText(this.LIST_LABEL);
        this.buildLabel.setEnabled(enabled);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        this.buildLabel.setLayoutData((Object)gridData);
        this.buildLabel.setFont(font);
        this.buildList = new List(composite, 2818);
        this.buildList.setEnabled(enabled);
        GridData data = new GridData();
        data.heightHint = this.buildList.getItemHeight();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.buildList.setLayoutData((Object)data);
        this.buildList.setFont(font);
    }

    protected Control createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.ui.ide.build_order_preference_page_context");
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        composite.setFont(font);
        String[] buildOrder = this.getCurrentBuildOrder();
        boolean useDefault = buildOrder == null;
        this.createDefaultPathButton(composite, useDefault);
        this.createBuildOrderList(composite, true);
        this.createListButtons(composite, !useDefault);
        Composite noteComposite = this.createNoteComposite(font, composite, this.NOTE_LABEL, this.REMOVE_MESSAGE);
        GridData noteData = new GridData();
        noteData.horizontalSpan = 2;
        noteComposite.setLayoutData((Object)noteData);
        this.createSpacer(composite);
        this.createMaxIterationsField(composite);
        this.createSpacer(composite);
        if (useDefault) {
            this.buildList.setItems(this.getDefaultProjectOrder());
        } else {
            this.buildList.setItems(buildOrder);
        }
        return composite;
    }

    private void createSpacer(Composite composite) {
        Label spacer = new Label(composite, 0);
        GridData spacerData = new GridData();
        spacerData.horizontalSpan = 2;
        spacer.setLayoutData((Object)spacerData);
    }

    private void createDefaultPathButton(Composite composite, boolean selected) {
        this.defaultOrderInitiallySelected = selected;
        this.defaultOrderButton = new Button(composite, 16416);
        this.defaultOrderButton.setSelection(selected);
        this.defaultOrderButton.setText(this.DEFAULTS_LABEL);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildOrderPreferencePage.this.defaultsButtonSelected(BuildOrderPreferencePage.this.defaultOrderButton.getSelection());
            }
        };
        this.defaultOrderButton.addSelectionListener((SelectionListener)listener);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        this.defaultOrderButton.setLayoutData((Object)gridData);
        this.defaultOrderButton.setFont(composite.getFont());
    }

    private void createListButtons(Composite composite, boolean enableComposite) {
        Font font = composite.getFont();
        this.buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.buttonComposite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.buttonComposite.setLayoutData((Object)gridData);
        this.buttonComposite.setFont(font);
        Button upButton = new Button(this.buttonComposite, 0x1000008);
        upButton.setText(this.UP_LABEL);
        upButton.setEnabled(enableComposite);
        upButton.setFont(font);
        this.setButtonLayoutData(upButton);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildOrderPreferencePage.this.moveSelectionUp();
            }
        };
        upButton.addSelectionListener((SelectionListener)listener);
        Button downButton = new Button(this.buttonComposite, 0x1000008);
        downButton.setText(this.DOWN_LABEL);
        downButton.setEnabled(enableComposite);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildOrderPreferencePage.this.moveSelectionDown();
            }
        };
        downButton.addSelectionListener((SelectionListener)listener);
        downButton.setFont(font);
        this.setButtonLayoutData(downButton);
        Button addButton = new Button(this.buttonComposite, 0x1000008);
        addButton.setText(this.ADD_LABEL);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildOrderPreferencePage.this.addProject();
            }
        };
        addButton.addSelectionListener((SelectionListener)listener);
        addButton.setEnabled(enableComposite);
        addButton.setFont(font);
        this.setButtonLayoutData(addButton);
        Button removeButton = new Button(this.buttonComposite, 0x1000008);
        removeButton.setText(this.REMOVE_LABEL);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildOrderPreferencePage.this.removeSelection();
            }
        };
        removeButton.addSelectionListener((SelectionListener)listener);
        removeButton.setEnabled(enableComposite);
        removeButton.setFont(font);
        this.setButtonLayoutData(removeButton);
    }

    private void createMaxIterationsField(Composite composite) {
        Composite maxItersComposite = new Composite(composite, 0);
        GridData gd = new GridData(768);
        maxItersComposite.setLayoutData((Object)gd);
        maxItersComposite.setFont(composite.getFont());
        this.maxItersField = new IntegerFieldEditor("", IDEWorkbenchMessages.getString("BuildOrderPreference.maxIterationsLabel"), maxItersComposite){

            protected void doLoad() {
                Text text = this.getTextControl();
                if (text != null) {
                    int value = BuildOrderPreferencePage.this.getWorkspace().getDescription().getMaxBuildIterations();
                    text.setText(Integer.toString(value));
                }
            }

            protected void doLoadDefault() {
                Text text = this.getTextControl();
                if (text != null) {
                    int value = ResourcesPlugin.getPlugin().getPluginPreferences().getDefaultInt("description.maxbuilditerations");
                    text.setText(Integer.toString(value));
                }
                this.valueChanged();
            }

            protected void doStore() {
                throw new UnsupportedOperationException();
            }
        };
        this.maxItersField.setValidRange(1, Integer.MAX_VALUE);
        this.maxItersField.setPreferencePage((PreferencePage)this);
        this.maxItersField.setPreferenceStore(this.getPreferenceStore());
        this.maxItersField.setPropertyChangeListener(this.validityChangeListener);
        this.maxItersField.load();
    }

    private void defaultsButtonSelected(boolean selected) {
        if (selected) {
            this.setBuildOrderWidgetsEnablement(false);
            this.customBuildOrder = this.buildList.getItems();
            this.buildList.setItems(this.getDefaultProjectOrder());
        } else {
            this.setBuildOrderWidgetsEnablement(true);
            String[] buildOrder = this.getCurrentBuildOrder();
            if (buildOrder == null) {
                this.buildList.setItems(this.getDefaultProjectOrder());
            } else {
                this.buildList.setItems(buildOrder);
            }
        }
    }

    private String[] getCurrentBuildOrder() {
        if (this.notCheckedBuildOrder) {
            this.customBuildOrder = this.getWorkspace().getDescription().getBuildOrder();
            this.notCheckedBuildOrder = false;
        }
        return this.customBuildOrder;
    }

    private String[] getDefaultProjectOrder() {
        if (this.defaultBuildOrder == null) {
            IWorkspace workspace = this.getWorkspace();
            IWorkspace.ProjectOrder projectOrder = this.getWorkspace().computeProjectOrder(workspace.getRoot().getProjects());
            IProject[] foundProjects = projectOrder.projects;
            this.defaultBuildOrder = new String[foundProjects.length];
            int foundSize = foundProjects.length;
            for (int i = 0; i < foundSize; ++i) {
                this.defaultBuildOrder[i] = foundProjects[i].getName();
            }
        }
        return this.defaultBuildOrder;
    }

    private IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    private boolean includes(String[] testArray, String searchElement) {
        for (int i = 0; i < testArray.length; ++i) {
            if (!searchElement.equals(testArray[i])) continue;
            return true;
        }
        return false;
    }

    public void init(IWorkbench workbench) {
        this.workbench = workbench;
        this.setPreferenceStore(workbench.getPreferenceStore());
    }

    private void moveSelectionDown() {
        int currentIndex;
        if (this.buildList.getSelectionCount() == 1 && (currentIndex = this.buildList.getSelectionIndex()) < this.buildList.getItemCount() - 1) {
            String elementToMove = this.buildList.getItem(currentIndex);
            this.buildList.remove(currentIndex);
            this.buildList.add(elementToMove, currentIndex + 1);
            this.buildList.select(currentIndex + 1);
        }
    }

    private void moveSelectionUp() {
        int currentIndex = this.buildList.getSelectionIndex();
        if (currentIndex > 0 && this.buildList.getSelectionCount() == 1) {
            String elementToMove = this.buildList.getItem(currentIndex);
            this.buildList.remove(currentIndex);
            this.buildList.add(elementToMove, currentIndex - 1);
            this.buildList.select(currentIndex - 1);
        }
    }

    protected void performDefaults() {
        this.defaultOrderButton.setSelection(true);
        this.defaultsButtonSelected(true);
        this.maxItersField.loadDefault();
        super.performDefaults();
    }

    public boolean performOk() {
        String[] buildOrder = null;
        boolean useDefault = this.defaultOrderButton.getSelection();
        if (!useDefault) {
            buildOrder = this.buildList.getItems();
        }
        IWorkspaceDescription description = this.getWorkspace().getDescription();
        description.setBuildOrder(buildOrder);
        description.setMaxBuildIterations(this.maxItersField.getIntValue());
        try {
            this.getWorkspace().setDescription(description);
        }
        catch (CoreException exception) {
            return false;
        }
        if (!useDefault || useDefault != this.defaultOrderInitiallySelected) {
            this.defaultOrderInitiallySelected = useDefault;
            if (ResourcesPlugin.getWorkspace().isAutoBuilding()) {
                GlobalBuildAction action = new GlobalBuildAction(this.workbench.getActiveWorkbenchWindow(), 10);
                action.doBuild();
            }
        }
        this.customBuildOrder = null;
        return true;
    }

    private void removeSelection() {
        this.buildList.remove(this.buildList.getSelectionIndices());
    }

    private void setBuildOrderWidgetsEnablement(boolean value) {
        Control[] children = this.buttonComposite.getChildren();
        for (int i = 0; i < children.length; ++i) {
            children[i].setEnabled(value);
        }
    }

    private String[] sortedDifference(IProject[] allProjects, String[] currentlyDisplayed) {
        TreeSet<String> difference = new TreeSet<String>();
        for (int i = 0; i < allProjects.length; ++i) {
            if (this.includes(currentlyDisplayed, allProjects[i].getName())) continue;
            difference.add(allProjects[i].getName());
        }
        String[] returnValue = new String[difference.size()];
        difference.toArray(returnValue);
        return returnValue;
    }
}

