/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.wizards.JUnitWizard;
import org.eclipse.jdt.internal.junit.wizards.NewTestSuiteCreationWizardPage;
import org.eclipse.jdt.internal.junit.wizards.WizardMessages;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class NewTestSuiteCreationWizard
extends JUnitWizard {
    private NewTestSuiteCreationWizardPage fPage;

    public NewTestSuiteCreationWizard() {
        this.setWindowTitle(WizardMessages.getString("Wizard.title.new.testsuite"));
        this.initDialogSettings();
    }

    public void addPages() {
        super.addPages();
        this.fPage = new NewTestSuiteCreationWizardPage();
        this.addPage((IWizardPage)this.fPage);
        this.fPage.init(this.getSelection());
    }

    public boolean performFinish() {
        block11: {
            String filename;
            IPackageFragment pack = this.fPage.getPackageFragment();
            ICompilationUnit cu = pack.getCompilationUnit(filename = this.fPage.getTypeName() + ".java");
            if (cu.exists()) {
                IType suiteType;
                IMethod suiteMethod;
                boolean saveUnsavedChanges;
                IEditorPart cu_ep = EditorUtility.isOpenInEditor((Object)cu);
                if (cu_ep != null && cu_ep.isDirty() && (saveUnsavedChanges = MessageDialog.openQuestion((Shell)this.fPage.getShell(), (String)WizardMessages.getString("NewTestSuiteWiz.unsavedchangesDialog.title"), (String)WizardMessages.getFormattedString("NewTestSuiteWiz.unsavedchangesDialog.message", filename)))) {
                    try {
                        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(this.getRunnableSave(cu_ep));
                    }
                    catch (Exception e) {
                        JUnitPlugin.log(e);
                    }
                }
                if ((suiteMethod = (suiteType = cu.getType(this.fPage.getTypeName())).getMethod("suite", new String[0])).exists()) {
                    try {
                        ISourceRange range = suiteMethod.getSourceRange();
                        IBuffer buf = cu.getBuffer();
                        String originalContent = buf.getText(range.getOffset(), range.getLength());
                        int start = originalContent.indexOf("//$JUnit-BEGIN$");
                        if (start > -1) {
                            int end = originalContent.indexOf("//$JUnit-END$", start);
                            if (end < 0) {
                                this.fPage.cannotUpdateSuiteError();
                                return false;
                            }
                            break block11;
                        }
                        this.fPage.cannotUpdateSuiteError();
                        return false;
                    }
                    catch (JavaModelException e) {
                        JUnitPlugin.log(e);
                        return false;
                    }
                }
            }
        }
        if (this.finishPage(this.fPage.getRunnable())) {
            if (!this.fPage.hasUpdatedExistingClass()) {
                this.postCreatingType();
            }
            this.fPage.saveWidgetValues();
            return true;
        }
        return false;
    }

    protected void postCreatingType() {
        IResource resource;
        IType newClass = this.fPage.getCreatedType();
        if (newClass == null) {
            return;
        }
        ICompilationUnit cu = newClass.getCompilationUnit();
        if (cu.isWorkingCopy()) {
            cu = (ICompilationUnit)cu.getOriginalElement();
        }
        if ((resource = cu.getResource()) != null) {
            this.selectAndReveal(resource);
            this.openResource(resource);
        }
    }

    public NewTestSuiteCreationWizardPage getPage() {
        return this.fPage;
    }

    protected void initializeDefaultPageImageDescriptor() {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)JUnitPlugin.makeIconFileURL("wizban/newtest_wiz.gif"));
            this.setDefaultPageImageDescriptor(id);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public IRunnableWithProgress getRunnableSave(final IEditorPart cu_ep) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                cu_ep.doSave(monitor);
            }
        };
    }
}

