/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TagBits;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;

public final class MethodVerifier
implements TagBits,
TypeConstants {
    SourceTypeBinding type = null;
    HashtableOfObject inheritedMethods = null;
    HashtableOfObject currentMethods = null;
    ReferenceBinding runtimeException = null;
    ReferenceBinding errorException = null;
    LookupEnvironment environment;

    public MethodVerifier(LookupEnvironment environment) {
        this.environment = environment;
    }

    private boolean areParametersEqual(MethodBinding one, MethodBinding two) {
        TypeBinding[] oneArgs = one.parameters;
        TypeBinding[] twoArgs = two.parameters;
        if (oneArgs == twoArgs) {
            return true;
        }
        int length = oneArgs.length;
        if (length != twoArgs.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (this.areTypesEqual(oneArgs[i], twoArgs[i])) continue;
            return false;
        }
        return true;
    }

    private boolean areReturnTypesEqual(MethodBinding one, MethodBinding two) {
        return this.areTypesEqual(one.returnType, two.returnType);
    }

    private boolean areTypesEqual(TypeBinding one, TypeBinding two) {
        if (one == two) {
            return true;
        }
        if (one instanceof ReferenceBinding && two instanceof ReferenceBinding) {
            return CharOperation.equals(((ReferenceBinding)one).compoundName, ((ReferenceBinding)two).compoundName);
        }
        return false;
    }

    private void checkAbstractMethod(MethodBinding abstractMethod) {
        if (this.mustImplementAbstractMethod(abstractMethod)) {
            TypeDeclaration typeDeclaration = this.type.scope.referenceContext;
            if (typeDeclaration != null) {
                MethodDeclaration missingAbstractMethod = typeDeclaration.addMissingAbstractMethodFor(abstractMethod);
                missingAbstractMethod.scope.problemReporter().abstractMethodMustBeImplemented(this.type, abstractMethod);
            } else {
                this.problemReporter().abstractMethodMustBeImplemented(this.type, abstractMethod);
            }
        }
    }

    private void checkAgainstInheritedMethods(MethodBinding currentMethod, MethodBinding[] methods, int length) {
        int i = length;
        block0: while (--i >= 0) {
            MethodBinding inheritedMethod = methods[i];
            if (currentMethod.isStatic() != inheritedMethod.isStatic()) {
                this.problemReporter(currentMethod).staticAndInstanceConflict(currentMethod, inheritedMethod);
                continue;
            }
            if (!currentMethod.isAbstract() && inheritedMethod.isAbstract()) {
                if ((currentMethod.modifiers & 0x10000000) == 0) {
                    currentMethod.modifiers |= 0x20000000;
                }
            } else {
                currentMethod.modifiers |= 0x10000000;
            }
            if (!this.areReturnTypesEqual(currentMethod, inheritedMethod)) {
                this.problemReporter(currentMethod).incompatibleReturnType(currentMethod, inheritedMethod);
                continue;
            }
            if (currentMethod.thrownExceptions != TypeConstants.NoExceptions) {
                this.checkExceptions(currentMethod, inheritedMethod);
            }
            if (inheritedMethod.isFinal()) {
                this.problemReporter(currentMethod).finalMethodCannotBeOverridden(currentMethod, inheritedMethod);
            }
            if (!this.isAsVisible(currentMethod, inheritedMethod)) {
                this.problemReporter(currentMethod).visibilityConflict(currentMethod, inheritedMethod);
            }
            if (!this.environment.options.reportDeprecationWhenOverridingDeprecatedMethod || !inheritedMethod.isViewedAsDeprecated() || currentMethod.isViewedAsDeprecated() && !this.environment.options.reportDeprecationInsideDeprecatedCode) continue;
            ReferenceBinding declaringClass = inheritedMethod.declaringClass;
            if (declaringClass.isInterface()) {
                int j = length;
                while (--j >= 0) {
                    if (i == j || !methods[j].declaringClass.implementsInterface(declaringClass, false)) continue;
                    continue block0;
                }
            }
            this.problemReporter(currentMethod).overridesDeprecatedMethod(currentMethod, inheritedMethod);
        }
    }

    private void checkExceptions(MethodBinding newMethod, MethodBinding inheritedMethod) {
        ReferenceBinding[] newExceptions = this.resolvedExceptionTypesFor(newMethod);
        ReferenceBinding[] inheritedExceptions = this.resolvedExceptionTypesFor(inheritedMethod);
        int i = newExceptions.length;
        while (--i >= 0) {
            ReferenceBinding newException = newExceptions[i];
            int j = inheritedExceptions.length;
            while (--j > -1 && !this.isSameClassOrSubclassOf(newException, inheritedExceptions[j])) {
            }
            if (j != -1 || newException.isCompatibleWith(this.runtimeException()) || newException.isCompatibleWith(this.errorException())) continue;
            this.problemReporter(newMethod).incompatibleExceptionInThrowsClause(this.type, newMethod, inheritedMethod, newException);
        }
    }

    private void checkInheritedMethods(MethodBinding[] methods, int length) {
        int i;
        MethodBinding first = methods[0];
        int index = length;
        while (--index > 0 && this.areReturnTypesEqual(first, methods[index])) {
        }
        if (index > 0) {
            this.problemReporter().inheritedMethodsHaveIncompatibleReturnTypes(this.type, methods, length);
            return;
        }
        MethodBinding concreteMethod = null;
        if (!this.type.isInterface()) {
            i = length;
            while (--i >= 0) {
                if (methods[i].isAbstract()) continue;
                concreteMethod = methods[i];
                break;
            }
        }
        if (concreteMethod == null) {
            if (this.type.isClass() && !this.type.isAbstract()) {
                i = length;
                while (--i >= 0) {
                    if (!this.mustImplementAbstractMethod(methods[i])) continue;
                    TypeDeclaration typeDeclaration = this.type.scope.referenceContext;
                    if (typeDeclaration != null) {
                        MethodDeclaration missingAbstractMethod = typeDeclaration.addMissingAbstractMethodFor(methods[0]);
                        missingAbstractMethod.scope.problemReporter().abstractMethodMustBeImplemented(this.type, methods[0]);
                    } else {
                        this.problemReporter().abstractMethodMustBeImplemented(this.type, methods[0]);
                    }
                    return;
                }
            }
            return;
        }
        MethodBinding[] abstractMethods = new MethodBinding[length - 1];
        index = 0;
        int i2 = length;
        while (--i2 >= 0) {
            if (methods[i2] == concreteMethod) continue;
            abstractMethods[index++] = methods[i2];
        }
        if (concreteMethod.isStatic()) {
            this.problemReporter().staticInheritedMethodConflicts(this.type, concreteMethod, abstractMethods);
        }
        if (!concreteMethod.isPublic()) {
            this.problemReporter().inheritedMethodReducesVisibility(this.type, concreteMethod, abstractMethods);
        }
        if (concreteMethod.thrownExceptions != TypeConstants.NoExceptions) {
            i2 = abstractMethods.length;
            while (--i2 >= 0) {
                this.checkExceptions(concreteMethod, abstractMethods[i2]);
            }
        }
    }

    private void checkMethods() {
        boolean mustImplementAbstractMethods = this.type.isClass() && !this.type.isAbstract();
        boolean skipInheritedMethods = mustImplementAbstractMethods && this.type.superInterfaces() == TypeConstants.NoSuperInterfaces && this.type.superclass() != null && !this.type.superclass().isAbstract();
        char[][] methodSelectors = this.inheritedMethods.keyTable;
        int s = methodSelectors.length;
        while (--s >= 0) {
            int j;
            int i;
            MethodBinding[] current;
            if (methodSelectors[s] == null || (current = (MethodBinding[])this.currentMethods.get(methodSelectors[s])) == null && skipInheritedMethods) continue;
            MethodBinding[] inherited = (MethodBinding[])this.inheritedMethods.valueTable[s];
            if (inherited.length == 1 && current == null) {
                if (!mustImplementAbstractMethods || !inherited[0].isAbstract()) continue;
                this.checkAbstractMethod(inherited[0]);
                continue;
            }
            int index = -1;
            MethodBinding[] matchingInherited = new MethodBinding[inherited.length];
            if (current != null) {
                int length1 = current.length;
                for (i = 0; i < length1; ++i) {
                    while (index >= 0) {
                        matchingInherited[index--] = null;
                    }
                    MethodBinding currentMethod = current[i];
                    int length2 = inherited.length;
                    for (j = 0; j < length2; ++j) {
                        MethodBinding inheritedMethod = inherited[j];
                        if (inheritedMethod == null || !this.areParametersEqual(currentMethod, inheritedMethod)) continue;
                        matchingInherited[++index] = inheritedMethod;
                        inherited[j] = null;
                    }
                    if (index < 0) continue;
                    this.checkAgainstInheritedMethods(currentMethod, matchingInherited, index + 1);
                }
            }
            int length = inherited.length;
            for (i = 0; i < length; ++i) {
                while (index >= 0) {
                    matchingInherited[index--] = null;
                }
                MethodBinding inheritedMethod = inherited[i];
                if (inheritedMethod != null) {
                    matchingInherited[++index] = inheritedMethod;
                    for (j = i + 1; j < length; ++j) {
                        if (inherited[j] == null || !this.areParametersEqual(inheritedMethod, inherited[j])) continue;
                        matchingInherited[++index] = inherited[j];
                        inherited[j] = null;
                    }
                }
                if (index > 0) {
                    this.checkInheritedMethods(matchingInherited, index + 1);
                    continue;
                }
                if (!mustImplementAbstractMethods || index != 0 || !matchingInherited[0].isAbstract()) continue;
                this.checkAbstractMethod(matchingInherited[0]);
            }
        }
    }

    private void checkPackagePrivateAbstractMethod(MethodBinding abstractMethod) {
        ReferenceBinding superType = this.type.superclass();
        char[] selector = abstractMethod.selector;
        do {
            if (!superType.isValidBinding()) {
                return;
            }
            if (!superType.isAbstract()) {
                return;
            }
            MethodBinding[] methods = superType.getMethods(selector);
            int m = methods.length;
            while (--m >= 0) {
                MethodBinding method = methods[m];
                if (!this.areReturnTypesEqual(method, abstractMethod) || !this.areParametersEqual(method, abstractMethod) || method.isPrivate() || method.isConstructor() || method.isDefaultAbstract() || superType.fPackage != abstractMethod.declaringClass.fPackage) continue;
                return;
            }
        } while ((superType = superType.superclass()) != abstractMethod.declaringClass);
        this.problemReporter().abstractMethodCannotBeOverridden(this.type, abstractMethod);
    }

    private void computeInheritedMethods() {
        int i;
        this.inheritedMethods = new HashtableOfObject(51);
        ReferenceBinding[][] interfacesToVisit = new ReferenceBinding[3][];
        int lastPosition = -1;
        ReferenceBinding[] itsInterfaces = this.type.superInterfaces();
        if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
            interfacesToVisit[++lastPosition] = itsInterfaces;
        }
        ReferenceBinding superType = this.type.isClass() ? this.type.superclass() : this.type.scope.getJavaLangObject();
        HashtableOfObject nonVisibleDefaultMethods = new HashtableOfObject(3);
        boolean allSuperclassesAreAbstract = true;
        while (superType != null) {
            if (!superType.isValidBinding()) continue;
            if (allSuperclassesAreAbstract) {
                if (superType.isAbstract()) {
                    itsInterfaces = superType.superInterfaces();
                    if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                        if (++lastPosition == interfacesToVisit.length) {
                            ReferenceBinding[][] referenceBindingArrayArray = interfacesToVisit;
                            interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                            System.arraycopy(referenceBindingArrayArray, 0, interfacesToVisit, 0, lastPosition);
                        }
                        interfacesToVisit[lastPosition] = itsInterfaces;
                    }
                } else {
                    allSuperclassesAreAbstract = false;
                }
            }
            MethodBinding[] methods = superType.unResolvedMethods();
            int m = methods.length;
            block1: while (--m >= 0) {
                MethodBinding[] current;
                MethodBinding[] nonVisible;
                int length;
                MethodBinding method = methods[m];
                if (method.isPrivate() || method.isConstructor() || method.isDefaultAbstract()) continue;
                MethodBinding[] existingMethods = (MethodBinding[])this.inheritedMethods.get(method.selector);
                if (existingMethods != null) {
                    length = existingMethods.length;
                    for (int i2 = 0; i2 < length; ++i2) {
                        if (!this.areReturnTypesEqual(method, existingMethods[i2]) || !this.areParametersEqual(method, existingMethods[i2])) continue;
                        if (!method.isDefault() || !method.isAbstract() || method.declaringClass.fPackage == this.type.fPackage) continue block1;
                        this.checkPackagePrivateAbstractMethod(method);
                        continue block1;
                    }
                }
                if ((nonVisible = (MethodBinding[])nonVisibleDefaultMethods.get(method.selector)) != null) {
                    int l = nonVisible.length;
                    for (int i3 = 0; i3 < l; ++i3) {
                        if (this.areReturnTypesEqual(method, nonVisible[i3]) && this.areParametersEqual(method, nonVisible[i3])) continue block1;
                    }
                }
                if (!method.isDefault() || method.declaringClass.fPackage == this.type.fPackage) {
                    if (existingMethods == null) {
                        existingMethods = new MethodBinding[]{method};
                    } else {
                        length = existingMethods.length;
                        MethodBinding[] methodBindingArray = existingMethods;
                        existingMethods = new MethodBinding[length + 1];
                        System.arraycopy(methodBindingArray, 0, existingMethods, 0, length);
                        existingMethods[length] = method;
                    }
                    this.inheritedMethods.put(method.selector, existingMethods);
                    continue;
                }
                if (nonVisible == null) {
                    nonVisible = new MethodBinding[]{method};
                } else {
                    length = nonVisible.length;
                    MethodBinding[] methodBindingArray = nonVisible;
                    nonVisible = new MethodBinding[length + 1];
                    System.arraycopy(methodBindingArray, 0, nonVisible, 0, length);
                    nonVisible[length] = method;
                }
                nonVisibleDefaultMethods.put(method.selector, nonVisible);
                if (method.isAbstract() && !this.type.isAbstract()) {
                    this.problemReporter().abstractMethodCannotBeOverridden(this.type, method);
                }
                if ((current = (MethodBinding[])this.currentMethods.get(method.selector)) == null) continue;
                int length2 = current.length;
                for (int i4 = 0; i4 < length2; ++i4) {
                    if (!this.areReturnTypesEqual(method, current[i4]) || !this.areParametersEqual(method, current[i4])) continue;
                    this.problemReporter().overridesPackageDefaultMethod(current[i4], method);
                    continue block1;
                }
            }
            superType = superType.superclass();
        }
        for (i = 0; i <= lastPosition; ++i) {
            ReferenceBinding[] interfaces = interfacesToVisit[i];
            int l = interfaces.length;
            for (int j = 0; j < l; ++j) {
                superType = interfaces[j];
                if ((superType.tagBits & 0x800) != 0) continue;
                superType.tagBits |= 0x800;
                if (!superType.isValidBinding()) continue;
                itsInterfaces = superType.superInterfaces();
                if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                    if (++lastPosition == interfacesToVisit.length) {
                        ReferenceBinding[][] referenceBindingArrayArray = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                        System.arraycopy(referenceBindingArrayArray, 0, interfacesToVisit, 0, lastPosition);
                    }
                    interfacesToVisit[lastPosition] = itsInterfaces;
                }
                MethodBinding[] methods = superType.unResolvedMethods();
                int m = methods.length;
                block7: while (--m >= 0) {
                    MethodBinding method = methods[m];
                    MethodBinding[] existingMethods = (MethodBinding[])this.inheritedMethods.get(method.selector);
                    if (existingMethods == null) {
                        existingMethods = new MethodBinding[]{method};
                    } else {
                        int length = existingMethods.length;
                        for (int e = 0; e < length; ++e) {
                            MethodBinding existing = existingMethods[e];
                            if (this.areParametersEqual(method, existing) && existing.declaringClass.implementsInterface(superType, true)) continue block7;
                        }
                        MethodBinding[] methodBindingArray = existingMethods;
                        existingMethods = new MethodBinding[length + 1];
                        System.arraycopy(methodBindingArray, 0, existingMethods, 0, length);
                        existingMethods[length] = method;
                    }
                    this.inheritedMethods.put(method.selector, existingMethods);
                }
            }
        }
        for (i = 0; i <= lastPosition; ++i) {
            ReferenceBinding[] interfaces = interfacesToVisit[i];
            int length = interfaces.length;
            for (int j = 0; j < length; ++j) {
                interfaces[j].tagBits &= 0xFFFFF7FF;
            }
        }
    }

    private void computeMethods() {
        MethodBinding[] methods = this.type.methods();
        int size = methods.length;
        this.currentMethods = new HashtableOfObject(size == 0 ? 1 : size);
        int m = size;
        while (--m >= 0) {
            MethodBinding method = methods[m];
            if (method.isConstructor() || method.isDefaultAbstract()) continue;
            MethodBinding[] existingMethods = (MethodBinding[])this.currentMethods.get(method.selector);
            if (existingMethods == null) {
                existingMethods = new MethodBinding[1];
            } else {
                MethodBinding[] methodBindingArray = existingMethods;
                existingMethods = new MethodBinding[existingMethods.length + 1];
                System.arraycopy(methodBindingArray, 0, existingMethods, 0, existingMethods.length - 1);
            }
            existingMethods[existingMethods.length - 1] = method;
            this.currentMethods.put(method.selector, existingMethods);
        }
    }

    private ReferenceBinding errorException() {
        if (this.errorException == null) {
            this.errorException = this.type.scope.getJavaLangError();
        }
        return this.errorException;
    }

    private boolean isAsVisible(MethodBinding newMethod, MethodBinding inheritedMethod) {
        if (inheritedMethod.modifiers == newMethod.modifiers) {
            return true;
        }
        if (newMethod.isPublic()) {
            return true;
        }
        if (inheritedMethod.isPublic()) {
            return false;
        }
        if (newMethod.isProtected()) {
            return true;
        }
        if (inheritedMethod.isProtected()) {
            return false;
        }
        return !newMethod.isPrivate();
    }

    private boolean isSameClassOrSubclassOf(ReferenceBinding testClass, ReferenceBinding superclass) {
        do {
            if (testClass != superclass) continue;
            return true;
        } while ((testClass = testClass.superclass()) != null);
        return false;
    }

    private boolean mustImplementAbstractMethod(MethodBinding abstractMethod) {
        ReferenceBinding superclass;
        ReferenceBinding declaringClass = abstractMethod.declaringClass;
        if (declaringClass.isClass()) {
            for (superclass = this.type.superclass(); superclass.isAbstract() && superclass != declaringClass; superclass = superclass.superclass()) {
            }
        } else {
            if (this.type.implementsInterface(declaringClass, false)) {
                if (this.type.isAbstract()) {
                    return false;
                }
                if (!superclass.implementsInterface(declaringClass, true)) {
                    return true;
                }
            }
            while (superclass.isAbstract() && !superclass.implementsInterface(declaringClass, false)) {
                superclass = superclass.superclass();
            }
        }
        return superclass.isAbstract();
    }

    private ProblemReporter problemReporter() {
        return this.type.scope.problemReporter();
    }

    private ProblemReporter problemReporter(MethodBinding currentMethod) {
        ProblemReporter reporter = this.problemReporter();
        if (currentMethod.declaringClass == this.type) {
            reporter.referenceContext = currentMethod.sourceMethod();
        }
        return reporter;
    }

    ReferenceBinding[] resolvedExceptionTypesFor(MethodBinding method) {
        ReferenceBinding[] exceptions = method.thrownExceptions;
        if ((method.modifiers & 0x2000000) == 0) {
            return exceptions;
        }
        if (!(method.declaringClass instanceof BinaryTypeBinding)) {
            return TypeConstants.NoExceptions;
        }
        BinaryTypeBinding binaryType = (BinaryTypeBinding)method.declaringClass;
        int i = exceptions.length;
        while (--i >= 0) {
            if (!(exceptions[i] instanceof UnresolvedReferenceBinding)) continue;
            exceptions[i] = (ReferenceBinding)binaryType.resolveType(exceptions[i]);
        }
        return exceptions;
    }

    private ReferenceBinding runtimeException() {
        if (this.runtimeException == null) {
            this.runtimeException = this.type.scope.getJavaLangRuntimeException();
        }
        return this.runtimeException;
    }

    public void verify(SourceTypeBinding someType) {
        this.type = someType;
        this.computeMethods();
        this.computeInheritedMethods();
        this.checkMethods();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(10);
        buffer.append("MethodVerifier for type: ");
        buffer.append(this.type.readableName());
        buffer.append('\n');
        buffer.append("\t-inherited methods: ");
        buffer.append(this.inheritedMethods);
        return buffer.toString();
    }
}

