/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class FieldBinding
extends VariableBinding {
    public ReferenceBinding declaringClass;

    protected FieldBinding() {
    }

    public FieldBinding(char[] name, TypeBinding type, int modifiers, ReferenceBinding declaringClass, Constant constant) {
        this.modifiers = modifiers;
        this.type = type;
        this.name = name;
        this.declaringClass = declaringClass;
        this.constant = constant;
        if (this.declaringClass != null && this.declaringClass.isViewedAsDeprecated() && !this.isDeprecated()) {
            this.modifiers |= 0x200000;
        }
    }

    public FieldBinding(FieldDeclaration field, TypeBinding type, int modifiers, ReferenceBinding declaringClass) {
        this(field.name, type, modifiers, declaringClass, null);
        field.binding = this;
    }

    public FieldBinding(FieldBinding initialFieldBinding, ReferenceBinding declaringClass) {
        this.modifiers = initialFieldBinding.modifiers;
        this.type = initialFieldBinding.type;
        this.name = initialFieldBinding.name;
        this.declaringClass = declaringClass;
        this.constant = initialFieldBinding.constant;
        this.id = initialFieldBinding.id;
    }

    public final int bindingType() {
        return 1;
    }

    public final boolean canBeSeenBy(TypeBinding receiverType, InvocationSite invocationSite, Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding invocationType = scope.enclosingSourceType();
        if (invocationType == this.declaringClass && invocationType == receiverType) {
            return true;
        }
        if (this.isProtected()) {
            if (invocationType == this.declaringClass) {
                return true;
            }
            if (invocationType.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            ReferenceBinding currentType = invocationType;
            int depth = 0;
            do {
                if (this.declaringClass.isSuperclassOf(currentType)) {
                    if (invocationSite.isSuperAccess()) {
                        return true;
                    }
                    if (receiverType instanceof ArrayBinding) {
                        return false;
                    }
                    if (this.isStatic()) {
                        if (depth > 0) {
                            invocationSite.setDepth(depth);
                        }
                        return true;
                    }
                    if (currentType == receiverType || currentType.isSuperclassOf((ReferenceBinding)receiverType)) {
                        if (depth > 0) {
                            invocationSite.setDepth(depth);
                        }
                        return true;
                    }
                }
                ++depth;
            } while ((currentType = currentType.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            if (receiverType != this.declaringClass) {
                return false;
            }
            if (invocationType != this.declaringClass) {
                ReferenceBinding temp;
                ReferenceBinding outerInvocationType = invocationType;
                for (temp = outerInvocationType.enclosingType(); temp != null; temp = temp.enclosingType()) {
                    outerInvocationType = temp;
                }
                ReferenceBinding outerDeclaringClass = this.declaringClass;
                for (temp = outerDeclaringClass.enclosingType(); temp != null; temp = temp.enclosingType()) {
                    outerDeclaringClass = temp;
                }
                if (outerInvocationType != outerDeclaringClass) {
                    return false;
                }
            }
            return true;
        }
        if (invocationType.fPackage != this.declaringClass.fPackage) {
            return false;
        }
        if (receiverType instanceof ArrayBinding) {
            return false;
        }
        ReferenceBinding currentType = (ReferenceBinding)receiverType;
        PackageBinding declaringPackage = this.declaringClass.fPackage;
        do {
            if (this.declaringClass == currentType) {
                return true;
            }
            if (declaringPackage == currentType.fPackage) continue;
            return false;
        } while ((currentType = currentType.superclass()) != null);
        return false;
    }

    public final int getAccessFlags() {
        return this.modifiers & 0xFFFF;
    }

    public final boolean isDefault() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isPrivateUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isSynthetic() {
        return (this.modifiers & 0x1000) != 0;
    }

    public final boolean isTransient() {
        return (this.modifiers & 0x80) != 0;
    }

    public final boolean isViewedAsDeprecated() {
        return (this.modifiers & 0x100000) != 0 || (this.modifiers & 0x200000) != 0;
    }

    public final boolean isVolatile() {
        return (this.modifiers & 0x40) != 0;
    }
}

