/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ArrayTypeReference
extends SingleTypeReference {
    public int dimensions;

    public ArrayTypeReference(char[] source, int dimensions, long pos) {
        super(source, pos);
        this.dimensions = dimensions;
    }

    public ArrayTypeReference(char[] source, TypeBinding tb, int dimensions, long pos) {
        super(source, tb, pos);
        this.dimensions = dimensions;
    }

    public int dimensions() {
        return this.dimensions;
    }

    public TypeBinding getTypeBinding(Scope scope) {
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        if (this.dimensions > 255) {
            scope.problemReporter().tooManyDimensions(this);
        }
        return scope.createArray(scope.getType(this.token), this.dimensions);
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        super.printExpression(indent, output);
        for (int i = 0; i < this.dimensions; ++i) {
            output.append("[]");
        }
        return output;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }
}

