/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.util.Calendar;
import java.util.Properties;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;

public class QualifierReplacer
implements IBuildPropertiesConstants {
    private static final String DOT_QUALIFIER = ".qualifier";

    public static String replaceQualifierInVersion(String version, String id, String replaceTag, Properties newVersions) {
        if (replaceTag == null) {
            return null;
        }
        if (!version.endsWith(DOT_QUALIFIER)) {
            return null;
        }
        String newQualifier = null;
        if (replaceTag.equalsIgnoreCase("context")) {
            if (newVersions.size() != 0 && (newQualifier = (String)newVersions.get(id)) == null) {
                newQualifier = newVersions.getProperty("*");
            }
            if (newQualifier == null) {
                newQualifier = QualifierReplacer.getDate();
            }
            newQualifier = '.' + newQualifier;
        } else {
            newQualifier = replaceTag.equalsIgnoreCase("none") ? "" : '.' + replaceTag;
        }
        return version.replaceFirst(DOT_QUALIFIER, newQualifier);
    }

    private static String getDate() {
        String empty = "";
        int monthNbr = Calendar.getInstance().get(2) + 1;
        String month = (monthNbr < 10 ? "0" : "") + monthNbr;
        int dayNbr = Calendar.getInstance().get(5);
        String day = (dayNbr < 10 ? "0" : "") + dayNbr;
        int hourNbr = Calendar.getInstance().get(11);
        String hour = (hourNbr < 10 ? "0" : "") + hourNbr;
        int minuteNbr = Calendar.getInstance().get(12);
        String minute = (minuteNbr < 10 ? "0" : "") + minuteNbr;
        return "" + Calendar.getInstance().get(1) + month + day + hour + minute;
    }
}

