/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import java.util.Arrays;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.ListSelectionArea;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.WorkingSetSelectionArea;
import org.eclipse.team.internal.ccvs.ui.model.RemoteContentProvider;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ccvs.ui.repo.RepositorySorter;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class RefreshRemoteProjectSelectionPage
extends CVSWizardPage {
    private Dialog parentDialog;
    private ICVSRepositoryLocation root;
    private ICVSRemoteResource[] rootFolders;
    private ListSelectionArea listArea;
    private WorkingSetSelectionArea workingSetArea;
    private IWorkingSet workingSet;
    private IDialogSettings settings;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public RefreshRemoteProjectSelectionPage(String pageName, String title, ImageDescriptor titleImage, String description, Dialog parentDialog, IDialogSettings settings, ICVSRepositoryLocation root, ICVSRemoteResource[] rootFolders) {
        super(pageName, title, titleImage, description);
        this.parentDialog = parentDialog;
        this.settings = settings;
        this.root = root;
        this.rootFolders = rootFolders;
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        this.setControl((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.team.cvs.ui.refresh_remote_project_selection_page_context");
        this.listArea = new ListSelectionArea(this.parentDialog, new InputElement(), (IStructuredContentProvider)new RemoteContentProvider(), (ILabelProvider)new WorkbenchLabelProvider(), Policy.bind("RefreshRemoteProjectSelectionPage.selectRemoteProjects"));
        this.listArea.createArea(composite);
        this.listArea.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                RefreshRemoteProjectSelectionPage.this.updateEnablement();
            }
        });
        this.listArea.getViewer().setSorter((ViewerSorter)new RepositorySorter());
        this.workingSetArea = new WorkingSetSelectionArea(this.parentDialog, Policy.bind("RefreshRemoteProjectSelectionPage.noWorkingSet"), Policy.bind("RefreshRemoteProjectSelectionPage.workingSet"), this.settings);
        this.setWorkingSet(this.workingSet);
        this.workingSetArea.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                RefreshRemoteProjectSelectionPage.this.workingSet = (IWorkingSet)event.getNewValue();
                RefreshRemoteProjectSelectionPage.this.handleWorkingSetChange();
            }
        });
        this.workingSetArea.createArea(composite);
        Dialog.applyDialogFont((Control)parent);
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        this.workingSet = workingSet;
        if (this.workingSetArea != null) {
            this.workingSetArea.setWorkingSet(workingSet);
        }
    }

    private void handleWorkingSetChange() {
        if (this.workingSet != null) {
            this.listArea.getViewer().setAllChecked(false);
            RepositoryManager manager = CVSUIPlugin.getPlugin().getRepositoryManager();
            ICVSRemoteResource[] resources = manager.filterResources(this.workingSet, this.rootFolders);
            for (int i = 0; i < resources.length; ++i) {
                ICVSRemoteResource resource = resources[i];
                this.listArea.getViewer().setChecked((Object)resource, true);
            }
        }
    }

    private void updateEnablement() {
        boolean atLeastOne = this.listArea.getViewer().getCheckedElements().length > 0;
        this.setPageComplete(atLeastOne);
    }

    public ICVSRemoteResource[] getSelectedRemoteProject() {
        Object[] checked = this.listArea.getViewer().getCheckedElements();
        return Arrays.asList(checked).toArray(new ICVSRemoteResource[checked.length]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class InputElement
    implements IWorkbenchAdapter,
    IAdaptable {
        private InputElement() {
        }

        public Object[] getChildren(Object o) {
            return RefreshRemoteProjectSelectionPage.this.rootFolders;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return null;
        }

        public Object getParent(Object o) {
            return null;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == (class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = RefreshRemoteProjectSelectionPage.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) {
                return this;
            }
            return null;
        }
    }
}

