/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.IFileTypeInfo;
import org.eclipse.team.core.IIgnoreInfo;
import org.eclipse.team.core.Team;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IUserAuthenticator;
import org.eclipse.team.internal.ccvs.core.IUserInfo;
import org.eclipse.team.internal.ccvs.ui.AlternateUserValidationDialog;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.KeyboardInteractiveDialog;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.UserValidationDialog;
import org.eclipse.team.internal.ui.Utils;

public class WorkbenchUserAuthenticator
implements IUserAuthenticator {
    public static boolean USE_ALTERNATE_PROMPTER = false;

    public WorkbenchUserAuthenticator() {
        IIgnoreInfo[] ignores = Team.getAllIgnores();
        boolean found = false;
        for (int i = 0; i < ignores.length; ++i) {
            if (!ignores[i].getPattern().equals("*.notes")) continue;
            found = true;
        }
        if (!found) {
            return;
        }
        IFileTypeInfo[] types = Team.getAllTypes();
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].getExtension().equals("notes")) continue;
            USE_ALTERNATE_PROMPTER = true;
            return;
        }
        USE_ALTERNATE_PROMPTER = false;
    }

    public void promptForUserInfo(final ICVSRepositoryLocation location, final IUserInfo userinfo, final String message) throws CVSException {
        if (!userinfo.isUsernameMutable() && USE_ALTERNATE_PROMPTER) {
            this.alternatePromptForUserInfo(userinfo);
            return;
        }
        final String[] result = new String[2];
        Display display = Display.getCurrent();
        final boolean[] allowCaching = new boolean[]{false};
        if (display != null) {
            allowCaching[0] = this.promptForPassword(location, userinfo.getUsername(), message, userinfo.isUsernameMutable(), result);
        } else {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    allowCaching[0] = WorkbenchUserAuthenticator.this.promptForPassword(location, userinfo.getUsername(), message, userinfo.isUsernameMutable(), result);
                }
            });
        }
        if (result[0] == null) {
            throw new OperationCanceledException(Policy.bind("WorkbenchUserAuthenticator.cancelled"));
        }
        if (userinfo.isUsernameMutable()) {
            userinfo.setUsername(result[0]);
        }
        userinfo.setPassword(result[1]);
        if (location != null) {
            if (userinfo.isUsernameMutable()) {
                location.setUsername(result[0]);
            }
            location.setPassword(result[1]);
            location.setAllowCaching(allowCaching[0]);
        }
    }

    private boolean promptForPassword(ICVSRepositoryLocation location, String username, String message, boolean userMutable, String[] result) {
        Shell shell = Utils.findShell();
        if (shell == null) {
            return false;
        }
        String domain = location == null ? null : location.getLocation();
        UserValidationDialog dialog = new UserValidationDialog(shell, domain, username == null ? "" : username, message);
        dialog.setUsernameMutable(userMutable);
        dialog.open();
        result[0] = dialog.getUsername();
        result[1] = dialog.getPassword();
        return dialog.getAllowCaching();
    }

    public String[] promptForKeyboradInteractive(final ICVSRepositoryLocation location, final String destination, final String name, final String instruction, final String[] prompt, final boolean[] echo) throws CVSException {
        final String[][] result = new String[1][];
        Display display = Display.getCurrent();
        if (display != null) {
            result[0] = this._promptForUserInteractive(location, destination, name, instruction, prompt, echo);
        } else {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    result[0] = WorkbenchUserAuthenticator.this._promptForUserInteractive(location, destination, name, instruction, prompt, echo);
                }
            });
        }
        return result[0];
    }

    private String[] _promptForUserInteractive(ICVSRepositoryLocation location, String destination, String name, String instruction, String[] prompt, boolean[] echo) {
        Shell shell = Utils.findShell();
        if (shell == null) {
            return new String[0];
        }
        String domain = location == null ? null : location.getLocation();
        KeyboardInteractiveDialog dialog = new KeyboardInteractiveDialog(shell, domain, destination, name, instruction, prompt, echo);
        dialog.open();
        return dialog.getResult();
    }

    private String alternatePromptForPassword(String username) {
        Shell shell = Utils.findShell();
        AlternateUserValidationDialog dialog = new AlternateUserValidationDialog(shell, username == null ? "" : username);
        dialog.setUsername(username);
        int result = dialog.open();
        if (result == 1) {
            return null;
        }
        return dialog.getPassword();
    }

    public void alternatePromptForUserInfo(final IUserInfo userinfo) throws CVSException {
        final String[] result = new String[1];
        Display display = Display.getCurrent();
        if (display != null) {
            result[0] = this.alternatePromptForPassword(userinfo.getUsername());
        } else {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    result[0] = WorkbenchUserAuthenticator.this.alternatePromptForPassword(userinfo.getUsername());
                }
            });
        }
        if (result[0] == null) {
            throw new OperationCanceledException(Policy.bind("WorkbenchUserAuthenticator.The_operation_was_canceled_by_the_user_1"));
        }
        userinfo.setPassword(result[0]);
    }

    public int prompt(ICVSRepositoryLocation location, final int promptType, final String title, final String message, int[] promptResponses, int defaultResponse) {
        final Display display = CVSUIPlugin.getStandardDisplay();
        final int[] retval = new int[1];
        final String[] buttons = new String[promptResponses.length];
        block6: for (int i = 0; i < promptResponses.length; ++i) {
            int prompt = promptResponses[i];
            switch (prompt) {
                case 0: {
                    buttons[i] = IDialogConstants.OK_LABEL;
                    continue block6;
                }
                case 1: {
                    buttons[i] = IDialogConstants.CANCEL_LABEL;
                    continue block6;
                }
                case 3: {
                    buttons[i] = IDialogConstants.NO_LABEL;
                    continue block6;
                }
                case 2: {
                    buttons[i] = IDialogConstants.YES_LABEL;
                }
            }
        }
        display.syncExec(new Runnable(){

            public void run() {
                MessageDialog dialog = new MessageDialog(new Shell(display), title, null, message, promptType, buttons, 1);
                retval[0] = dialog.open();
            }
        });
        return retval[0];
    }
}

