/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.team.internal.ccvs.ui.AdaptableResourceList;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class AdaptableHierarchicalResourceList
extends AdaptableResourceList {
    private IContainer root;

    public AdaptableHierarchicalResourceList(IContainer root, IResource[] resources) {
        super(resources);
        this.root = root;
    }

    public Object[] getChildren(Object o) {
        return this.getChildenFor(this.root);
    }

    private IResource[] getChildenFor(IContainer parent) {
        HashSet<Object> children = new HashSet<Object>();
        IPath parentPath = parent.getFullPath();
        for (int i = 0; i < this.resources.length; ++i) {
            IResource resource = this.resources[i];
            IPath resourcePath = resource.getFullPath();
            if (parent instanceof IWorkspaceRoot) {
                children.add(((IWorkspaceRoot)parent).getProject(resourcePath.segment(0)));
                continue;
            }
            if (!parentPath.isPrefixOf(resourcePath)) continue;
            IPath parentRelativePath = resourcePath.removeFirstSegments(parentPath.segmentCount());
            if (parentRelativePath.segmentCount() == 1) {
                children.add(resource);
                continue;
            }
            if (parentRelativePath.segmentCount() <= 1) continue;
            children.add(parent.getFolder((IPath)new Path(parentRelativePath.segment(0))));
        }
        return children.toArray(new IResource[children.size()]);
    }

    public ITreeContentProvider getTreeContentProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof IContainer) {
                    return AdaptableHierarchicalResourceList.this.getChildenFor((IContainer)o);
                }
                return super.getChildren(o);
            }
        };
    }

    public void setResources(IResource[] resources) {
        this.resources = resources;
    }

    public IContainer getRoot() {
        return this.root;
    }

    public void setRoot(IContainer root) {
        this.root = root;
    }
}

