/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.internal.core.BinaryRepositoryProvider;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.team.core.RepositoryProvider;

public class BinaryProjectFilter
extends ViewerFilter {
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IProject project = null;
        if (element instanceof IJavaProject) {
            project = ((IJavaProject)element).getProject();
        } else if (element instanceof IProject) {
            project = (IProject)element;
        }
        if (project != null && (this.isPluginProject(project) || this.isFeatureProject(project))) {
            return !this.isBinary(project);
        }
        return true;
    }

    private boolean isPluginProject(IProject project) {
        if (!project.isOpen()) {
            return false;
        }
        return project.exists((IPath)new Path("plugin.xml")) || project.exists((IPath)new Path("fragment.xml")) || project.exists((IPath)new Path("META-INF/MANIFEST.MF"));
    }

    private boolean isFeatureProject(IProject project) {
        if (!project.isOpen()) {
            return false;
        }
        return project.exists((IPath)new Path("feature.xml"));
    }

    private boolean isBinary(IProject project) {
        try {
            String binary = project.getPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY);
            if (binary != null) {
                RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
                return provider == null || provider instanceof BinaryRepositoryProvider;
            }
        }
        catch (CoreException e) {
            PDECore.logException((Throwable)e);
        }
        return false;
    }
}

