/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.extension;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.ElementList;
import org.eclipse.pde.internal.ui.wizards.extension.ExtensionEditorSelectionPage;
import org.eclipse.pde.internal.ui.wizards.extension.NewExtensionRegistryReader;

public class ExtensionEditorWizard
extends Wizard {
    public static final String PLUGIN_POINT = "newExtension";
    public static final String STATUS_MESSAGE = "ExtensionEditorWizard.statusMessage";
    private static final String KEY_WTITLE = "ExtensionEditorWizard.wtitle";
    private ExtensionEditorSelectionPage pointPage;
    private IPluginModelBase model;
    private IProject project;
    private IStructuredSelection selection;
    private ElementList wizards;

    public ExtensionEditorWizard(IProject project, IPluginModelBase model, IStructuredSelection selection) {
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWEX_WIZ);
        this.model = model;
        this.project = project;
        this.selection = selection;
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(PDEPlugin.getResourceString(KEY_WTITLE));
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        this.loadWizardCollection();
    }

    public void addPages() {
        this.pointPage = new ExtensionEditorSelectionPage(this.wizards);
        this.pointPage.init(this.project, this.model.getPluginBase(), this.selection);
        this.addPage((IWizardPage)this.pointPage);
    }

    private void loadWizardCollection() {
        NewExtensionRegistryReader reader = new NewExtensionRegistryReader(true);
        this.wizards = reader.readRegistry(PDEPlugin.getPluginId(), PLUGIN_POINT, true);
    }

    public boolean performFinish() {
        return true;
    }

    public void dispose() {
        super.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
    }
}

