/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ischema.IDocumentSection;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.XMLConfiguration;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.XMLPartitionScanner;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class DocSection
extends PDESection {
    public static final String SECTION_TITLE = "SchemaEditor.DocSection.title";
    public static final String KEY_APPLY = "Actions.apply.flabel";
    public static final String KEY_RESET = "Actions.reset.flabel";
    public static final String SECTION_DESC = "SchemaEditor.DocSection.desc";
    public static final String KEY_TOPIC_OVERVIEW = "SchemaEditor.topic.overview";
    public static final String KEY_TOPIC_SINCE = "SchemaEditor.topic.since";
    public static final String KEY_TOPIC_EXAMPLES = "SchemaEditor.topic.examples";
    public static final String KEY_TOPIC_IMPLEMENTATION = "SchemaEditor.topic.implementation";
    public static final String KEY_TOPIC_API = "SchemaEditor.topic.api";
    public static final String KEY_TOPIC_COPYRIGHT = "SchemaEditor.topic.copyright";
    private IDocument document;
    private IDocumentPartitioner partitioner;
    private SourceViewerConfiguration sourceConfiguration;
    private SourceViewer sourceViewer;
    private CTabFolder tabFolder;
    private ISchema schema;
    private Button applyButton;
    private Button resetButton;
    private Object element;
    private boolean ignoreChange;

    public DocSection(PDEFormPage page, Composite parent, IColorManager colorManager) {
        super(page, parent, 4224, false);
        String description = PDEPlugin.getResourceString(SECTION_DESC);
        this.getSection().setDescription(description);
        this.sourceConfiguration = new XMLConfiguration(colorManager);
        this.document = new Document();
        this.partitioner = new DefaultPartitioner((IPartitionTokenScanner)new XMLPartitionScanner(), new String[]{"__xml_tag", "__xml_comment"});
        this.partitioner.connect(this.document);
        this.document.setDocumentPartitioner(this.partitioner);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    public void commit(boolean onSave) {
        this.handleApply();
        if (onSave) {
            this.resetButton.setEnabled(false);
        }
        super.commit(onSave);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 5;
        layout.verticalSpacing = 8;
        container.setLayout((Layout)layout);
        this.schema = (ISchema)this.getPage().getModel();
        this.tabFolder = new CTabFolder(container, 0x800080);
        toolkit.adapt((Control)this.tabFolder, true, true);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = 2;
        this.tabFolder.setLayoutData((Object)gd);
        toolkit.getColors().initializeSectionToolBarColors();
        Color selectedColor1 = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        Color selectedColor2 = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_GBG");
        this.tabFolder.setSelectionBackground(new Color[]{selectedColor1, selectedColor2, toolkit.getColors().getBackground()}, new int[]{50, 100}, true);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DocSection.this.updateTabSelection();
            }
        });
        int styles = 834;
        this.sourceViewer = new SourceViewer(container, null, styles);
        this.sourceViewer.configure(this.sourceConfiguration);
        this.sourceViewer.setDocument(this.document);
        this.sourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DocSection.this.updateSelection(event.getSelection());
            }
        });
        StyledText styledText = this.sourceViewer.getTextWidget();
        styledText.setFont(JFaceResources.getTextFont());
        styledText.setMenu(this.getPage().getPDEEditor().getContextMenu());
        styledText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        if (!SWT.getPlatform().equals("motif")) {
            toolkit.paintBordersFor(container);
        }
        Control[] children = container.getChildren();
        Control control = children[children.length - 1];
        gd = new GridData(1808);
        gd.widthHint = 50;
        gd.heightHint = 50;
        control.setLayoutData((Object)gd);
        Composite buttonContainer = toolkit.createComposite(container);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonContainer.setLayout((Layout)layout);
        gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        this.applyButton = toolkit.createButton(buttonContainer, PDEPlugin.getResourceString(KEY_APPLY), 8);
        this.applyButton.setEnabled(false);
        gd = new GridData(770);
        this.applyButton.setLayoutData((Object)gd);
        this.applyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DocSection.this.handleApply();
            }
        });
        this.resetButton = toolkit.createButton(buttonContainer, PDEPlugin.getResourceString(KEY_RESET), 8);
        this.resetButton.setEnabled(false);
        gd = new GridData(770);
        this.resetButton.setLayoutData((Object)gd);
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DocSection.this.handleReset();
            }
        });
        this.createTabs();
        section.setClient((Control)container);
        this.initialize();
        if (this.tabFolder.getItemCount() > 0) {
            this.tabFolder.setSelection(0);
            this.updateTabSelection();
        }
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.sourceViewer.doOperation(3);
            return true;
        }
        if (actionId.equals(ActionFactory.COPY.getId())) {
            this.sourceViewer.doOperation(4);
            return true;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.sourceViewer.doOperation(5);
            return true;
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            this.sourceViewer.doOperation(7);
            return true;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.sourceViewer.doOperation(6);
            return true;
        }
        if (actionId.equals(ActionFactory.UNDO.getId())) {
            this.sourceViewer.doOperation(1);
            return true;
        }
        if (actionId.equals(ActionFactory.REDO.getId())) {
            this.sourceViewer.doOperation(2);
            return true;
        }
        return false;
    }

    protected void fillContextMenu(IMenuManager manager) {
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    public boolean setFormInput(Object input) {
        int index = -1;
        if (input instanceof ISchema) {
            index = 0;
        } else if (input instanceof IDocumentSection) {
            IDocumentSection[] sections = this.schema.getDocumentSections();
            for (int i = 0; i < sections.length; ++i) {
                IDocumentSection section = sections[i];
                if (!section.equals(input)) continue;
                index = i + 1;
                break;
            }
        }
        if (index != -1) {
            this.tabFolder.setSelection(index);
        }
        this.updateEditorInput(input);
        return true;
    }

    private String getTopicName(Object object) {
        if (object instanceof ISchema) {
            return PDEPlugin.getResourceString(KEY_TOPIC_OVERVIEW);
        }
        if (object instanceof IDocumentSection) {
            IDocumentSection section = (IDocumentSection)object;
            String sectionId = section.getSectionId();
            if (sectionId.equals("examples")) {
                return PDEPlugin.getResourceString(KEY_TOPIC_EXAMPLES);
            }
            if (sectionId.equals("since")) {
                return PDEPlugin.getResourceString(KEY_TOPIC_SINCE);
            }
            if (sectionId.equals("implementation")) {
                return PDEPlugin.getResourceString(KEY_TOPIC_IMPLEMENTATION);
            }
            if (sectionId.equals("apiInfo")) {
                return PDEPlugin.getResourceString(KEY_TOPIC_API);
            }
            if (sectionId.equals("copyright")) {
                return PDEPlugin.getResourceString(KEY_TOPIC_COPYRIGHT);
            }
        }
        return "?";
    }

    private void handleApply() {
        if (this.element != null) {
            if (this.element instanceof ISchema) {
                ((Schema)this.element).setDescription(this.document.get());
            } else {
                ((SchemaObject)this.element).setDescription(this.document.get());
            }
            this.updateTabImage(this.tabFolder.getSelection());
        }
        this.applyButton.setEnabled(false);
        this.resetButton.setEnabled(false);
    }

    private void handleReset() {
        this.updateEditorInput(this.element);
        this.updateTabImage(this.tabFolder.getSelection());
    }

    public void initialize() {
        this.sourceViewer.setEditable(this.schema.isEditable());
        this.document.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (!DocSection.this.ignoreChange && DocSection.this.schema.isEditable()) {
                    DocSection.this.markDirty();
                }
                DocSection.this.applyButton.setEnabled(true);
                DocSection.this.resetButton.setEnabled(true);
            }

            public void documentAboutToBeChanged(DocumentEvent e) {
            }
        });
        this.updateEditorInput(this.schema);
        this.schema.addModelChangedListener((IModelChangedListener)this);
    }

    public void dispose() {
        this.schema.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    private void createTabs() {
        IDocumentSection[] sections = this.schema.getDocumentSections();
        this.addTab((ISchemaObject)this.schema);
        for (int i = 0; i < sections.length; ++i) {
            IDocumentSection section = sections[i];
            this.addTab((ISchemaObject)section);
        }
    }

    public void checkForPendingChanges() {
        if (this.applyButton.isEnabled()) {
            this.handleApply();
        }
    }

    private void addTab(ISchemaObject section) {
        String label = this.getTopicName(section);
        CTabItem item = new CTabItem(this.tabFolder, 0);
        item.setText(label);
        item.setData((Object)section);
        this.updateTabImage(item);
    }

    private void updateTabImage(CTabItem item) {
        if (item == null) {
            return;
        }
        ISchemaObject section = (ISchemaObject)item.getData();
        if (section == null) {
            return;
        }
        item.setImage(PDEPlugin.getDefault().getLabelProvider().getImage(section));
    }

    private void updateTabSelection() {
        int index = this.tabFolder.getSelectionIndex();
        if (this.schema.isEditable() && this.isDirty()) {
            this.handleApply();
        }
        if (index == 0) {
            this.updateEditorInput(this.schema);
        } else {
            IDocumentSection[] sections = this.schema.getDocumentSections();
            this.updateEditorInput(sections[index - 1]);
        }
    }

    public void setFocus() {
        this.sourceViewer.getTextWidget().setFocus();
        this.updateSelection(this.sourceViewer.getSelection());
    }

    private void updateSelection(ISelection selection) {
        this.getPage().getPDEEditor().setSelection(selection);
    }

    public void updateEditorInput(Object input) {
        this.ignoreChange = true;
        String text = "";
        if (input instanceof ISchemaObject) {
            text = ((ISchemaObject)input).getDescription();
        }
        if (text == null) {
            text = "";
        }
        this.document.set(text);
        this.applyButton.setEnabled(false);
        this.resetButton.setEnabled(false);
        this.element = input;
        this.ignoreChange = false;
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
        }
    }

    public void refresh() {
        IDocumentSection[] sections;
        int itemCount = this.tabFolder.getItemCount();
        if (itemCount != (sections = this.schema.getDocumentSections()).length + 1) {
            this.disposeAllTabs();
            this.createTabs();
            this.getPage().getManagedForm().getForm().reflow(true);
            this.updateEditorInput(this.schema);
        } else {
            int index = this.tabFolder.getSelectionIndex();
            if (index == 0) {
                this.updateEditorInput(this.schema);
            } else {
                this.updateEditorInput(sections[index - 1]);
            }
        }
        super.refresh();
    }

    private void disposeAllTabs() {
        CTabItem[] items = this.tabFolder.getItems();
        for (int i = 0; i < items.length; ++i) {
            items[i].dispose();
        }
    }

    public boolean canPaste(Clipboard clipboard) {
        return this.sourceViewer.canDoOperation(5);
    }
}

