/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.editor.FormOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.context.InputContext;

public class ManifestOutlinePage
extends FormOutlinePage {
    public ManifestOutlinePage(PDEFormEditor editor) {
        super(editor);
    }

    protected Object[] getChildren(Object parent) {
        if (parent instanceof PDEFormPage) {
            PDEFormPage page = (PDEFormPage)((Object)parent);
            IPluginModelBase model = (IPluginModelBase)page.getModel();
            IBuildModel buildModel = this.getBuildModel();
            if (model.isValid()) {
                IPluginBase pluginBase = model.getPluginBase();
                if (page.getId().equals("dependencies")) {
                    return pluginBase.getImports();
                }
                if (page.getId().equals("runtime")) {
                    return pluginBase.getLibraries();
                }
                if (page.getId().equals("extensions")) {
                    return pluginBase.getExtensions();
                }
                if (page.getId().equals("ex-points")) {
                    return pluginBase.getExtensionPoints();
                }
            }
            if (buildModel != null && buildModel.isValid() && page.getId().equals("build")) {
                return buildModel.getBuild().getBuildEntries();
            }
        }
        return new Object[0];
    }

    protected String getParentPageId(Object item) {
        String pageId = null;
        if (item instanceof IPluginImport) {
            pageId = "dependencies";
        } else if (item instanceof IPluginLibrary) {
            pageId = "runtime";
        } else if (item instanceof IPluginExtension) {
            pageId = "extensions";
        } else if (item instanceof IPluginExtensionPoint) {
            pageId = "ex-points";
        } else if (item instanceof IBuildEntry) {
            pageId = "build";
        }
        if (pageId != null) {
            return pageId;
        }
        return super.getParentPageId(item);
    }

    private IBuildModel getBuildModel() {
        InputContext context = this.editor.getContextManager().findContext("build-context");
        if (context != null) {
            return (IBuildModel)context.getModel();
        }
        return null;
    }
}

