/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.plugin.ExtensionsPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class BodyTextSection
extends PDESection
implements IModelChangedListener,
IPartSelectionListener {
    public static final String SECTION_TITLE = "ManifestEditor.BodyTextSection.title";
    public static final String SECTION_TITLE_FULL = "ManifestEditor.BodyTextSection.titleFull";
    public static final String KEY_APPLY = "Actions.apply.flabel";
    public static final String KEY_RESET = "Actions.reset.flabel";
    public static final String KEY_DELETE = "Actions.delete.flabel";
    private Button applyButton;
    private Button resetButton;
    private IPluginElement currentElement;
    private Text text;
    private boolean blockNotification;

    public BodyTextSection(ExtensionsPage page, Composite parent) {
        super(page, parent, 2);
        this.getSection().setText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    private void updateTitle(boolean hasContents) {
        String title = hasContents ? PDEPlugin.getResourceString(SECTION_TITLE_FULL) : PDEPlugin.getResourceString(SECTION_TITLE);
        if (!this.getSection().getText().equals(title)) {
            this.getSection().setText(title);
            this.getSection().layout();
        }
    }

    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        container.setLayout((Layout)layout);
        this.text = toolkit.createText(container, "", 578);
        this.text.setEditable(false);
        GridData gd = new GridData(1808);
        this.text.setLayoutData((Object)gd);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BodyTextSection.this.blockNotification) {
                    return;
                }
                BodyTextSection.this.markDirty();
                BodyTextSection.this.applyButton.setEnabled(true);
                BodyTextSection.this.resetButton.setEnabled(true);
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                BodyTextSection.this.getPage().getPDEEditor().getContributor().updateSelectableActions((ISelection)new StructuredSelection());
            }
        });
        Composite buttonContainer = toolkit.createComposite(container);
        layout = new GridLayout();
        layout.marginHeight = 0;
        buttonContainer.setLayout((Layout)layout);
        gd = new GridData(48);
        buttonContainer.setLayoutData((Object)gd);
        this.applyButton = toolkit.createButton(buttonContainer, PDEPlugin.getResourceString(KEY_APPLY), 8);
        gd = new GridData(770);
        this.applyButton.setLayoutData((Object)gd);
        this.applyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BodyTextSection.this.handleApply();
            }
        });
        this.resetButton = toolkit.createButton(buttonContainer, PDEPlugin.getResourceString(KEY_RESET), 8);
        gd = new GridData(770);
        this.resetButton.setLayoutData((Object)gd);
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BodyTextSection.this.handleReset();
            }
        });
        if (!SWT.getPlatform().equals("motif")) {
            toolkit.paintBordersFor(container);
        }
        section.setClient((Control)container);
        this.initialize();
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDelete();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            this.text.selectAll();
            return true;
        }
        if (actionId.equals(ActionFactory.COPY.getId())) {
            this.text.copy();
            return true;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.text.paste();
            return true;
        }
        return false;
    }

    private void handleDelete() {
        this.text.cut();
    }

    private void handleApply() {
        try {
            if (this.currentElement != null) {
                this.currentElement.setText(this.text.getText().length() > 0 ? this.text.getText() : "");
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        this.applyButton.setEnabled(false);
    }

    public void commit(boolean onSave) {
        this.handleApply();
        if (onSave) {
            this.resetButton.setEnabled(false);
        }
        super.commit(onSave);
    }

    private void handleReset() {
        this.updateText(this.currentElement);
        this.resetButton.setEnabled(false);
        this.applyButton.setEnabled(false);
    }

    public void initialize() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        model.addModelChangedListener((IModelChangedListener)this);
        this.text.setEditable(model.isEditable());
        this.updateInput();
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            return;
        }
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        Object changeObject = ((IStructuredSelection)selection).getFirstElement();
        if (this.currentElement != null && this.currentElement == changeObject) {
            return;
        }
        this.currentElement = changeObject instanceof IPluginElement ? (IPluginElement)changeObject : null;
        this.updateInput();
    }

    private void updateInput() {
        this.applyButton.setEnabled(false);
        this.resetButton.setEnabled(false);
        this.updateText(this.currentElement);
        this.text.setEditable(this.isEditable() && this.currentElement != null);
    }

    private void updateText(IPluginElement element) {
        String bodyText = element != null ? element.getText() : null;
        this.blockNotification = true;
        this.text.setText(bodyText != null && bodyText.length() > 0 ? bodyText : "");
        this.applyButton.setEnabled(false);
        this.resetButton.setEnabled(false);
        this.updateTitle(bodyText != null && bodyText.length() > 0);
        this.blockNotification = false;
    }

    public boolean canPaste(Clipboard clipboard) {
        return true;
    }
}

