/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.schema;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.pde.internal.core.schema.DevelopmentSchemaDescriptor;
import org.eclipse.pde.internal.core.schema.EditableSchema;
import org.eclipse.pde.internal.core.schema.Schema;

public class FileSchemaDescriptor
extends DevelopmentSchemaDescriptor {
    private IFile file;

    public FileSchemaDescriptor(IFile file) {
        this.file = file;
    }

    protected Schema createSchema() {
        URL url = this.getSchemaURL();
        if (url == null) {
            return null;
        }
        return new EditableSchema(this, url);
    }

    public IFile getFile() {
        return this.file;
    }

    public String getPointId() {
        IProject project = this.file.getProject();
        String projectName = project.getName();
        String fileName = this.file.getName();
        int dotLoc = fileName.lastIndexOf(46);
        return projectName + "." + fileName.substring(0, dotLoc);
    }

    public URL getSchemaURL() {
        try {
            return new URL("file:" + this.file.getLocation().toOSString());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public boolean isEnabled() {
        return true;
    }
}

