/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IExtensionsModel;
import org.eclipse.pde.core.plugin.IExtensionsModelFactory;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.AbstractModel;
import org.eclipse.pde.internal.core.XMLDefaultHandler;
import org.eclipse.pde.internal.core.plugin.Extensions;
import org.eclipse.pde.internal.core.plugin.PluginAttribute;
import org.eclipse.pde.internal.core.plugin.PluginElement;
import org.eclipse.pde.internal.core.plugin.PluginExtension;
import org.eclipse.pde.internal.core.plugin.PluginExtensionPoint;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractExtensionsModel
extends AbstractModel
implements IExtensionsModel,
IExtensionsModelFactory {
    protected Extensions extensions;

    public IExtensionsModelFactory getFactory() {
        return this;
    }

    protected Extensions createExtensions() {
        Extensions extensions = new Extensions();
        extensions.setModel(this);
        return extensions;
    }

    public IExtensions getExtensions() {
        return this.getExtensions(true);
    }

    public IExtensions getExtensions(boolean createIfMissing) {
        if (this.extensions == null && createIfMissing) {
            this.extensions = this.createExtensions();
            this.loaded = true;
        }
        return this.extensions;
    }

    public abstract URL getNLLookupLocation();

    protected URL[] getNLLookupLocations() {
        URL[] locations = new URL[]{this.getNLLookupLocation()};
        return locations;
    }

    public synchronized void load(InputStream stream, boolean outOfSync) throws CoreException {
        if (this.extensions == null) {
            this.extensions = this.createExtensions();
            this.extensions.setModel(this);
        }
        this.extensions.reset();
        this.loaded = false;
        try {
            SAXParser parser = this.getSaxParser();
            XMLDefaultHandler handler = new XMLDefaultHandler();
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            parser.parse(stream, (DefaultHandler)handler);
            this.processDocument(handler.getDocument(), handler.getLineTable());
            this.loaded = true;
            if (!outOfSync) {
                this.updateTimeStamp();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processDocument(Document doc, Hashtable lineTable) {
        Element extensionsNode = doc.getDocumentElement();
        this.extensions.load(extensionsNode, lineTable);
    }

    public void reload(InputStream stream, boolean outOfSync) throws CoreException {
        this.load(stream, outOfSync);
        this.fireModelChanged(new ModelChangedEvent(this, 99, new Object[]{this.extensions}, null));
    }

    protected abstract void updateTimeStamp();

    public IPluginAttribute createAttribute(IPluginElement element) {
        PluginAttribute attribute = new PluginAttribute();
        attribute.setModel(this);
        attribute.setParent(element);
        return attribute;
    }

    public IPluginElement createElement(IPluginObject parent) {
        PluginElement element = new PluginElement();
        element.setModel(this);
        element.setParent(parent);
        return element;
    }

    public IPluginExtension createExtension() {
        PluginExtension extension = new PluginExtension();
        extension.setParent(this.getExtensions());
        extension.setModel(this);
        return extension;
    }

    public IPluginExtensionPoint createExtensionPoint() {
        PluginExtensionPoint extensionPoint = new PluginExtensionPoint();
        extensionPoint.setModel(this);
        extensionPoint.setParent(this.getExtensions());
        return extensionPoint;
    }

    public boolean isValid() {
        if (!this.isLoaded()) {
            return false;
        }
        if (this.extensions == null) {
            return false;
        }
        return this.extensions.isValid();
    }

    public boolean isReconcilingModel() {
        return false;
    }
}

