/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.pde.internal.core.IFileAdapterFactory;

public class FileAdapter
extends PlatformObject {
    private File file;
    private Object[] children;
    private FileAdapter parent;
    private String editorId;
    private IFileAdapterFactory factory;

    public FileAdapter(FileAdapter parent, File file, IFileAdapterFactory factory) {
        this.file = file;
        this.parent = parent;
        this.factory = factory;
    }

    public boolean isManifest() {
        String fileName = this.file.getName();
        return fileName.equals("plugin.xml") || fileName.equals("fragment.xml") || fileName.equalsIgnoreCase("manifest.mf");
    }

    public boolean isSchema() {
        String fileName = this.file.getName().toLowerCase();
        return fileName.endsWith(".mxsd") || fileName.endsWith(".exsd");
    }

    public FileAdapter getParent() {
        return this.parent;
    }

    public void setEditorId(String editorId) {
        this.editorId = editorId;
    }

    public String getEditorId() {
        return this.editorId;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public boolean hasChildren() {
        if (!this.file.isDirectory()) {
            return false;
        }
        if (this.children == null) {
            this.createChildren();
        }
        return this.children.length > 0;
    }

    public Object[] getChildren() {
        if (this.file.isDirectory() && this.children == null) {
            this.createChildren();
        }
        return this.children != null ? this.children : new Object[]{};
    }

    private void createChildren() {
        File[] files = this.file.listFiles();
        this.children = new Object[files.length];
        for (int i = 0; i < files.length; ++i) {
            this.children[i] = this.factory == null ? new FileAdapter(this, files[i], null) : this.factory.createAdapterChild(this, files[i]);
        }
    }
}

