/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class FindReplaceDocumentAdapter
implements CharSequence {
    private static final FindReplaceOperationCode FIND_FIRST = new FindReplaceOperationCode();
    private static final FindReplaceOperationCode FIND_NEXT = new FindReplaceOperationCode();
    private static final FindReplaceOperationCode REPLACE = new FindReplaceOperationCode();
    private static final FindReplaceOperationCode REPLACE_FIND_NEXT = new FindReplaceOperationCode();
    private IDocument fDocument;
    private FindReplaceOperationCode fFindReplaceState = null;
    private Matcher fFindReplaceMatcher;
    private int fFindReplaceMatchOffset;

    public FindReplaceDocumentAdapter(IDocument document) {
        Assert.isNotNull(document);
        this.fDocument = document;
    }

    public IRegion find(int startOffset, String findString, boolean forwardSearch, boolean caseSensitive, boolean wholeWord, boolean regExSearch) throws BadLocationException {
        Assert.isTrue(!regExSearch || !wholeWord);
        if (startOffset == -1 && forwardSearch) {
            startOffset = 0;
        }
        if (startOffset == -1 && !forwardSearch) {
            startOffset = this.length() - 1;
        }
        return this.findReplace(FIND_FIRST, startOffset, findString, null, forwardSearch, caseSensitive, wholeWord, regExSearch);
    }

    private IRegion findReplace(FindReplaceOperationCode operationCode, int startOffset, String findString, String replaceText, boolean forwardSearch, boolean caseSensitive, boolean wholeWord, boolean regExSearch) throws BadLocationException {
        Assert.isTrue(!regExSearch || !wholeWord);
        if ((operationCode == REPLACE || operationCode == REPLACE_FIND_NEXT) && this.fFindReplaceState != FIND_FIRST && this.fFindReplaceState != FIND_NEXT) {
            throw new IllegalStateException("illegal findReplace state: cannot replace without preceding find");
        }
        if (operationCode == FIND_FIRST) {
            if (findString == null || findString.length() == 0) {
                return null;
            }
            if (startOffset < 0 || startOffset >= this.length()) {
                throw new BadLocationException();
            }
            int patternFlags = 0;
            if (regExSearch) {
                patternFlags |= 8;
            }
            if (!caseSensitive) {
                patternFlags |= 0x42;
            }
            if (wholeWord) {
                findString = "\\b" + findString + "\\b";
            }
            if (!regExSearch && !wholeWord) {
                findString = this.asRegPattern(findString);
            }
            this.fFindReplaceMatchOffset = startOffset;
            if (this.fFindReplaceMatcher == null || !this.fFindReplaceMatcher.pattern().pattern().equals(findString) || this.fFindReplaceMatcher.pattern().flags() != patternFlags) {
                Pattern pattern = Pattern.compile(findString, patternFlags);
                this.fFindReplaceMatcher = pattern.matcher(this);
            }
        }
        this.fFindReplaceState = operationCode;
        if (operationCode == REPLACE || operationCode == REPLACE_FIND_NEXT) {
            if (regExSearch) {
                Pattern pattern = this.fFindReplaceMatcher.pattern();
                Matcher replaceTextMatcher = pattern.matcher(this.fFindReplaceMatcher.group());
                try {
                    replaceText = replaceTextMatcher.replaceFirst(replaceText);
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new PatternSyntaxException(ex.getLocalizedMessage(), replaceText, -1);
                }
            }
            int offset = this.fFindReplaceMatcher.start();
            this.fDocument.replace(offset, this.fFindReplaceMatcher.group().length(), replaceText);
            if (operationCode == REPLACE) {
                return new Region(offset, replaceText.length());
            }
        }
        if (operationCode != REPLACE) {
            boolean found;
            if (forwardSearch) {
                found = false;
                found = operationCode == FIND_FIRST ? this.fFindReplaceMatcher.find(startOffset) : this.fFindReplaceMatcher.find();
                if (operationCode == REPLACE_FIND_NEXT) {
                    this.fFindReplaceState = FIND_NEXT;
                }
                if (found && this.fFindReplaceMatcher.group().length() > 0) {
                    return new Region(this.fFindReplaceMatcher.start(), this.fFindReplaceMatcher.group().length());
                }
                return null;
            }
            found = this.fFindReplaceMatcher.find(0);
            int index = -1;
            int length = -1;
            while (found && this.fFindReplaceMatcher.start() <= this.fFindReplaceMatchOffset) {
                index = this.fFindReplaceMatcher.start();
                length = this.fFindReplaceMatcher.group().length();
                found = this.fFindReplaceMatcher.find(index + 1);
            }
            this.fFindReplaceMatchOffset = index;
            if (index > -1) {
                this.fFindReplaceMatcher.find(index);
                return new Region(index, length);
            }
            return null;
        }
        return null;
    }

    private String asRegPattern(String string) {
        StringBuffer out = new StringBuffer(string.length());
        boolean quoting = false;
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            if (ch == '\\') {
                if (quoting) {
                    out.append("\\E");
                    quoting = false;
                }
                out.append("\\\\");
                continue;
            }
            if (!quoting) {
                out.append("\\Q");
                quoting = true;
            }
            out.append(ch);
        }
        if (quoting) {
            out.append("\\E");
        }
        return out.toString();
    }

    public IRegion replace(String text, boolean regExReplace) throws BadLocationException {
        return this.findReplace(REPLACE, -1, null, text, false, false, false, regExReplace);
    }

    public int length() {
        return this.fDocument.getLength();
    }

    public char charAt(int index) {
        try {
            return this.fDocument.getChar(index);
        }
        catch (BadLocationException e) {
            throw new IndexOutOfBoundsException();
        }
    }

    public CharSequence subSequence(int start, int end) {
        try {
            return this.fDocument.get(start, end - start);
        }
        catch (BadLocationException e) {
            throw new IndexOutOfBoundsException();
        }
    }

    public String toString() {
        return this.fDocument.get();
    }

    private static class FindReplaceOperationCode {
        private FindReplaceOperationCode() {
        }
    }
}

