/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class Utils {
    public static final Comparator resourceComparator = new Comparator(){

        public boolean equals(Object obj) {
            return false;
        }

        public int compare(Object o1, Object o2) {
            IResource resource0 = (IResource)o1;
            IResource resource1 = (IResource)o2;
            return resource0.getFullPath().toString().compareTo(resource1.getFullPath().toString());
        }
    };
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;
    static /* synthetic */ Class class$org$eclipse$ui$progress$IWorkbenchSiteProgressService;

    public static void handleError(Shell shell, Exception exception, String title, String message) {
        IStatus status = null;
        boolean log = false;
        boolean dialog = false;
        Throwable t = exception;
        if (exception instanceof TeamException) {
            status = ((TeamException)((Object)exception)).getStatus();
            log = false;
            dialog = true;
        } else if (exception instanceof InvocationTargetException) {
            t = ((InvocationTargetException)exception).getTargetException();
            if (t instanceof TeamException) {
                status = ((TeamException)t).getStatus();
                log = false;
                dialog = true;
            } else if (t instanceof CoreException) {
                status = ((CoreException)t).getStatus();
                log = true;
                dialog = true;
            } else {
                if (t instanceof InterruptedException) {
                    return;
                }
                status = new Status(4, "org.eclipse.team.ui", 1, Policy.bind("TeamAction.internal"), t);
                log = true;
                dialog = true;
            }
        }
        if (status == null) {
            return;
        }
        if (!status.isOK()) {
            IStatus[] children;
            IStatus toShow = status;
            if (status.isMultiStatus() && (children = status.getChildren()).length == 1) {
                toShow = children[0];
            }
            if (title == null) {
                title = status.getMessage();
            }
            if (message == null) {
                message = status.getMessage();
            }
            if (dialog && shell != null) {
                ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)toShow);
            }
            if (log || shell == null) {
                TeamUIPlugin.log(toShow.getSeverity(), message, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithProgress(Shell parent, boolean cancelable, final IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        boolean createdShell = false;
        try {
            if (parent == null || parent.isDisposed()) {
                Display display = Display.getCurrent();
                if (display == null) {
                    runnable.run((IProgressMonitor)new NullProgressMonitor());
                    return;
                }
                parent = display.getActiveShell();
                if (parent == null) {
                    parent = new Shell(display);
                    createdShell = true;
                }
            }
            final Exception[] holder = new Exception[1];
            BusyIndicator.showWhile((Display)parent.getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        runnable.run((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (InvocationTargetException e) {
                        holder[0] = e;
                    }
                    catch (InterruptedException e) {
                        holder[0] = e;
                    }
                }
            });
            if (holder[0] != null) {
                if (holder[0] instanceof InvocationTargetException) {
                    throw (InvocationTargetException)holder[0];
                }
                throw (InterruptedException)holder[0];
            }
        }
        finally {
            if (createdShell) {
                parent.dispose();
            }
        }
    }

    public static void runWithProgressDialog(Shell parent, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        new ProgressMonitorDialog(parent).run(cancelable, cancelable, runnable);
    }

    public static Shell getShell(IWorkbenchSite site) {
        IWorkbenchWindow window;
        Shell shell;
        if (site != null && !(shell = site.getShell()).isDisposed()) {
            return shell;
        }
        IWorkbench workbench = TeamUIPlugin.getPlugin().getWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null) {
            return window.getShell();
        }
        Display display = Display.getDefault();
        if (display.isDisposed()) {
            return null;
        }
        return new Shell(display);
    }

    public static void handle(final Throwable exception) {
        TeamUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                Object error = null;
                Throwable t = exception;
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getTargetException();
                }
                error = t instanceof CoreException ? ((CoreException)t).getStatus() : (t instanceof TeamException ? ((TeamException)t).getStatus() : new Status(4, "org.eclipse.team.ui", 1, Policy.bind("simpleInternal"), t));
                Shell shell = new Shell(Display.getDefault());
                if (error.getSeverity() == 1) {
                    MessageDialog.openInformation((Shell)shell, (String)Policy.bind("information"), (String)error.getMessage());
                } else {
                    ErrorDialog.openError((Shell)shell, (String)Policy.bind("exception"), null, (IStatus)error);
                }
                shell.dispose();
                if (!(t instanceof TeamException)) {
                    TeamUIPlugin.log(error.getSeverity(), error.getMessage(), t);
                }
            }
        });
    }

    public static Shell findShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
            return display.getActiveShell();
        }
        return new Shell(TeamUIPlugin.getStandardDisplay());
    }

    public static IWorkbenchPartSite findSite(Control c) {
        while (c != null && !c.isDisposed()) {
            Object data = c.getData();
            if (data instanceof IWorkbenchPart) {
                return ((IWorkbenchPart)data).getSite();
            }
            c = c.getParent();
        }
        return null;
    }

    public static IWorkbenchPartSite findSite() {
        IWorkbenchPart part;
        IWorkbenchPage page;
        IWorkbench workbench = TeamUIPlugin.getPlugin().getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (part = page.getActivePart()) != null) {
            return part.getSite();
        }
        return null;
    }

    public static void initAction(IAction a, String prefix) {
        Utils.initAction(a, prefix, Policy.bundle);
    }

    public static void updateLabels(SyncInfo sync, CompareConfiguration config) {
        IResourceVariant remote = sync.getRemote();
        IResourceVariant base = sync.getBase();
        String localContentId = sync.getLocalContentIdentifier();
        if (localContentId != null) {
            config.setLeftLabel(Policy.bind("SyncInfoCompareInput.localLabelExists", localContentId));
        } else {
            config.setLeftLabel(Policy.bind("SyncInfoCompareInput.localLabel"));
        }
        if (remote != null) {
            config.setRightLabel(Policy.bind("SyncInfoCompareInput.remoteLabelExists", remote.getContentIdentifier()));
        } else {
            config.setRightLabel(Policy.bind("SyncInfoCompareInput.remoteLabel"));
        }
        if (base != null) {
            config.setAncestorLabel(Policy.bind("SyncInfoCompareInput.baseLabelExists", base.getContentIdentifier()));
        } else {
            config.setAncestorLabel(Policy.bind("SyncInfoCompareInput.baseLabel"));
        }
    }

    public static void initAction(IAction a, String prefix, ResourceBundle bundle) {
        String relPath;
        String s;
        String labelKey = "label";
        String tooltipKey = "tooltip";
        String imageKey = "image";
        String descriptionKey = "description";
        if (prefix != null && prefix.length() > 0) {
            labelKey = prefix + labelKey;
            tooltipKey = prefix + tooltipKey;
            imageKey = prefix + imageKey;
            descriptionKey = prefix + descriptionKey;
        }
        if ((s = Policy.bind(labelKey, bundle)) != null) {
            a.setText(s);
        }
        if ((s = Policy.bind(tooltipKey, bundle)) != null) {
            a.setToolTipText(s);
        }
        if ((s = Policy.bind(descriptionKey, bundle)) != null) {
            a.setDescription(s);
        }
        if ((relPath = Policy.bind(imageKey, bundle)) != null && !relPath.equals(imageKey) && relPath.trim().length() > 0) {
            String ePath;
            String dPath;
            if (relPath.indexOf("/") >= 0) {
                String path = relPath.substring(1);
                dPath = 'd' + path;
                ePath = 'e' + path;
            } else {
                dPath = "dlcl16/" + relPath;
                ePath = "elcl16/" + relPath;
            }
            ImageDescriptor id = TeamImages.getImageDescriptor(dPath);
            if (id != null) {
                a.setDisabledImageDescriptor(id);
            }
            if ((id = TeamUIPlugin.getImageDescriptor(ePath)) != null) {
                a.setImageDescriptor(id);
            }
        }
    }

    public static String modeToString(int mode) {
        switch (mode) {
            case 1: {
                return Policy.bind("Utils.22");
            }
            case 2: {
                return Policy.bind("Utils.23");
            }
            case 4: {
                return Policy.bind("Utils.24");
            }
            case 8: {
                return Policy.bind("Utils.25");
            }
        }
        return Policy.bind("Utils.26");
    }

    public static String workingSetToString(IWorkingSet set, int maxLength) {
        String text = Policy.bind("StatisticsPanel.noWorkingSet");
        if (set != null && (text = set.getName()).length() > maxLength) {
            text = text.substring(0, maxLength - 3) + "...";
        }
        return text;
    }

    public static IResource[] getResources(Object[] elements) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        for (int i = 0; i < elements.length; ++i) {
            Object element = elements[i];
            IResource resource = null;
            if (element instanceof IResource) {
                resource = (IResource)element;
            } else if (element instanceof ISynchronizeModelElement) {
                resource = ((ISynchronizeModelElement)element).getResource();
            } else {
                resource = (IResource)Utils.getAdapter(element, class$org$eclipse$core$resources$IResource == null ? Utils.class$("org.eclipse.core.resources.IResource") : class$org$eclipse$core$resources$IResource);
                if (resource != null && resource.getType() == 8) continue;
            }
            if (resource == null) continue;
            resources.add(resource);
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    public static Object getAdapter(Object element, Class adapter) {
        if (element instanceof IAdaptable) {
            return ((IAdaptable)element).getAdapter(adapter);
        }
        return null;
    }

    public static boolean hasMatchingDescendant(IStructuredSelection selection, FastSyncInfoFilter filter) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof ISynchronizeModelElement) || !Utils.hasMatchingDescendant((ISynchronizeModelElement)o, filter)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasMatchingDescendant(ISynchronizeModelElement element, FastSyncInfoFilter filter) {
        SyncInfo info;
        if (element.getKind() != 0 && element instanceof SyncInfoModelElement && (info = ((SyncInfoModelElement)element).getSyncInfo()) != null && filter.select(info)) {
            return true;
        }
        IDiffElement[] children = element.getChildren();
        for (int i = 0; i < children.length; ++i) {
            IDiffElement child = children[i];
            if (!(child instanceof ISynchronizeModelElement) || !Utils.hasMatchingDescendant((ISynchronizeModelElement)child, filter)) continue;
            return true;
        }
        return false;
    }

    public static IDiffElement[] getDiffNodes(Object[] selected) {
        HashSet result = new HashSet();
        for (int i = 0; i < selected.length; ++i) {
            Object object = selected[i];
            if (!(object instanceof IDiffElement)) continue;
            Utils.collectAllNodes((IDiffElement)object, result);
        }
        return result.toArray(new IDiffElement[result.size()]);
    }

    private static void collectAllNodes(IDiffElement element, Set nodes) {
        if (element.getKind() != 0) {
            nodes.add(element);
        }
        if (element instanceof IDiffContainer) {
            IDiffElement[] children = ((IDiffContainer)element).getChildren();
            for (int i = 0; i < children.length; ++i) {
                Utils.collectAllNodes(children[i], nodes);
            }
        }
    }

    public static void schedule(Job job, IWorkbenchSite site) {
        IWorkbenchSiteProgressService siteProgress;
        if (site != null && (siteProgress = (IWorkbenchSiteProgressService)site.getAdapter(class$org$eclipse$ui$progress$IWorkbenchSiteProgressService == null ? (class$org$eclipse$ui$progress$IWorkbenchSiteProgressService = Utils.class$("org.eclipse.ui.progress.IWorkbenchSiteProgressService")) : class$org$eclipse$ui$progress$IWorkbenchSiteProgressService)) != null) {
            siteProgress.schedule(job, 0L, true);
            return;
        }
        job.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static byte[] readBytes(InputStream in) {
        ByteArrayOutputStream bos;
        block18: {
            IOException x2;
            block15: {
                int c;
                bos = new ByteArrayOutputStream();
                while ((c = in.read()) != -1) {
                    bos.write(c);
                }
                Object var5_4 = null;
                if (in == null) break block15;
                try {
                    in.close();
                }
                catch (IOException x2) {
                    // empty catch block
                }
            }
            try {
                bos.close();
            }
            catch (IOException x2) {}
            break block18;
            {
                catch (IOException ex) {
                    byte[] byArray = null;
                    Object var5_5 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException x2) {
                            // empty catch block
                        }
                    }
                    try {
                        bos.close();
                    }
                    catch (IOException x2) {
                        // empty catch block
                    }
                    return byArray;
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException x2) {
                        // empty catch block
                    }
                }
                try {
                    bos.close();
                }
                catch (IOException x2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return bos.toByteArray();
    }

    public static boolean equalObject(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static String getKey(String id, String secondaryId) {
        return secondaryId == null ? id : id + '/' + secondaryId;
    }

    public static String stripAmpersand(String string) {
        if (string.indexOf(38) != -1) {
            StringBuffer buffer = new StringBuffer(string);
            int last = 120;
            for (int i = string.length() - 1; i > -1; --i) {
                char c = string.charAt(i);
                if (c != '&') continue;
                buffer.deleteCharAt(i);
                break;
            }
            return buffer.toString();
        }
        return string;
    }

    public static String convertSelection(IResource[] resources) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < resources.length; ++i) {
            IResource resource = resources[i];
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(resource.getFullPath());
        }
        return buffer.toString();
    }

    public static String shortenText(int maxWidth, String textValue) {
        int pivot;
        int length = textValue.length();
        if (length < maxWidth) {
            return textValue;
        }
        int ellipsisWidth = 3;
        int start = pivot = length / 2;
        for (int end = pivot + 1; start >= 0 && end < length; --start, ++end) {
            int l2;
            String s1 = textValue.substring(0, start);
            String s2 = textValue.substring(end, length);
            int l1 = s1.length();
            if (l1 + ellipsisWidth + (l2 = s2.length()) >= maxWidth) continue;
            return s1 + "..." + s2;
        }
        return textValue;
    }

    public static String getTypeName(ISynchronizeParticipant participant) {
        ISynchronizeManager manager = TeamUI.getSynchronizeManager();
        return manager.getParticipantDescriptor(participant.getId()).getName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static abstract class Sorter {
        public abstract boolean compare(Object var1, Object var2);

        private Object[] quickSort(Object[] sortedCollection, int left, int right) {
            int originalLeft = left;
            int originalRight = right;
            Object mid = sortedCollection[(left + right) / 2];
            while (true) {
                if (this.compare(sortedCollection[left], mid)) {
                    ++left;
                    continue;
                }
                while (this.compare(mid, sortedCollection[right])) {
                    --right;
                }
                if (left <= right) {
                    Object tmp = sortedCollection[left];
                    sortedCollection[left] = sortedCollection[right];
                    sortedCollection[right] = tmp;
                    ++left;
                    --right;
                }
                if (left > right) break;
            }
            if (originalLeft < right) {
                sortedCollection = this.quickSort(sortedCollection, originalLeft, right);
            }
            if (left < originalRight) {
                sortedCollection = this.quickSort(sortedCollection, left, originalRight);
            }
            return sortedCollection;
        }

        public Object[] sort(Object[] unSortedCollection) {
            int size = unSortedCollection.length;
            Object[] sortedCollection = new Object[size];
            System.arraycopy(unSortedCollection, 0, sortedCollection, 0, size);
            if (size > 1) {
                this.quickSort(sortedCollection, 0, size - 1);
            }
            return sortedCollection;
        }
    }
}

