/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.text.DateFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.InstallConfiguration;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.wizards.ActivitiesTableViewer;

public class ShowActivitiesDialog
extends Dialog {
    private TableViewer activitiesViewer;
    private IDialogSettings dialogSettings;
    private Point dialogLocation;
    private Point dialogSize;

    public ShowActivitiesDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(66704);
        this.readConfiguration();
    }

    public void create() {
        super.create();
        if (this.dialogLocation != null) {
            this.getShell().setLocation(this.dialogLocation);
        }
        if (this.dialogSize != null) {
            this.getShell().setSize(this.dialogSize);
        } else {
            this.getShell().setSize(500, 500);
        }
        ShowActivitiesDialog.applyDialogFont((Control)this.buttonBar);
        this.getButton(0).setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        container.setLayoutData((Object)gd);
        this.createDescriptionSection(container);
        this.createActivitiesViewer(container);
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    protected Control createDescriptionSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        container.setLayoutData((Object)gd);
        try {
            Label targetLabel = new Label(container, 0);
            targetLabel.setText(UpdateUI.getString("ShowActivitiesDialog.date"));
            Label target = new Label(container, 0);
            DateFormat df = DateFormat.getDateTimeInstance();
            String localizedDate = df.format(SiteManager.getLocalSite().getCurrentConfiguration().getCreationDate());
            target.setText(localizedDate);
            Label urlLabel = new Label(container, 0);
            urlLabel.setText(UpdateUI.getString("ShowActivitiesDialog.loc"));
            Label url = new Label(container, 0);
            url.setText(((InstallConfiguration)SiteManager.getLocalSite().getCurrentConfiguration()).getURL().getFile());
        }
        catch (CoreException e) {
            UpdateUI.logException(e);
        }
        return container;
    }

    protected Control createActivitiesViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 4;
        gridLayout.marginHeight = 4;
        composite.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 0);
        label.setText(UpdateUI.getString("ShowActivitiesDialog.label"));
        this.activitiesViewer = ActivitiesTableViewer.createViewer(composite, true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(8, 20, false));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 160, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 183, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 100, true));
        this.activitiesViewer.getTable().setLayout((Layout)layout);
        try {
            this.activitiesViewer.setInput((Object)SiteManager.getLocalSite().getCurrentConfiguration());
        }
        catch (CoreException e) {
            // empty catch block
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    public boolean close() {
        this.storeSettings();
        return super.close();
    }

    private void storeSettings() {
        this.writeConfiguration();
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = UpdateUI.getDefault().getDialogSettings();
        this.dialogSettings = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (this.dialogSettings == null) {
            this.dialogSettings = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return this.dialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        try {
            int x = s.getInt("x");
            int y = s.getInt("y");
            this.dialogLocation = new Point(x, y);
            x = s.getInt("width");
            y = s.getInt("height");
            this.dialogSize = new Point(x, y);
        }
        catch (NumberFormatException e) {
            this.dialogLocation = null;
            this.dialogSize = null;
        }
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        Point location = this.getShell().getLocation();
        s.put("x", location.x);
        s.put("y", location.y);
        Point size = this.getShell().getSize();
        s.put("width", size.x);
        s.put("height", size.y);
    }
}

