/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.operations.FeatureStatus;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.model.SimpleFeatureAdapter;
import org.eclipse.update.internal.ui.parts.DefaultContentProvider;
import org.eclipse.update.internal.ui.parts.SWTUtil;
import org.eclipse.update.internal.ui.parts.SharedLabelProvider;
import org.eclipse.update.internal.ui.wizards.BannerPage;
import org.eclipse.update.internal.ui.wizards.FeatureSorter;
import org.eclipse.update.internal.ui.wizards.ModeSelectionPage;
import org.eclipse.update.internal.ui.wizards.SearchRunner;
import org.eclipse.update.internal.ui.wizards.TableLayoutComposite;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.search.IUpdateSearchResultCollector;

public class ReviewPage
extends BannerPage
implements IUpdateSearchResultCollector {
    private ArrayList jobs;
    private Label counterLabel;
    private CheckboxTableViewer tableViewer;
    private IStatus validationStatus;
    private Collection problematicFeatures = new HashSet();
    private IFeature newlySelectedFeature;
    private FeatureStatus lastDisplayedStatus;
    private PropertyDialogAction propertiesAction;
    private Text descLabel;
    private Button statusButton;
    private Button moreInfoButton;
    private Button propertiesButton;
    private Button filterCheck;
    private ContainmentFilter filter = new ContainmentFilter();
    private SearchRunner searchRunner;
    private int LABEL_ORDER = 1;
    private int VERSION_ORDER = 1;
    private int PROVIDER_ORDER = 1;

    public ReviewPage(SearchRunner searchRunner, ArrayList jobs) {
        super("Review");
        this.setTitle(UpdateUI.getString("InstallWizard.ReviewPage.title"));
        this.setDescription(UpdateUI.getString("InstallWizard.ReviewPage.desc"));
        UpdateUI.getDefault().getLabelProvider().connect((Object)this);
        this.searchRunner = searchRunner;
        this.setBannerVisible(false);
        this.jobs = jobs;
        if (this.jobs == null) {
            this.jobs = new ArrayList();
        }
    }

    public void dispose() {
        UpdateUI.getDefault().getLabelProvider().disconnect((Object)this);
        super.dispose();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        String filterText = this.filterCheck.getText();
        String filterFeatures = UpdateUI.getString("InstallWizard.ReviewPage.filterFeatures");
        String filterPatches = UpdateUI.getString("InstallWizard.ReviewPage.filterPatches");
        boolean isUpdateSearch = this.searchRunner.getSearchProvider() instanceof ModeSelectionPage;
        if (isUpdateSearch && filterText.equals(filterFeatures)) {
            this.filterCheck.setText(filterPatches);
        } else if (!isUpdateSearch && filterText.equals(filterPatches)) {
            this.filterCheck.setText(filterFeatures);
        }
        if (visible && this.searchRunner.isNewSearchNeeded()) {
            this.jobs.clear();
            this.tableViewer.refresh();
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ReviewPage.this.searchRunner.runSearch();
                    ReviewPage.this.performPostSearchProcessing();
                }
            });
        }
    }

    private void performPostSearchProcessing() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (ReviewPage.this.tableViewer != null) {
                    ReviewPage.this.tableViewer.refresh();
                    ReviewPage.this.tableViewer.getTable().layout(true);
                    if (ReviewPage.this.searchRunner.getSearchProvider() instanceof ModeSelectionPage) {
                        ReviewPage.this.selectTrueUpdates();
                    }
                }
                ReviewPage.this.pageChanged();
            }
        });
    }

    private void selectTrueUpdates() {
        ArrayList<IInstallFeatureOperation> trueUpdates = new ArrayList<IInstallFeatureOperation>();
        for (int i = 0; i < this.jobs.size(); ++i) {
            IInstallFeatureOperation job = (IInstallFeatureOperation)this.jobs.get(i);
            if (UpdateUtils.isPatch((IFeature)job.getFeature())) continue;
            trueUpdates.add(job);
        }
        this.tableViewer.setCheckedElements(trueUpdates.toArray());
    }

    public Control createContents(Composite parent) {
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        client.setLayout((Layout)layout);
        Label label = new Label(client, 0);
        label.setText(UpdateUI.getString("InstallWizard.ReviewPage.label"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.createTable(client);
        Composite buttonContainer = new Composite(client, 0);
        gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonContainer.setLayout((Layout)layout);
        Button button = new Button(buttonContainer, 8);
        button.setText(UpdateUI.getString("InstallWizard.ReviewPage.selectAll"));
        gd = new GridData(258);
        button.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReviewPage.this.handleSelectAll(true);
            }
        });
        button = new Button(buttonContainer, 8);
        button.setText(UpdateUI.getString("InstallWizard.ReviewPage.deselectAll"));
        gd = new GridData(258);
        button.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReviewPage.this.handleSelectAll(false);
            }
        });
        this.moreInfoButton = new Button(buttonContainer, 8);
        this.moreInfoButton.setText(UpdateUI.getString("InstallWizard.ReviewPage.moreInfo"));
        gd = new GridData(258);
        this.moreInfoButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(this.moreInfoButton);
        this.moreInfoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReviewPage.this.handleMoreInfo();
            }
        });
        this.moreInfoButton.setEnabled(false);
        this.propertiesButton = new Button(buttonContainer, 8);
        this.propertiesButton.setText(UpdateUI.getString("InstallWizard.ReviewPage.properties"));
        gd = new GridData(258);
        this.propertiesButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(this.propertiesButton);
        this.propertiesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReviewPage.this.handleProperties();
            }
        });
        this.propertiesButton.setEnabled(false);
        this.statusButton = new Button(buttonContainer, 8);
        this.statusButton.setText(UpdateUI.getString("InstallWizard.ReviewPage.showStatus"));
        gd = new GridData(258);
        this.statusButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(this.statusButton);
        this.statusButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReviewPage.this.showStatus();
            }
        });
        this.counterLabel = new Label(client, 0);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.counterLabel.setLayoutData((Object)gd);
        this.filterCheck = new Button(client, 32);
        this.filterCheck.setText(UpdateUI.getString("InstallWizard.ReviewPage.filterFeatures"));
        this.filterCheck.setSelection(false);
        this.filterCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReviewPage.this.filterCheck.getSelection()) {
                    if (ReviewPage.this.downloadIncludedFeatures()) {
                        ReviewPage.this.tableViewer.addFilter((ViewerFilter)ReviewPage.this.filter);
                    } else {
                        ReviewPage.this.filterCheck.setSelection(false);
                    }
                } else {
                    ReviewPage.this.tableViewer.removeFilter((ViewerFilter)ReviewPage.this.filter);
                }
                ReviewPage.this.pageChanged();
            }
        });
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.filterCheck.setLayoutData((Object)gd);
        this.pageChanged();
        WorkbenchHelp.setHelp((Control)client, (String)"org.eclipse.update.ui.MultiReviewPage2");
        Dialog.applyDialogFont((Control)parent);
        return client;
    }

    private void createTable(Composite parent) {
        SashForm sform = new SashForm(parent, 512);
        GridData gd = new GridData(1808);
        gd.widthHint = 250;
        gd.heightHint = 100;
        sform.setLayoutData((Object)gd);
        TableLayoutComposite composite = new TableLayoutComposite((Composite)sform, 0);
        composite.setLayoutData(new GridData(1808));
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)68352);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 0);
        column.setText(UpdateUI.getString("InstallWizard.ReviewPage.feature"));
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReviewPage.this.LABEL_ORDER *= -1;
                ReviewPage.this.tableViewer.setSorter((ViewerSorter)new FeatureSorter(2, ReviewPage.this.LABEL_ORDER, ReviewPage.this.VERSION_ORDER, ReviewPage.this.PROVIDER_ORDER));
            }
        });
        column = new TableColumn(table, 0);
        column.setText(UpdateUI.getString("InstallWizard.ReviewPage.version"));
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReviewPage.this.VERSION_ORDER *= -1;
                ReviewPage.this.tableViewer.setSorter((ViewerSorter)new FeatureSorter(1, ReviewPage.this.LABEL_ORDER, ReviewPage.this.VERSION_ORDER, ReviewPage.this.PROVIDER_ORDER));
            }
        });
        column = new TableColumn(table, 0);
        column.setText(UpdateUI.getString("InstallWizard.ReviewPage.provider"));
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReviewPage.this.PROVIDER_ORDER *= -1;
                ReviewPage.this.tableViewer.setSorter((ViewerSorter)new FeatureSorter(3, ReviewPage.this.LABEL_ORDER, ReviewPage.this.VERSION_ORDER, ReviewPage.this.PROVIDER_ORDER));
            }
        });
        composite.addColumnData((ColumnLayoutData)new ColumnWeightData(5, 275, true));
        composite.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 80, true));
        composite.addColumnData((ColumnLayoutData)new ColumnWeightData(5, 90, true));
        this.tableViewer.setContentProvider((IContentProvider)new JobsContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new JobsLabelProvider());
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object checked;
                ReviewPage.this.newlySelectedFeature = null;
                if (event.getChecked() && (checked = event.getElement()) instanceof IInstallFeatureOperation) {
                    ReviewPage.this.newlySelectedFeature = ((IInstallFeatureOperation)checked).getFeature();
                }
                ReviewPage.this.tableViewer.getControl().getDisplay().asyncExec(new Runnable(this){
                    private final /* synthetic */ 12 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        ReviewPage.access$600(12.access$1800(this.this$1));
                    }
                });
            }

            static /* synthetic */ ReviewPage access$1800(12 x0) {
                return x0.ReviewPage.this;
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                ReviewPage.this.jobSelected((IStructuredSelection)e.getSelection());
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ReviewPage.this.handleProperties();
            }
        });
        this.tableViewer.setSorter((ViewerSorter)new FeatureSorter());
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ReviewPage.this.fillContextMenu(manager);
            }
        });
        table.setMenu(menuMgr.createContextMenu((Control)table));
        this.tableViewer.setInput((Object)UpdateUI.getDefault().getUpdateModel());
        this.tableViewer.setAllChecked(true);
        this.descLabel = new Text((Composite)sform, 2626);
        this.descLabel.setEditable(false);
        sform.setWeights(new int[]{10, 2});
    }

    private void fillContextMenu(IMenuManager manager) {
        if (this.tableViewer.getSelection().isEmpty()) {
            return;
        }
        Action action = new Action(UpdateUI.getString("InstallWizard.ReviewPage.prop")){

            public void run() {
                ReviewPage.this.handleProperties();
            }
        };
        manager.add((IAction)action);
    }

    public void accept(final IFeature feature) {
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                IInstallFeatureOperation job = OperationsManager.getOperationFactory().createInstallOperation(null, feature, null, null, null);
                ViewerFilter[] filters = ReviewPage.this.tableViewer.getFilters();
                boolean visible = true;
                for (int i = 0; i < filters.length; ++i) {
                    ViewerFilter filter = filters[i];
                    if (filter.select((Viewer)ReviewPage.this.tableViewer, null, (Object)job)) continue;
                    visible = false;
                    break;
                }
                if (visible) {
                    ReviewPage.this.tableViewer.add((Object)job);
                    ReviewPage.this.updateItemCount(0, -1);
                }
                ReviewPage.this.jobs.add(job);
            }
        });
    }

    private void jobSelected(IStructuredSelection selection) {
        IInstallFeatureOperation job = (IInstallFeatureOperation)selection.getFirstElement();
        IFeature feature = job != null ? job.getFeature() : null;
        IURLEntry descEntry = feature != null ? feature.getDescription() : null;
        String desc = null;
        if (descEntry != null) {
            desc = descEntry.getAnnotation();
        }
        if (desc == null) {
            desc = "";
        }
        this.descLabel.setText(desc);
        this.propertiesButton.setEnabled(feature != null);
        this.moreInfoButton.setEnabled(job != null && this.getMoreInfoURL(job) != null);
    }

    private void pageChanged() {
        Object[] checked = this.tableViewer.getCheckedElements();
        int totalCount = this.tableViewer.getTable().getItemCount();
        this.updateItemCount(checked.length, totalCount);
        if (checked.length > 0) {
            this.validateSelection();
        } else {
            this.lastDisplayedStatus = null;
            this.setErrorMessage(null);
            this.setPageComplete(false);
            this.validationStatus = null;
            this.problematicFeatures.clear();
        }
        this.tableViewer.update(this.jobs.toArray(), null);
        this.statusButton.setEnabled(this.validationStatus != null);
    }

    private void updateItemCount(int checkedCount, int totalCount) {
        if (checkedCount == -1) {
            Object[] checkedElements = this.tableViewer.getCheckedElements();
            checkedCount = checkedElements.length;
        }
        if (totalCount == -1) {
            totalCount = this.tableViewer.getTable().getItemCount();
        }
        String total = "" + totalCount;
        String selected = "" + checkedCount;
        this.counterLabel.setText(UpdateUI.getFormattedMessage("InstallWizard.ReviewPage.counter", new String[]{selected, total}));
        this.counterLabel.getParent().layout();
    }

    private void handleSelectAll(boolean select) {
        this.tableViewer.setAllChecked(select);
        this.tableViewer.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ReviewPage.this.pageChanged();
            }
        });
    }

    private void handleProperties() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        final IInstallFeatureOperation job = (IInstallFeatureOperation)selection.getFirstElement();
        if (this.propertiesAction == null) {
            this.propertiesAction = new FeaturePropertyDialogAction(this.getShell(), (ISelectionProvider)this.tableViewer);
        }
        BusyIndicator.showWhile((Display)this.tableViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                SimpleFeatureAdapter adapter = new SimpleFeatureAdapter(job.getFeature());
                ReviewPage.this.propertiesAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)adapter));
                ReviewPage.this.propertiesAction.run();
            }
        });
    }

    private String getMoreInfoURL(IInstallFeatureOperation job) {
        IURLEntry desc = job.getFeature().getDescription();
        if (desc != null) {
            URL url = desc.getURL();
            return url == null ? null : url.toString();
        }
        return null;
    }

    private void handleMoreInfo() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        final IInstallFeatureOperation selectedJob = (IInstallFeatureOperation)selection.getFirstElement();
        BusyIndicator.showWhile((Display)this.tableViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                String urlName = ReviewPage.this.getMoreInfoURL(selectedJob);
                UpdateUI.showURL(urlName);
            }
        });
    }

    public IInstallFeatureOperation[] getSelectedJobs() {
        Object[] selected = this.tableViewer.getCheckedElements();
        IInstallFeatureOperation[] result = new IInstallFeatureOperation[selected.length];
        System.arraycopy(selected, 0, result, 0, selected.length);
        return result;
    }

    public void validateSelection() {
        IInstallFeatureOperation[] jobs = this.getSelectedJobs();
        this.validationStatus = OperationsManager.getValidator().validatePendingChanges(jobs);
        this.problematicFeatures.clear();
        if (this.validationStatus != null) {
            IStatus[] status = this.validationStatus.getChildren();
            for (int i = 0; i < status.length; ++i) {
                IStatus singleStatus = status[i];
                if (!this.isSpecificStatus(singleStatus)) continue;
                IFeature f = ((FeatureStatus)singleStatus).getFeature();
                this.problematicFeatures.add(f);
            }
        }
        this.setPageComplete(this.validationStatus == null || this.validationStatus.getCode() == 2);
        this.updateWizardMessage();
    }

    private void showStatus() {
        if (this.validationStatus != null) {
            new StatusDialog().open();
        }
    }

    private boolean isSpecificStatus(IStatus status) {
        if (!(status instanceof FeatureStatus)) {
            return false;
        }
        if (status.getSeverity() != 4) {
            return false;
        }
        FeatureStatus featureStatus = (FeatureStatus)status;
        if (featureStatus.getFeature() == null) {
            return false;
        }
        return 0 != (featureStatus.getCode() & 0x3F);
    }

    private void updateWizardMessage() {
        if (this.validationStatus == null) {
            this.lastDisplayedStatus = null;
            this.setErrorMessage(null);
        } else if (this.validationStatus.getCode() == 2) {
            this.lastDisplayedStatus = null;
            this.setErrorMessage(null);
            this.setMessage(this.validationStatus.getMessage(), 2);
        } else {
            int s;
            IStatus[] status;
            if (this.newlySelectedFeature != null) {
                status = this.validationStatus.getChildren();
                for (s = 0; s < status.length; ++s) {
                    FeatureStatus featureStatus;
                    if (!this.isSpecificStatus(status[s]) || !this.newlySelectedFeature.equals((featureStatus = (FeatureStatus)status[s]).getFeature())) continue;
                    this.lastDisplayedStatus = featureStatus;
                    this.setErrorMessage(featureStatus.getMessage());
                    return;
                }
            }
            if (this.lastDisplayedStatus != null) {
                status = this.validationStatus.getChildren();
                for (int i = 0; i < status.length; ++i) {
                    if (!this.lastDisplayedStatus.equals((Object)status[i])) continue;
                    return;
                }
                this.lastDisplayedStatus = null;
            }
            status = this.validationStatus.getChildren();
            for (s = 0; s < status.length; ++s) {
                if (!this.isSpecificStatus(status[s])) continue;
                this.lastDisplayedStatus = (FeatureStatus)status[s];
                this.setErrorMessage(status[s].getMessage());
                return;
            }
            if (status.length > 0) {
                IStatus singleStatus = status[0];
                this.setErrorMessage(singleStatus.getMessage());
            } else {
                this.setErrorMessage(UpdateUI.getString("InstallWizard.ReviewPage.invalid.long"));
            }
        }
    }

    private boolean downloadIncludedFeatures() {
        try {
            Downloader downloader = new Downloader(this.jobs);
            this.getContainer().run(true, true, (IRunnableWithProgress)downloader);
            return !downloader.isCanceled();
        }
        catch (InvocationTargetException ite) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    class Downloader
    implements IRunnableWithProgress {
        boolean canceled = false;
        ArrayList operations;

        public Downloader(ArrayList installOperations) {
            this.operations = installOperations;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            for (int i = 0; i < this.operations.size(); ++i) {
                IInstallFeatureOperation candidate = (IInstallFeatureOperation)this.operations.get(i);
                IFeature feature = candidate.getFeature();
                try {
                    IIncludedFeatureReference[] irefs = feature.getRawIncludedFeatureReferences();
                    for (int f = 0; f < irefs.length; ++f) {
                        if (monitor.isCanceled()) {
                            this.canceled = true;
                            return;
                        }
                        IIncludedFeatureReference iref = irefs[f];
                        IFeature ifeature = iref.getFeature(monitor);
                    }
                    continue;
                }
                catch (CoreException e) {
                    // empty catch block
                }
            }
            if (monitor.isCanceled()) {
                this.canceled = true;
            }
        }
    }

    class StatusDialog
    extends ErrorDialog {
        public StatusDialog() {
            super(UpdateUI.getActiveWorkbenchShell(), UpdateUI.getString("InstallWizard.ReviewPage.invalid.short"), null, ReviewPage.this.validationStatus, 7);
        }

        public void create() {
            super.create();
            this.buttonPressed(13);
        }
    }

    class FeaturePropertyDialogAction
    extends PropertyDialogAction {
        private IStructuredSelection selection;

        public FeaturePropertyDialogAction(Shell shell, ISelectionProvider provider) {
            super(shell, provider);
        }

        public IStructuredSelection getStructuredSelection() {
            return this.selection;
        }

        public void selectionChanged(IStructuredSelection selection) {
            this.selection = selection;
        }
    }

    class ContainmentFilter
    extends ViewerFilter {
        ContainmentFilter() {
        }

        public boolean select(Viewer v, Object parent, Object child) {
            return !this.isContained((IInstallFeatureOperation)child);
        }

        private boolean isContained(IInstallFeatureOperation job) {
            VersionedIdentifier vid = job.getFeature().getVersionedIdentifier();
            for (int i = 0; i < ReviewPage.this.jobs.size(); ++i) {
                IFeature feature;
                IInstallFeatureOperation candidate = (IInstallFeatureOperation)ReviewPage.this.jobs.get(i);
                if (candidate.equals(job) || !this.includes(feature = candidate.getFeature(), vid, null)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean includes(IFeature feature, VersionedIdentifier vid, ArrayList cycleCandidates) {
            boolean bl;
            try {
                if (cycleCandidates == null) {
                    cycleCandidates = new ArrayList<IFeature>();
                }
                if (cycleCandidates.contains(feature)) {
                    throw Utilities.newCoreException((String)UpdateUI.getFormattedMessage("InstallWizard.ReviewPage.cycle", feature.getVersionedIdentifier().toString()), null);
                }
                cycleCandidates.add(feature);
                IIncludedFeatureReference[] irefs = feature.getIncludedFeatureReferences();
                for (int i = 0; i < irefs.length; ++i) {
                    IIncludedFeatureReference iref = irefs[i];
                    IFeature ifeature = iref.getFeature(null);
                    VersionedIdentifier ivid = ifeature.getVersionedIdentifier();
                    if (ivid.equals((Object)vid)) {
                        boolean bl2 = true;
                        return bl2;
                    }
                    if (!this.includes(ifeature, vid, cycleCandidates)) continue;
                    boolean bl3 = true;
                    return bl3;
                }
                bl = false;
                return bl;
            }
            catch (CoreException e) {
                bl = false;
                return bl;
            }
            finally {
                cycleCandidates.remove(feature);
            }
        }
    }

    class JobsLabelProvider
    extends SharedLabelProvider
    implements ITableLabelProvider {
        JobsLabelProvider() {
        }

        public String getColumnText(Object obj, int column) {
            IInstallFeatureOperation job = (IInstallFeatureOperation)obj;
            IFeature feature = job.getFeature();
            String text = null;
            switch (column) {
                case 0: {
                    text = feature.getLabel();
                    break;
                }
                case 1: {
                    text = feature.getVersionedIdentifier().getVersion().toString();
                    break;
                }
                case 2: {
                    text = feature.getProvider();
                }
            }
            if (text == null) {
                text = "";
            }
            return text;
        }

        public Image getColumnImage(Object obj, int column) {
            if (column == 0) {
                IFeature feature = ((IInstallFeatureOperation)obj).getFeature();
                boolean patch = feature.isPatch();
                boolean problematic = ReviewPage.this.problematicFeatures.contains(feature);
                if (patch) {
                    return this.get(UpdateUIImages.DESC_EFIX_OBJ, problematic ? 1 : 0);
                }
                return this.get(UpdateUIImages.DESC_FEATURE_OBJ, problematic ? 1 : 0);
            }
            return null;
        }
    }

    class JobsContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        JobsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ReviewPage.this.jobs.toArray();
        }
    }
}

