/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.zip.ZipFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.model.SiteBookmark;

public class LocalSiteSelector {
    static String lastLocation = null;

    public static SiteBookmark getLocaLSite(Shell parent) {
        DirectoryDialog dialog = new DirectoryDialog(parent);
        dialog.setMessage(UpdateUI.getString("LocalSiteSelector.dialogMessage"));
        dialog.setFilterPath(lastLocation);
        String dir = dialog.open();
        SiteBookmark siteBookmark = null;
        while (dir != null && siteBookmark == null) {
            File dirFile = new File(dir);
            if (LocalSiteSelector.isDirSite(dirFile)) {
                siteBookmark = LocalSiteSelector.createDirSite(dirFile);
                lastLocation = dir;
                continue;
            }
            MessageDialog.openInformation((Shell)parent, (String)UpdateUI.getString("LocalSiteSelector.dirInfoTitle"), (String)UpdateUI.getString("LocalSiteSelector.dirInfoMessage"));
            dialog.setFilterPath(dir);
            dir = dialog.open();
        }
        return siteBookmark;
    }

    public static SiteBookmark getLocaLZippedSite(Shell parent) {
        FileDialog dialog = new FileDialog(parent);
        dialog.setText(UpdateUI.getString("LocalSiteSelector.dialogMessagezip"));
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        SiteBookmark siteBookmark = null;
        String zip = dialog.open();
        while (zip != null && siteBookmark == null) {
            File zipF = new File(zip);
            if (LocalSiteSelector.isZipSite(zipF)) {
                siteBookmark = LocalSiteSelector.createZipSite(zipF);
                continue;
            }
            MessageDialog.openInformation((Shell)parent, (String)UpdateUI.getString("LocalSiteSelector.zipInfoTitle"), (String)UpdateUI.getString("LocalSiteSelector.zipInfoMessage"));
            zip = dialog.open();
        }
        return siteBookmark;
    }

    static boolean isZipSite(File file) {
        if (!file.getName().toLowerCase().endsWith(".zip") && !file.getName().toLowerCase().endsWith(".jar")) {
            return false;
        }
        ZippedSiteValidator validator = new ZippedSiteValidator(file);
        BusyIndicator.showWhile((Display)UpdateUI.getActiveWorkbenchShell().getDisplay(), (Runnable)validator);
        return validator.isValid();
    }

    static boolean isDirSite(File dir) {
        File siteXML = new File(dir, "site.xml");
        File featuresDir = new File(dir, "features");
        File pluginsDir = new File(dir, "plugins");
        return siteXML.exists() || featuresDir.exists() && featuresDir.isDirectory() && pluginsDir.exists() && pluginsDir.isDirectory();
    }

    static SiteBookmark createZipSite(File file) {
        try {
            URL fileURL = new URL("file", null, file.getAbsolutePath());
            URL url = new URL("jar:" + fileURL.toExternalForm().replace('\\', '/') + "!/");
            SiteBookmark site = new SiteBookmark(file.getName(), url, false);
            site.setLocal(true);
            return site;
        }
        catch (Exception e) {
            return null;
        }
    }

    static SiteBookmark createDirSite(File file) {
        try {
            URL url = file.toURL();
            String siteName = file.getAbsolutePath();
            SiteBookmark site = new SiteBookmark(siteName, url, false);
            site.setLocal(true);
            return site;
        }
        catch (Exception e) {
            return null;
        }
    }

    static class ZippedSiteValidator
    implements Runnable {
        File file;
        boolean valid = false;

        public ZippedSiteValidator(File file) {
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block17: {
                block16: {
                    block15: {
                        siteZip = null;
                        try {
                            try {
                                siteZip = new ZipFile(this.file);
                                if (siteZip.getEntry("site.xml") != null) {
                                    this.valid = true;
                                    var7_2 = null;
                                    break block15;
                                }
                                hasFeatures = false;
                                hasPlugins = false;
                                enum = siteZip.entries();
                                while (enum.hasMoreElements()) {
                                    zEntry = enum.nextElement();
                                    if (!hasFeatures && zEntry.getName().startsWith("features")) {
                                        hasFeatures = true;
                                    }
                                    if (!hasPlugins && zEntry.getName().startsWith("plugins")) {
                                        hasPlugins = true;
                                    }
                                    if (!hasFeatures || !hasPlugins) continue;
                                    this.valid = true;
                                    break block16;
                                }
                                break block17;
                            }
                            catch (Exception var2_13) {
                                var7_5 = null;
                                try {
                                    if (siteZip == null) return;
                                    siteZip.close();
                                    return;
                                }
                                catch (IOException ioe) {
                                    return;
                                }
                            }
                        }
                        catch (Throwable var6_17) {
                            var7_6 = null;
                            ** try [egrp 2[TRYBLOCK] [8 : 145->156)] { 
lbl37:
                            // 1 sources

                            if (siteZip == null) throw var6_17;
                            siteZip.close();
                            throw var6_17;
lbl40:
                            // 1 sources

                            catch (IOException ioe) {
                                // empty catch block
                            }
                            throw var6_17;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [8 : 145->156)] { 
lbl45:
                    // 1 sources

                    if (siteZip == null) return;
                    siteZip.close();
                    return;
lbl48:
                    // 1 sources

                    catch (IOException ioe) {
                        // empty catch block
                    }
                    return;
                }
                var7_3 = null;
                ** try [egrp 2[TRYBLOCK] [8 : 145->156)] { 
lbl54:
                // 1 sources

                if (siteZip == null) return;
                siteZip.close();
                return;
lbl57:
                // 1 sources

                catch (IOException ioe) {
                    // empty catch block
                }
                return;
            }
            var7_4 = null;
            try {}
            catch (IOException ioe) {}
            if (siteZip == null) return;
            siteZip.close();
            return;
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

