/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.model;

import java.net.URL;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.update.core.ICategory;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.model.FeatureReferenceAdapter;
import org.eclipse.update.internal.ui.model.ISiteAdapter;
import org.eclipse.update.internal.ui.model.NamedModelObject;
import org.eclipse.update.internal.ui.model.SiteCategory;

public class SiteBookmark
extends NamedModelObject
implements ISiteAdapter {
    public static final String P_URL = "p_url";
    public static final String P_TYPE = "p_type";
    private URL url;
    private transient ISite site;
    private transient Vector catalog;
    private transient SiteCategory otherCategory;
    private boolean webBookmark;
    private boolean selected;
    private String[] ignoredCategories = new String[0];
    private boolean readOnly = false;
    private boolean local = false;
    private boolean unavailable = false;

    public SiteBookmark() {
    }

    public SiteBookmark(String name, URL url, boolean webBookmark) {
        this(name, url, webBookmark, false);
    }

    public SiteBookmark(String name, URL url, boolean webBookmark, boolean selected) {
        super(name);
        this.url = url;
        this.webBookmark = webBookmark;
        this.selected = selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public String[] getIgnoredCategories() {
        return this.ignoredCategories;
    }

    public void setIgnoredCategories(String[] categories) {
        this.ignoredCategories = categories;
    }

    public void setWebBookmark(boolean value) {
        if (this.isLocal()) {
            return;
        }
        this.webBookmark = value;
        this.notifyObjectChanged(P_TYPE);
    }

    public boolean isWebBookmark() {
        return this.webBookmark;
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL url) {
        this.url = url;
        this.site = null;
        this.notifyObjectChanged(P_URL);
    }

    public ISite getSite(IProgressMonitor monitor) {
        return this.getSite(true, monitor);
    }

    public ISite getSite(boolean showDialogIfFailed, IProgressMonitor monitor) {
        if (this.site == null) {
            try {
                this.connect(monitor);
            }
            catch (CoreException e) {
                UpdateUI.logException(e, showDialogIfFailed);
            }
        }
        return this.site;
    }

    public boolean isSiteConnected() {
        return this.site != null;
    }

    public void connect(IProgressMonitor monitor) throws CoreException {
        this.connect(true, monitor);
    }

    public void connect(boolean useCache, IProgressMonitor monitor) throws CoreException {
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask("", 2);
            monitor.subTask(UpdateUI.getFormattedMessage("SiteBookmark.connecting", this.url.toString()));
            this.site = SiteManager.getSite((URL)this.url, (boolean)useCache, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (this.site != null) {
                this.createCatalog((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.unavailable = false;
            } else {
                this.catalog = new Vector();
                this.unavailable = true;
            }
        }
        catch (CoreException e) {
            this.unavailable = true;
            throw e;
        }
    }

    public boolean isUnavailable() {
        return this.unavailable;
    }

    public void setUnavailable(boolean value) {
        this.unavailable = value;
    }

    private void createCatalog(IProgressMonitor monitor) {
        int i;
        this.catalog = new Vector();
        this.otherCategory = new SiteCategory(this, null, null);
        ICategory[] categories = this.site.getCategories();
        ISiteFeatureReference[] featureRefs = this.site.getRawFeatureReferences();
        monitor.beginTask("", featureRefs.length + categories.length);
        for (i = 0; i < categories.length; ++i) {
            ICategory category = categories[i];
            this.addCategoryToCatalog(category);
            monitor.worked(1);
        }
        for (i = 0; i < featureRefs.length; ++i) {
            ISiteFeatureReference featureRef = featureRefs[i];
            this.addFeatureToCatalog(featureRef);
            monitor.worked(1);
        }
        if (this.otherCategory.getChildCount() > 0) {
            this.catalog.add(this.otherCategory);
        }
    }

    public Object[] getCatalog(boolean withCategories, IProgressMonitor monitor) {
        if (withCategories) {
            return this.catalog.toArray();
        }
        Vector flatCatalog = new Vector();
        for (int i = 0; i < this.catalog.size(); ++i) {
            SiteCategory category = (SiteCategory)((Object)this.catalog.get(i));
            category.addFeaturesTo(flatCatalog);
        }
        return flatCatalog.toArray();
    }

    private void addCategoryToCatalog(ICategory category) {
        String name = category.getName();
        int loc = name.indexOf(47);
        if (loc == -1) {
            this.catalog.add(new SiteCategory(this, name, category));
        } else {
            Path path = new Path(name);
            name = path.lastSegment().toString();
            SiteCategory parentCategory = this.findCategory((IPath)(path = path.removeLastSegments(1)), this.catalog.toArray());
            if (parentCategory != null) {
                parentCategory.add((Object)new SiteCategory(this, name, category));
            }
        }
    }

    private void addFeatureToCatalog(ISiteFeatureReference feature) {
        ICategory[] categories = feature.getCategories();
        boolean orphan = true;
        for (int i = 0; i < categories.length; ++i) {
            ICategory category = categories[i];
            String name = category.getName();
            Path path = new Path(name);
            SiteCategory parentCategory = this.findCategory((IPath)path, this.catalog.toArray());
            if (parentCategory == null) continue;
            parentCategory.add(new FeatureReferenceAdapter((IFeatureReference)feature));
            orphan = false;
        }
        if (orphan) {
            this.otherCategory.add(new FeatureReferenceAdapter((IFeatureReference)feature));
        }
    }

    private SiteCategory findCategory(IPath path, Object[] children) {
        for (int i = 0; i < children.length; ++i) {
            SiteCategory sc;
            Object child = children[i];
            if (!(child instanceof SiteCategory) || !(sc = (SiteCategory)((Object)child)).getName().equals(path.segment(0))) continue;
            if (path.segmentCount() == 1) {
                return sc;
            }
            path = path.removeFirstSegments(1);
            return this.findCategory(path, sc.getChildren());
        }
        return null;
    }

    public String getLabel() {
        return this.getName();
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public boolean isLocal() {
        return this.local;
    }
}

