/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.math.BigInteger;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.preferences.IDebugPreferenceConstants;
import org.eclipse.debug.internal.ui.views.memory.AbstractMemoryRenderer;
import org.eclipse.debug.internal.ui.views.memory.AbstractTableViewTabLabelProvider;
import org.eclipse.debug.internal.ui.views.memory.IMemoryBlockModelPresentation;
import org.eclipse.debug.internal.ui.views.memory.ITableMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewLine;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewTab;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.graphics.Color;

public class MemoryViewTabLabelProvider
extends AbstractTableViewTabLabelProvider
implements IColorProvider {
    public MemoryViewTabLabelProvider() {
    }

    public MemoryViewTabLabelProvider(ITableMemoryViewTab viewTab, AbstractMemoryRenderer renderer) {
        super(viewTab, renderer);
    }

    public String getColumnText(Object element, int columnIndex) {
        String label = super.getColumnText(element, columnIndex);
        if (columnIndex == 0) {
            IMemoryBlockModelPresentation presentation;
            if (this.fViewTab instanceof MemoryViewTab && (presentation = ((MemoryViewTab)this.fViewTab).getMemoryBlockPresentation()) instanceof IMemoryBlockModelPresentation) {
                IMemoryBlockModelPresentation memPresentation = presentation;
                String address = ((MemoryViewLine)element).getAddress();
                String tempLabel = memPresentation.getAddressPresentation(this.fViewTab.getMemoryBlock(), new BigInteger(address, 16));
                if (tempLabel != null) {
                    return tempLabel;
                }
            }
            return label;
        }
        return label;
    }

    public Color getForeground(Object element) {
        if (element instanceof MemoryViewLine) {
            MemoryViewLine line = (MemoryViewLine)element;
            if (line.isMonitored) {
                return null;
            }
            return DebugUIPlugin.getPreferenceColor(IDebugPreferenceConstants.MEMORY_VIEW_UNBUFFERED_LINE_COLOR);
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

