/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.TextEditorMessages;
import org.osgi.framework.Bundle;

public class MarkerRulerAction
extends ResourceAction
implements IUpdate {
    private static final int MAX_LABEL_LENGTH = 80;
    private IVerticalRulerInfo fRuler;
    private ITextEditor fTextEditor;
    private String fMarkerType;
    private List fMarkers;
    private boolean fAskForLabel;
    private ResourceBundle fBundle;
    private String fPrefix;
    private String fAddLabel;
    private String fRemoveLabel;
    static /* synthetic */ Class class$org$eclipse$core$resources$IFile;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public MarkerRulerAction(ResourceBundle bundle, String prefix, ITextEditor editor, IVerticalRulerInfo ruler, String markerType, boolean askForLabel) {
        super(bundle, prefix);
        this.fRuler = ruler;
        this.fTextEditor = editor;
        this.fMarkerType = markerType;
        this.fAskForLabel = askForLabel;
        this.fBundle = bundle;
        this.fPrefix = prefix;
        this.fAddLabel = MarkerRulerAction.getString((ResourceBundle)bundle, (String)(prefix + "add.label"), (String)(prefix + "add.label"));
        this.fRemoveLabel = MarkerRulerAction.getString((ResourceBundle)bundle, (String)(prefix + "remove.label"), (String)(prefix + "remove.label"));
    }

    public MarkerRulerAction(ResourceBundle bundle, String prefix, IVerticalRuler ruler, ITextEditor editor, String markerType, boolean askForLabel) {
        this(bundle, prefix, editor, (IVerticalRulerInfo)ruler, markerType, askForLabel);
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected IVerticalRuler getVerticalRuler() {
        if (this.fRuler instanceof IVerticalRuler) {
            return (IVerticalRuler)this.fRuler;
        }
        return null;
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fRuler;
    }

    protected ResourceBundle getResourceBundle() {
        return this.fBundle;
    }

    protected String getResourceKeyPrefix() {
        return this.fPrefix;
    }

    public void update() {
        int line = this.getVerticalRuler().getLineOfLastMouseButtonActivity() + 1;
        IDocument document = this.getDocument();
        if (document != null) {
            if (line > this.getDocument().getNumberOfLines()) {
                this.setEnabled(false);
                this.setText(this.fAddLabel);
            } else {
                this.setEnabled(true);
                this.fMarkers = this.getMarkers();
                this.setText(this.fMarkers.isEmpty() ? this.fAddLabel : this.fRemoveLabel);
            }
        }
    }

    public void run() {
        if (this.fMarkers.isEmpty()) {
            this.addMarker();
        } else {
            this.removeMarkers(this.fMarkers);
        }
    }

    protected IResource getResource() {
        IEditorInput input = this.fTextEditor.getEditorInput();
        IResource resource = (IResource)input.getAdapter(class$org$eclipse$core$resources$IFile == null ? (class$org$eclipse$core$resources$IFile = MarkerRulerAction.class$("org.eclipse.core.resources.IFile")) : class$org$eclipse$core$resources$IFile);
        if (resource == null) {
            resource = (IResource)input.getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = MarkerRulerAction.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource);
        }
        return resource;
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel model = provider.getAnnotationModel((Object)this.fTextEditor.getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)model;
        }
        return null;
    }

    protected IDocument getDocument() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    protected boolean includesRulerLine(Position position, IDocument document) {
        if (position != null) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                int line = this.fRuler.getLineOfLastMouseButtonActivity();
                if (line == markerLine) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return false;
    }

    protected void handleCoreException(CoreException exception, String message) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        ILog log = Platform.getLog((Bundle)bundle);
        if (message != null) {
            log.log((IStatus)new Status(4, "org.eclipse.ui", 0, message, (Throwable)exception));
        } else {
            log.log(exception.getStatus());
        }
        Shell shell = this.getTextEditor().getSite().getShell();
        String title = MarkerRulerAction.getString((ResourceBundle)this.fBundle, (String)(this.fPrefix + "error.dialog.title"), (String)(this.fPrefix + "error.dialog.title"));
        String msg = MarkerRulerAction.getString((ResourceBundle)this.fBundle, (String)(this.fPrefix + "error.dialog.message"), (String)(this.fPrefix + "error.dialog.message"));
        ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)exception.getStatus());
    }

    protected List getMarkers() {
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        IResource resource = this.getResource();
        IDocument document = this.getDocument();
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        if (resource != null && model != null && resource.exists()) {
            try {
                IMarker[] allMarkers = resource.findMarkers(this.fMarkerType, true, 0);
                if (allMarkers != null) {
                    for (int i = 0; i < allMarkers.length; ++i) {
                        if (!this.includesRulerLine(model.getMarkerPosition(allMarkers[i]), document)) continue;
                        markers.add(allMarkers[i]);
                    }
                }
            }
            catch (CoreException x) {
                this.handleCoreException(x, TextEditorMessages.getString("MarkerRulerAction.getMarker"));
            }
        }
        return markers;
    }

    protected void addMarker() {
        IResource resource = this.getResource();
        if (resource == null) {
            return;
        }
        Map attributes = this.getInitialAttributes();
        if (this.fAskForLabel && !this.askForLabel(attributes)) {
            return;
        }
        try {
            MarkerUtilities.createMarker(resource, attributes, this.fMarkerType);
        }
        catch (CoreException x) {
            this.handleCoreException(x, TextEditorMessages.getString("MarkerRulerAction.addMarker"));
        }
    }

    protected void removeMarkers(final List markers) {
        try {
            this.getResource().getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    for (int i = 0; i < markers.size(); ++i) {
                        IMarker marker = (IMarker)markers.get(i);
                        marker.delete();
                    }
                }
            }, null, 1, null);
        }
        catch (CoreException x) {
            this.handleCoreException(x, TextEditorMessages.getString("MarkerRulerAction.removeMarkers"));
        }
    }

    protected boolean askForLabel(Map attributes) {
        String proposal;
        Object o = attributes.get("message");
        String string = proposal = o instanceof String ? (String)o : "";
        if (proposal == null) {
            proposal = "";
        }
        String title = MarkerRulerAction.getString((ResourceBundle)this.fBundle, (String)(this.fPrefix + "add.dialog.title"), (String)(this.fPrefix + "add.dialog.title"));
        String message = MarkerRulerAction.getString((ResourceBundle)this.fBundle, (String)(this.fPrefix + "add.dialog.message"), (String)(this.fPrefix + "add.dialog.message"));
        IInputValidator inputValidator = new IInputValidator(){

            public String isValid(String newText) {
                return newText == null || newText.trim().length() == 0 ? " " : null;
            }
        };
        InputDialog dialog = new InputDialog(this.fTextEditor.getSite().getShell(), title, message, proposal, inputValidator);
        String label = null;
        if (dialog.open() != 1) {
            label = dialog.getValue();
        }
        if (label == null) {
            return false;
        }
        if ((label = label.trim()).length() == 0) {
            return false;
        }
        MarkerUtilities.setMessage(attributes, label);
        return true;
    }

    protected Map getInitialAttributes() {
        HashMap attributes = new HashMap(11);
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        IDocument document = provider.getDocument((Object)this.fTextEditor.getEditorInput());
        int line = this.fRuler.getLineOfLastMouseButtonActivity();
        int start = -1;
        int end = -1;
        int length = 0;
        try {
            IRegion lineInformation = document.getLineInformation(line);
            start = lineInformation.getOffset();
            length = lineInformation.getLength();
            end = start + length;
        }
        catch (BadLocationException x) {
            // empty catch block
        }
        MarkerUtilities.setMessage(attributes, this.getLabelProposal(document, start, length));
        MarkerUtilities.setLineNumber(attributes, line + 1);
        MarkerUtilities.setCharStart(attributes, start);
        MarkerUtilities.setCharEnd(attributes, end);
        return attributes;
    }

    protected String getLabelProposal(IDocument document, int offset, int length) {
        try {
            String label = document.get(offset, length).trim();
            if (label.length() <= 80) {
                return label;
            }
            return label.substring(0, 80);
        }
        catch (BadLocationException x) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

