/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.swt;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;
import org.eclipse.ui.internal.intro.impl.IIntroConstants;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.model.AbstractBaseIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.eclipse.ui.internal.intro.impl.model.IntroGroup;
import org.eclipse.ui.internal.intro.impl.model.IntroHomePage;
import org.eclipse.ui.internal.intro.impl.model.IntroLink;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.IntroURLParser;
import org.eclipse.ui.internal.intro.impl.swt.PageStyleManager;
import org.eclipse.ui.internal.intro.impl.swt.SharedStyleManager;
import org.eclipse.ui.internal.intro.impl.util.DialogUtil;
import org.eclipse.ui.internal.intro.impl.util.StringUtil;
import org.eclipse.ui.internal.intro.impl.util.Util;

public class RootPageForm
implements IIntroConstants {
    private FormToolkit toolkit;
    private IntroHomePage rootPage;
    private Form parentForm;
    private Label descriptionLabel;
    private PageStyleManager rootPageStyleManager;
    private HyperlinkAdapter hyperlinkAdapter = new HyperlinkAdapter(){

        public void linkActivated(HyperlinkEvent e) {
            ImageHyperlink imageLink = (ImageHyperlink)e.getSource();
            IntroLink introLink = (IntroLink)imageLink.getData("IntroLink");
            IntroURLParser parser = new IntroURLParser(introLink.getUrl());
            if (parser.hasIntroUrl()) {
                parser.getIntroURL().execute();
                return;
            }
            if (parser.hasProtocol()) {
                Util.openBrowser(introLink.getUrl());
                return;
            }
            DialogUtil.displayInfoMessage(imageLink.getShell(), IntroPlugin.getString("HyperlinkAdapter.urlIs") + introLink.getUrl());
        }

        public void linkEntered(HyperlinkEvent e) {
            ImageHyperlink imageLink = (ImageHyperlink)e.getSource();
            IntroLink introLink = (IntroLink)imageLink.getData("IntroLink");
            this.updateDescription(introLink.getText());
        }

        public void linkExited(HyperlinkEvent e) {
            this.updateDescription("");
        }

        private void updateDescription(String text) {
            if (text == null) {
                text = "";
            }
            RootPageForm.this.descriptionLabel.setText(text);
            RootPageForm.this.descriptionLabel.getParent().layout();
        }
    };

    public RootPageForm(FormToolkit toolkit, IntroModelRoot modelRoot, Form parentForm) {
        this.toolkit = toolkit;
        this.rootPage = modelRoot.getHomePage();
        this.parentForm = parentForm;
    }

    public void createPartControl(ScrolledPageBook mainPageBook, SharedStyleManager shardStyleManager) {
        this.rootPageStyleManager = new PageStyleManager(this.rootPage, shardStyleManager.getProperties());
        this.parentForm.setText(this.rootPage.getTitle());
        PageComposite rootPageComposite = new PageComposite(mainPageBook.getContainer(), 0);
        this.toolkit.adapt((Composite)rootPageComposite);
        mainPageBook.registerPage((Object)this.rootPage.getId(), (Control)rootPageComposite);
        rootPageComposite.setLayout(new RootPageLayout());
        this.createRootPageContent(rootPageComposite);
        this.descriptionLabel = this.createHoverLabel(rootPageComposite);
        this.rootPageStyleManager = null;
    }

    private void createRootPageContent(Composite rootPageComposite) {
        Composite contentComposite = this.toolkit.createComposite(rootPageComposite);
        GridData gd = new GridData(64);
        contentComposite.setLayoutData((Object)gd);
        AbstractIntroElement[] children = (AbstractIntroElement[])this.rootPage.getChildrenOfType(80);
        int numChildren = children.length;
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = this.rootPageStyleManager.getPageHorizantalSpacing();
        layout.verticalSpacing = this.rootPageStyleManager.getPageVerticalSpacing();
        int numColumns = this.rootPageStyleManager.getPageNumberOfColumns();
        layout.numColumns = numColumns = numColumns == 0 ? numChildren : numColumns;
        layout.horizontalSpacing = this.rootPageStyleManager.getPageHorizantalSpacing();
        layout.verticalSpacing = this.rootPageStyleManager.getPageVerticalSpacing();
        contentComposite.setLayout((Layout)layout);
        for (int i = 0; i < children.length; ++i) {
            if (((AbstractBaseIntroElement)children[i]).isFiltered()) continue;
            if (children[i].getType() == 16) {
                this.createGroupContent(contentComposite, (IntroGroup)children[i]);
                continue;
            }
            if (children[i].getType() != 64) continue;
            this.createImageHyperlink(contentComposite, (IntroLink)children[i]);
        }
    }

    private void createGroupContent(Composite parent, IntroGroup group) {
        AbstractIntroElement[] children = (AbstractIntroElement[])group.getChildrenOfType(80);
        int numChildren = children.length;
        Composite contentComposite = this.toolkit.createComposite(parent);
        GridData gd = new GridData(64);
        gd.horizontalSpan = this.rootPageStyleManager.getColSpan(group);
        gd.verticalSpan = this.rootPageStyleManager.getRowSpan(group);
        contentComposite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 20;
        int numColumns = this.rootPageStyleManager.getNumberOfColumns(group);
        layout.numColumns = numColumns = numColumns < 1 ? numChildren : numColumns;
        layout.verticalSpacing = this.rootPageStyleManager.getVerticalSpacing(group);
        layout.horizontalSpacing = this.rootPageStyleManager.getHorizantalSpacing(group);
        contentComposite.setLayout((Layout)layout);
        for (int i = 0; i < children.length; ++i) {
            if (((AbstractBaseIntroElement)children[i]).isFiltered()) continue;
            if (children[i].getType() == 16) {
                this.createGroupContent(contentComposite, (IntroGroup)children[i]);
                continue;
            }
            if (children[i].getType() != 64) continue;
            this.createImageHyperlink(contentComposite, (IntroLink)children[i]);
        }
    }

    private void createImageHyperlink(Composite parent, IntroLink link) {
        Composite container = this.toolkit.createComposite(parent);
        GridData gd = new GridData(64);
        gd.horizontalSpan = this.rootPageStyleManager.getColSpan(link);
        gd.verticalSpan = this.rootPageStyleManager.getRowSpan(link);
        container.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        ImageHyperlink imageLink = this.toolkit.createImageHyperlink(container, 0);
        imageLink.setImage(this.rootPageStyleManager.getImage(link, "link-icon", "rootLink"));
        imageLink.setHoverImage(this.rootPageStyleManager.getImage(link, "hover-icon", null));
        gd = new GridData(64);
        imageLink.setLayoutData((Object)gd);
        imageLink.setData("IntroLink", (Object)link);
        imageLink.addHyperlinkListener((IHyperlinkListener)this.hyperlinkAdapter);
        Label linkLabel = this.toolkit.createLabel(container, link.getLabel());
        gd = new GridData(64);
        linkLabel.setFont(PageStyleManager.getBannerFont());
        linkLabel.setLayoutData((Object)gd);
    }

    private Label createHoverLabel(Composite body) {
        Label label = this.toolkit.createLabel(body, "", 64);
        String key = StringUtil.concat(this.rootPage.getId(), ".", "hover-text.fg").toString();
        Color fg = this.rootPageStyleManager.getColor(this.toolkit, key);
        if (fg == null) {
            fg = this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE");
        }
        label.setForeground(fg);
        label.setAlignment(0x1000000);
        label.setFont(PageStyleManager.getBannerFont());
        return label;
    }

    class RootPageLayout
    extends Layout {
        private int VERTICAL_SPACING = 20;
        private int LABEL_MARGIN_WIDTH = 5;

        RootPageLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            int innerWHint = wHint;
            if (wHint != -1) {
                innerWHint -= this.LABEL_MARGIN_WIDTH + this.LABEL_MARGIN_WIDTH;
            }
            Control[] children = composite.getChildren();
            Point s1 = children[0].computeSize(-1, -1);
            Point s2 = children[1].computeSize(innerWHint, -1);
            s2.x += this.LABEL_MARGIN_WIDTH;
            int height = 2 * (s2.y + this.VERTICAL_SPACING + s1.y / 2);
            Point size = new Point(Math.max(s1.x, s2.x), height + 5);
            return size;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Control[] children = composite.getChildren();
            Rectangle carea = composite.getClientArea();
            Control content = children[0];
            Control label = children[1];
            Point contentSize = content.computeSize(-1, -1);
            Point labelSize = label.computeSize(carea.width - 2 - this.LABEL_MARGIN_WIDTH * 2, -1);
            content.setBounds(carea.width / 2 - contentSize.x / 2, carea.height / 2 - contentSize.y / 2, contentSize.x, contentSize.y);
            label.setBounds(this.LABEL_MARGIN_WIDTH, content.getLocation().y + contentSize.y + this.VERTICAL_SPACING, carea.width - this.LABEL_MARGIN_WIDTH * 2, labelSize.y);
        }
    }

    class PageComposite
    extends Composite {
        public PageComposite(Composite parent, int style) {
            super(parent, style);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            return ((RootPageLayout)this.getLayout()).computeSize(this, wHint, hHint, changed);
        }
    }
}

