/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.parts;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.internal.context.IStyledContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.util.ImageUtil;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.config.IStandbyContentPart;

public class ContextHelpStandbyPart
implements IStandbyContentPart {
    private ScrolledForm form;
    private IPartListener2 partListener;
    private Label title;
    private Text phraseText;
    private FormText text;
    private String defaultText;
    private static final String HELP_KEY = "org.eclipse.ui.help";

    public void init(IIntroPart introPart, IMemento memento) {
        this.partListener = new PartListener();
        this.defaultText = IntroPlugin.getString("ContextHelpStandbyPart.defaultText");
        ImageUtil.registerImage("helpTopic", "help_topic.gif");
    }

    public void createPartControl(Composite parent, FormToolkit toolkit) {
        this.form = toolkit.createScrolledForm(parent);
        TableWrapLayout layout = new TableWrapLayout();
        this.form.getBody().setLayout((Layout)layout);
        Composite helpContainer = toolkit.createComposite(this.form.getBody());
        GridLayout glayout = new GridLayout();
        glayout.numColumns = 3;
        glayout.marginHeight = 1;
        glayout.marginWidth = 1;
        helpContainer.setLayout((Layout)glayout);
        helpContainer.setLayoutData((Object)new TableWrapData(256));
        toolkit.paintBordersFor(helpContainer);
        Label label = toolkit.createLabel(helpContainer, IntroPlugin.getString("ContextHelpStandbyPart.search"));
        label.setLayoutData((Object)new GridData(4));
        this.phraseText = toolkit.createText(helpContainer, "");
        this.phraseText.setLayoutData((Object)new GridData(768));
        final Button button = toolkit.createButton(helpContainer, IntroPlugin.getString("ContextHelpStandbyPart.button.go"), 8);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContextHelpStandbyPart.this.doSearch(ContextHelpStandbyPart.this.phraseText.getText());
            }
        });
        button.setEnabled(false);
        this.phraseText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ContextHelpStandbyPart.this.phraseText.getText();
                button.setEnabled(text.length() > 0);
            }
        });
        this.phraseText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r' && button.isEnabled()) {
                    ContextHelpStandbyPart.this.doSearch(ContextHelpStandbyPart.this.phraseText.getText());
                }
            }
        });
        this.title = toolkit.createLabel(this.form.getBody(), null, 64);
        this.title.setText(IntroPlugin.getString("ContextHelpStandbyPart.contextHelpArea.Title"));
        this.title.setFont(JFaceResources.getHeaderFont());
        this.title.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.text = toolkit.createFormText(this.form.getBody(), true);
        this.text.setImage("helpTopic", ImageUtil.getImage("helpTopic"));
        this.text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ContextHelpStandbyPart.this.openLink(e.getHref());
            }
        });
        this.text.setLayoutData((Object)new TableWrapData(128, 128));
        this.text.setText(this.defaultText, false, false);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IPartService service = window.getPartService();
        service.addPartListener(this.partListener);
        toolkit.paintBordersFor(this.form.getBody());
    }

    public Control getControl() {
        return this.form;
    }

    private void doSearch(String phrase) {
        try {
            String ephrase = URLEncoder.encode(phrase, "UTF-8");
            String query = "tab=search&searchWord=" + ephrase;
            WorkbenchHelp.displayHelpResource((String)query);
        }
        catch (UnsupportedEncodingException e) {
            System.out.println(e);
        }
    }

    private void handlePartActivation(IWorkbenchPartReference ref, boolean activated) {
        if (this.text.isDisposed()) {
            return;
        }
        IWorkbenchPart part = ref.getPart(false);
        String partId = part.getSite().getId();
        if (partId.equals("org.eclipse.ui.internal.introview")) {
            return;
        }
        if (activated) {
            this.title.setText(IntroPlugin.getString("ContextHelpStandbyPart.whatIsArea.Title") + " \"" + part.getSite().getRegisteredName() + "\"?");
            String helpText = this.createContextHelp(part);
            this.text.setText(helpText != null ? helpText : "", helpText != null, false);
        } else {
            this.title.setText(IntroPlugin.getString("ContextHelpStandbyPart.contextHelpArea.Title"));
            this.text.setText(this.defaultText, false, false);
        }
        this.form.getBody().layout();
        this.form.reflow(true);
    }

    private String createContextHelp(IWorkbenchPart part) {
        IContext helpContext;
        Display display;
        Control c;
        String text = null;
        if (part != null && (c = (display = part.getSite().getShell().getDisplay()).getFocusControl()) != null && c.isVisible() && !c.isDisposed() && (helpContext = this.findHelpContext(c)) != null) {
            text = this.formatHelpContext(helpContext);
        }
        return text;
    }

    private IContext findHelpContext(Control c) {
        String contextId = null;
        Control node = c;
        while ((contextId = (String)node.getData(HELP_KEY)) == null && (node = node.getParent()) != null) {
        }
        if (contextId != null) {
            return HelpSystem.getContext((String)contextId);
        }
        return null;
    }

    private String formatHelpContext(IContext context) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<form>");
        sbuf.append("<p>");
        sbuf.append(this.decodeContextBoldTags(context));
        sbuf.append("</p>");
        IHelpResource[] links = context.getRelatedTopics();
        if (links.length > 0) {
            for (int i = 0; i < links.length; ++i) {
                IHelpResource link = links[i];
                sbuf.append("<li style=\"text\" indent=\"2\">");
                sbuf.append("<img href=\"");
                sbuf.append("helpTopic");
                sbuf.append("\"/> ");
                sbuf.append("<a href=\"");
                sbuf.append(link.getHref());
                sbuf.append("\">");
                sbuf.append(link.getLabel());
                sbuf.append("</a>");
                sbuf.append("</li>");
            }
        }
        sbuf.append("</form>");
        return sbuf.toString();
    }

    private String decodeContextBoldTags(IContext context) {
        String styledText = context instanceof IStyledContext ? ((IStyledContext)context).getStyledText() : context.getText();
        String decodedString = styledText.replaceAll("<@#\\$b>", "<b>");
        decodedString = decodedString.replaceAll("</@#\\$b>", "</b>");
        return decodedString;
    }

    private void openLink(Object href) {
        String url = (String)href;
        if (url != null) {
            WorkbenchHelp.displayHelpResource((String)url);
        }
    }

    public void dispose() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IPartService service = window.getPartService();
        if (service == null) {
            return;
        }
        service.removePartListener(this.partListener);
    }

    public void setFocus() {
        this.phraseText.setFocus();
    }

    public void setInput(Object input) {
    }

    public void saveState(IMemento memento) {
    }

    class PartListener
    implements IPartListener2 {
        PartListener() {
        }

        public void partActivated(IWorkbenchPartReference ref) {
            ContextHelpStandbyPart.this.handlePartActivation(ref, true);
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
            ContextHelpStandbyPart.this.handlePartActivation(ref, false);
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partHidden(IWorkbenchPartReference ref) {
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
        }
    }
}

