/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.IntroPartPresentation;
import org.eclipse.ui.internal.intro.impl.model.IntroURLAction;
import org.eclipse.ui.internal.intro.impl.model.loader.ExtensionPointManager;
import org.eclipse.ui.internal.intro.impl.model.loader.ModelLoaderUtil;
import org.eclipse.ui.internal.intro.impl.parts.StandbyPart;
import org.eclipse.ui.internal.intro.impl.util.DialogUtil;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.eclipse.ui.internal.intro.impl.util.Util;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.CustomizableIntroPart;
import org.eclipse.ui.intro.config.IIntroAction;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IntroURLFactory;

public class IntroURL
implements IIntroURL {
    public static final String INTRO_PROTOCOL = "http";
    public static final String INTRO_HOST_ID = "org.eclipse.ui.intro";
    public static final String SET_STANDBY_MODE = "setStandbyMode";
    public static final String SHOW_STANDBY = "showStandby";
    public static final String CLOSE = "close";
    public static final String SHOW_HELP_TOPIC = "showHelpTopic";
    public static final String SHOW_HELP = "showHelp";
    public static final String OPEN_BROWSER = "openBrowser";
    public static final String RUN_ACTION = "runAction";
    public static final String SHOW_PAGE = "showPage";
    public static final String SHOW_MESSAGE = "showMessage";
    public static final String NAVIGATE = "navigate";
    public static final String KEY_ID = "id";
    public static final String KEY_PLUGIN_ID = "pluginId";
    public static final String KEY_CLASS = "class";
    public static final String KEY_STANDBY = "standby";
    public static final String KEY_PART_ID = "partId";
    public static final String KEY_INPUT = "input";
    public static final String KEY_MESSAGE = "message";
    public static final String KEY_URL = "url";
    public static final String KEY_DIRECTION = "direction";
    public static final String VALUE_BACKWARD = "backward";
    public static final String VALUE_FORWARD = "forward";
    public static final String VALUE_HOME = "home";
    private String action = null;
    private Properties parameters = null;
    static /* synthetic */ Class class$org$eclipse$ui$internal$intro$impl$parts$StandbyPart;
    static /* synthetic */ Class class$org$eclipse$ui$internal$intro$impl$model$IntroPartPresentation;

    IntroURL(String action, Properties parameters) {
        this.action = action;
        this.parameters = parameters;
    }

    public boolean execute() {
        final boolean[] result = new boolean[1];
        Display display = Display.getCurrent();
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            public void run() {
                result[0] = IntroURL.this.doExecute();
            }
        });
        return result[0];
    }

    private boolean doExecute() {
        if (this.action.equals(CLOSE)) {
            return this.closeIntro();
        }
        if (this.action.equals(SET_STANDBY_MODE)) {
            return this.setStandbyState(this.getParameter(KEY_STANDBY));
        }
        if (this.action.equals(SHOW_STANDBY)) {
            return this.handleStandbyState(this.getParameter(KEY_PART_ID), this.getParameter(KEY_INPUT));
        }
        if (this.action.equals(SHOW_HELP)) {
            return this.showHelp();
        }
        if (this.action.equals(SHOW_HELP_TOPIC)) {
            return this.showHelpTopic(this.getParameter(KEY_ID));
        }
        if (this.action.equals(OPEN_BROWSER)) {
            return this.openBrowser(this.getParameter(KEY_URL), this.getParameter(KEY_PLUGIN_ID));
        }
        if (this.action.equals(RUN_ACTION)) {
            return this.runAction(this.getParameter(KEY_PLUGIN_ID), this.getParameter(KEY_CLASS), this.parameters, this.getParameter(KEY_STANDBY));
        }
        if (this.action.equals(SHOW_PAGE)) {
            return this.showPage(this.getParameter(KEY_ID), this.getParameter(KEY_STANDBY));
        }
        if (this.action.equals(SHOW_MESSAGE)) {
            return this.showMessage(this.getParameter(KEY_MESSAGE));
        }
        if (this.action.equals(NAVIGATE)) {
            return this.navigate(this.getParameter(KEY_DIRECTION));
        }
        return this.handleCustomAction();
    }

    private boolean closeIntro() {
        return IntroPlugin.closeIntro();
    }

    private boolean handleStandbyState(String partId, String input) {
        CustomizableIntroPart introPart = (CustomizableIntroPart)IntroPlugin.getIntro();
        if (introPart == null) {
            introPart = (CustomizableIntroPart)IntroPlugin.showIntro(true);
        }
        introPart.getControl().setData("showStandbyPart", (Object)"true");
        IntroPlugin.setIntroStandby(true);
        StandbyPart standbyPart = (StandbyPart)introPart.getAdapter(class$org$eclipse$ui$internal$intro$impl$parts$StandbyPart == null ? (class$org$eclipse$ui$internal$intro$impl$parts$StandbyPart = IntroURL.class$("org.eclipse.ui.internal.intro.impl.parts.StandbyPart")) : class$org$eclipse$ui$internal$intro$impl$parts$StandbyPart);
        boolean success = standbyPart.showContentPart(partId, input);
        if (success) {
            return true;
        }
        standbyPart.setTopControl("org.eclipse.ui.intro.config.emptyStandby");
        return false;
    }

    private boolean setStandbyState(String state) {
        if (state == null) {
            return false;
        }
        boolean standby = state.equals("true");
        IIntroPart introPart = IntroPlugin.showIntro(standby);
        return introPart != null;
    }

    private boolean runAction(String pluginId, String className, Properties parameters, String standbyState) {
        Object actionObject = ModelLoaderUtil.createClassInstance(pluginId, className);
        try {
            if (actionObject instanceof IIntroAction) {
                IIntroAction introAction = (IIntroAction)actionObject;
                IIntroSite site = IntroPlugin.getDefault().getIntroModelRoot().getPresentation().getIntroPart().getIntroSite();
                introAction.run(site, parameters);
            } else if (actionObject instanceof IAction) {
                IAction action = (IAction)actionObject;
                action.run();
            } else if (actionObject instanceof IActionDelegate) {
                final IActionDelegate delegate = (IActionDelegate)actionObject;
                if (delegate instanceof IWorkbenchWindowActionDelegate) {
                    ((IWorkbenchWindowActionDelegate)delegate).init(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                }
                Action proxy = new Action(this.action){

                    public void run() {
                        delegate.run((IAction)this);
                    }
                };
                proxy.run();
            } else {
                return false;
            }
            if (standbyState == null) {
                return true;
            }
            return this.setStandbyState(standbyState);
        }
        catch (Exception e) {
            Log.error("Could not run action: " + className, e);
            return false;
        }
    }

    private boolean showHelpTopic(String href) {
        WorkbenchHelp.displayHelpResource((String)href);
        return true;
    }

    private boolean showHelp() {
        WorkbenchHelp.displayHelp();
        return true;
    }

    private boolean openBrowser(String url, String pluginId) {
        url = IntroModelRoot.resolveURL(url, pluginId);
        return Util.openBrowser(url);
    }

    private boolean showMessage(String message) {
        if (message == null) {
            return false;
        }
        try {
            message = URLDecoder.decode(message, "UTF-8");
            DialogUtil.displayInfoMessage(null, message);
            return true;
        }
        catch (UnsupportedEncodingException e) {
            DialogUtil.displayInfoMessage(null, "IntroURL.failedToDecode", new Object[]{message});
            return false;
        }
    }

    private boolean showPage(String pageId, String standbyState) {
        CustomizableIntroPart currentIntroPart = (CustomizableIntroPart)IntroPlugin.getIntro();
        currentIntroPart.getControl().setRedraw(false);
        IntroModelRoot modelRoot = IntroPlugin.getDefault().getIntroModelRoot();
        boolean success = modelRoot.setCurrentPageId(pageId);
        if (!success) {
            success = this.includePageToShow(modelRoot, pageId);
        }
        currentIntroPart.getControl().setRedraw(true);
        if (success) {
            modelRoot.getPresentation().updateHistory(pageId);
            if (standbyState == null) {
                return true;
            }
            return this.setStandbyState(standbyState);
        }
        return false;
    }

    private boolean includePageToShow(IntroModelRoot model, String pageId) {
        AbstractIntroPage page = this.findPageToShow(pageId);
        if (page == null) {
            Log.error("Failed to clone Intro page.", null);
            return false;
        }
        page.getChildren();
        String currentPresentationKind = model.getPresentation().getImplementationKind();
        IntroPartPresentation targetPresentation = ((IntroModelRoot)page.getParent()).getPresentation();
        String targetSharedStyle = targetPresentation.getSharedStyle(currentPresentationKind);
        AbstractIntroPage clonedPage = null;
        try {
            clonedPage = (AbstractIntroPage)page.clone();
        }
        catch (CloneNotSupportedException ex) {
            Log.error("Failed to clone Intro model node.", ex);
            return false;
        }
        clonedPage.setParent(model);
        if (targetSharedStyle != null) {
            clonedPage.insertStyle(targetSharedStyle, 0);
        }
        model.children.add(clonedPage);
        return model.setCurrentPageId(clonedPage.getId());
    }

    private AbstractIntroPage findPageToShow(String pageId) {
        Hashtable models = ExtensionPointManager.getInst().getIntroModels();
        Enumeration values = models.elements();
        while (values.hasMoreElements()) {
            IntroModelRoot model = (IntroModelRoot)values.nextElement();
            AbstractIntroPage page = (AbstractIntroPage)model.findChild(pageId, 12);
            if (page == null) continue;
            return page;
        }
        return null;
    }

    private boolean navigate(String direction) {
        CustomizableIntroPart introPart = (CustomizableIntroPart)IntroPlugin.getIntro();
        if (introPart == null) {
            return false;
        }
        IntroPartPresentation presentation = (IntroPartPresentation)introPart.getAdapter(class$org$eclipse$ui$internal$intro$impl$model$IntroPartPresentation == null ? (class$org$eclipse$ui$internal$intro$impl$model$IntroPartPresentation = IntroURL.class$("org.eclipse.ui.internal.intro.impl.model.IntroPartPresentation")) : class$org$eclipse$ui$internal$intro$impl$model$IntroPartPresentation);
        if (direction.equalsIgnoreCase(VALUE_BACKWARD)) {
            return presentation.navigateBackward();
        }
        if (direction.equalsIgnoreCase(VALUE_FORWARD)) {
            return presentation.navigateForward();
        }
        if (direction.equalsIgnoreCase(VALUE_HOME)) {
            return presentation.navigateHome();
        }
        return false;
    }

    public String getAction() {
        return this.action;
    }

    public String getParameter(String parameterId) {
        return this.parameters.getProperty(parameterId);
    }

    private boolean handleCustomAction() {
        IntroURLAction command = ExtensionPointManager.getInst().getSharedConfigExtensionsManager().getCommand(this.action);
        if (command == null) {
            DialogUtil.displayInfoMessage(null, "IntroURL.badCommand", new Object[]{this.action});
            return false;
        }
        StringBuffer url = new StringBuffer();
        url.append("http://org.eclipse.ui.intro/");
        url.append(command.getReplaceValue().trim());
        if (command.getReplaceValue().indexOf("?") == -1) {
            url.append("?");
        } else {
            url.append("&");
        }
        url.append(this.retrieveInitialQuery());
        IIntroURL introURL = IntroURLFactory.createIntroURL(url.toString());
        if (introURL != null) {
            return introURL.execute();
        }
        return false;
    }

    private String retrieveInitialQuery() {
        StringBuffer query = new StringBuffer();
        Enumeration<Object> keys = this.parameters.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            query.append(key);
            query.append("=");
            query.append(this.parameters.get(key));
            if (!keys.hasMoreElements()) continue;
            query.append("&");
        }
        return query.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

