/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroContainer;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.eclipse.ui.internal.intro.impl.model.IntroHead;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.IntroPageTitle;
import org.eclipse.ui.internal.intro.impl.model.loader.IntroContentParser;
import org.eclipse.ui.internal.intro.impl.model.loader.ModelLoaderUtil;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractIntroPage
extends AbstractIntroContainer {
    protected static final String TAG_PAGE = "page";
    private static final String ATT_STYLE = "style";
    private static final String ATT_ALT_STYLE = "alt-style";
    private static final String ATT_CONTENT = "content";
    private String style;
    private String altStyle;
    private IntroPageTitle title;
    private String content;
    private Vector styles;
    private Hashtable altStyles;

    AbstractIntroPage(Element element, Bundle bundle) {
        super(element, bundle);
        this.content = this.getAttribute(element, ATT_CONTENT);
        if (this.content == null) {
            this.init(element, bundle);
        } else {
            this.content = IntroModelRoot.getPluginLocation(this.content, bundle);
        }
    }

    private void init(Element element, Bundle bundle) {
        this.style = this.getAttribute(element, ATT_STYLE);
        this.altStyle = this.getAttribute(element, ATT_ALT_STYLE);
        this.style = IntroModelRoot.getPluginLocation(this.style, bundle);
        this.altStyle = IntroModelRoot.getPluginLocation(this.altStyle, bundle);
    }

    public String getTitle() {
        IntroPageTitle[] titles;
        this.getChildren();
        if (this.title == null && (titles = (IntroPageTitle[])this.getChildrenOfType(4096)).length > 0) {
            this.title = titles[0];
        }
        if (this.title == null) {
            return null;
        }
        return this.title.getTitle();
    }

    public String getStyle() {
        return this.style;
    }

    public String getAltStyle() {
        return this.altStyle;
    }

    public String[] getStyles() {
        this.getChildren();
        Object[] stylesArray = new String[this.styles.size()];
        this.styles.copyInto(stylesArray);
        return stylesArray;
    }

    public Hashtable getAltStyles() {
        this.getChildren();
        return this.altStyles;
    }

    protected void addStyle(String style) {
        this.initStylesVectors();
        if (this.styles.contains(style)) {
            return;
        }
        this.styles.add(style);
    }

    public void insertStyle(String style, int location) {
        this.initStylesVectors();
        if (this.styles.contains(style)) {
            return;
        }
        this.styles.add(location, style);
    }

    protected void addAltStyle(String altStyle, Bundle bundle) {
        this.initStylesVectors();
        if (this.altStyles.containsKey(altStyle)) {
            return;
        }
        this.altStyles.put(altStyle, bundle);
    }

    protected void addStyles(String[] styles) {
        for (int i = 0; i < styles.length; ++i) {
            this.addStyle(styles[i]);
        }
    }

    protected void addAltStyles(Hashtable altStyles) {
        this.altStyles.putAll(altStyles);
    }

    public int getType() {
        return 12;
    }

    protected void resolveChildren() {
        this.initStylesVectors();
        super.resolveChildren();
    }

    private void initStylesVectors() {
        if (this.styles == null) {
            this.styles = new Vector();
        }
        if (this.altStyles == null) {
            this.altStyles = new Hashtable();
        }
    }

    protected AbstractIntroElement getModelChild(Element childElement, Bundle bundle) {
        AbstractIntroElement child = null;
        if (childElement.getNodeName().equalsIgnoreCase("head")) {
            child = new IntroHead(childElement, bundle);
        } else if (childElement.getNodeName().equalsIgnoreCase("title") && this.title == null) {
            child = new IntroPageTitle(childElement, bundle);
        }
        if (child != null) {
            return child;
        }
        return super.getModelChild(childElement, bundle);
    }

    public IntroHead[] getHTMLHeads() {
        return (IntroHead[])this.getChildrenOfType(2048);
    }

    protected void loadChildren() {
        if (this.content == null) {
            super.loadChildren();
            return;
        }
        Document dom = new IntroContentParser(this.content).getDocument();
        if (dom == null) {
            return;
        }
        Element[] pages = ModelLoaderUtil.getElementsByTagName(dom, TAG_PAGE);
        if (pages.length == 0) {
            Log.warning("Content file has no pages.");
            return;
        }
        boolean foundMatchingPage = false;
        for (int i = 0; i < pages.length; ++i) {
            Element pageElement = pages[i];
            if (!pageElement.getAttribute("id").equals(this.getId())) continue;
            this.element = pageElement;
            this.init(pageElement, this.getBundle());
            this.style_id = this.element.getAttribute("style-id");
            this.filteredFrom = this.element.getAttribute("filteredFrom");
            foundMatchingPage = true;
        }
        if (foundMatchingPage) {
            super.loadChildren();
        } else {
            this.children = new Vector();
            this.loaded = true;
            this.element = null;
            Log.warning("Content file does not have page with id= " + this.getId());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractIntroPage clone = (AbstractIntroPage)super.clone();
        if (this.title != null) {
            IntroPageTitle clonedTitle = (IntroPageTitle)this.title.clone();
            clonedTitle.setParent(clone);
            clone.title = clonedTitle;
        }
        if (this.styles != null) {
            clone.styles = (Vector)this.styles.clone();
        }
        if (this.altStyles != null) {
            clone.altStyles = (Hashtable)this.altStyles.clone();
        }
        return clone;
    }
}

