/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.internal.runtime.CipherInputStream;
import org.eclipse.core.internal.runtime.CipherOutputStream;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.internal.runtime.URLTool;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;

public class AuthorizationDatabase {
    private static final int KEYRING_FILE_VERSION = 1;
    private Hashtable authorizationInfo = new Hashtable(5);
    private Hashtable protectionSpace = new Hashtable(5);
    private File file = null;
    private String password = null;
    private boolean needsSaving = true;

    public AuthorizationDatabase() {
    }

    public AuthorizationDatabase(String filename, String password) throws CoreException {
        Assert.isNotNull(filename);
        Assert.isNotNull(password);
        this.password = password;
        this.file = new File(filename);
        this.load();
    }

    public void addAuthorizationInfo(URL serverUrl, String realm, String authScheme, Map info) {
        Hashtable<String, Map> authSchemeToInfo;
        Assert.isNotNull(serverUrl);
        Assert.isNotNull(realm);
        Assert.isNotNull(authScheme);
        Assert.isNotNull(info);
        String url = serverUrl.toString();
        Hashtable<String, Hashtable<String, Map>> realmToAuthScheme = (Hashtable<String, Hashtable<String, Map>>)this.authorizationInfo.get(url);
        if (realmToAuthScheme == null) {
            realmToAuthScheme = new Hashtable<String, Hashtable<String, Map>>(5);
            this.authorizationInfo.put(url, realmToAuthScheme);
        }
        if ((authSchemeToInfo = (Hashtable<String, Map>)realmToAuthScheme.get(realm)) == null) {
            authSchemeToInfo = new Hashtable<String, Map>(5);
            realmToAuthScheme.put(realm, authSchemeToInfo);
        }
        authSchemeToInfo.put(authScheme.toLowerCase(), info);
        this.needsSaving = true;
    }

    public void addProtectionSpace(URL resourceUrl, String realm) {
        String oldRealm;
        Assert.isNotNull(resourceUrl);
        Assert.isNotNull(realm);
        if (!resourceUrl.getFile().endsWith("/")) {
            resourceUrl = URLTool.getParent(resourceUrl);
        }
        if ((oldRealm = this.getProtectionSpace(resourceUrl)) != null && oldRealm.equals(realm)) {
            return;
        }
        String url1 = resourceUrl.toString();
        Enumeration urls = this.protectionSpace.keys();
        while (urls.hasMoreElements()) {
            String url2 = (String)urls.nextElement();
            if (!url1.startsWith(url2) && !url2.startsWith(url1)) continue;
            this.protectionSpace.remove(url2);
            break;
        }
        this.protectionSpace.put(url1, realm);
        this.needsSaving = true;
    }

    public void flushAuthorizationInfo(URL serverUrl, String realm, String authScheme) {
        Hashtable realmToAuthScheme = (Hashtable)this.authorizationInfo.get(serverUrl.toString());
        if (realmToAuthScheme == null) {
            return;
        }
        Hashtable authSchemeToInfo = (Hashtable)realmToAuthScheme.get(realm);
        if (authSchemeToInfo == null) {
            return;
        }
        authSchemeToInfo.remove(authScheme.toLowerCase());
        this.needsSaving = true;
    }

    public Map getAuthorizationInfo(URL serverUrl, String realm, String authScheme) {
        Hashtable realmToAuthScheme = (Hashtable)this.authorizationInfo.get(serverUrl.toString());
        if (realmToAuthScheme == null) {
            return null;
        }
        Hashtable authSchemeToInfo = (Hashtable)realmToAuthScheme.get(realm);
        if (authSchemeToInfo == null) {
            return null;
        }
        return (Map)authSchemeToInfo.get(authScheme.toLowerCase());
    }

    public String getProtectionSpace(URL resourceUrl) {
        while (resourceUrl != null) {
            String realm = (String)this.protectionSpace.get(resourceUrl.toString());
            if (realm != null) {
                return realm;
            }
            resourceUrl = URLTool.getParent(resourceUrl);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws CoreException {
        if (this.file == null) {
            return;
        }
        if (!this.file.exists()) {
            this.save();
            return;
        }
        try {
            FileInputStream input = new FileInputStream(this.file);
            try {
                this.load(input);
            }
            finally {
                ((InputStream)input).close();
            }
        }
        catch (IOException e) {
            throw new CoreException(new Status(4, "org.eclipse.core.runtime", 4, Policy.bind("meta.unableToReadAuthorization", this.file.toString()), e));
        }
        catch (ClassNotFoundException e) {
            throw new CoreException(new Status(4, "org.eclipse.core.runtime", 4, Policy.bind("meta.unableToReadAuthorization", this.file.toString()), e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(InputStream is) throws IOException, ClassNotFoundException, CoreException {
        int version = is.read();
        if (version == 1) {
            CipherInputStream cis = new CipherInputStream(is, this.password);
            ObjectInputStream ois = new ObjectInputStream(cis);
            try {
                this.authorizationInfo = (Hashtable)ois.readObject();
                this.protectionSpace = (Hashtable)ois.readObject();
            }
            finally {
                ois.close();
            }
        }
        InternalPlatform.getDefault().log(new Status(2, "org.eclipse.core.runtime", 4, Policy.bind("meta.authFormatChanged"), null));
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.needsSaving = true;
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws CoreException {
        if (!this.needsSaving || this.file == null) {
            return;
        }
        try {
            this.file.delete();
            if (!this.file.getParentFile().exists() && !this.file.getParentFile().mkdirs() || !AuthorizationDatabase.canWrite(this.file.getParentFile())) {
                throw new CoreException(new Status(4, "org.eclipse.core.runtime", 5, Policy.bind("meta.unableToWriteAuthorization", this.file.toString()), null));
            }
            this.file.createNewFile();
            FileOutputStream out = new FileOutputStream(this.file);
            try {
                this.save(out);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            throw new CoreException(new Status(4, "org.eclipse.core.runtime", 5, Policy.bind("meta.unableToWriteAuthorization", this.file.toString()), e));
        }
        this.needsSaving = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canWrite(File installDir) {
        if (!installDir.canWrite()) {
            return false;
        }
        if (!installDir.isDirectory()) {
            return false;
        }
        File fileTest = null;
        try {
            fileTest = File.createTempFile("writtableArea", null, installDir);
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileTest != null) {
                fileTest.delete();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(OutputStream os) throws IOException {
        os.write(1);
        CipherOutputStream cos = new CipherOutputStream(os, this.password);
        ObjectOutputStream oos = new ObjectOutputStream(cos);
        try {
            oos.writeObject(this.authorizationInfo);
            oos.writeObject(this.protectionSpace);
        }
        finally {
            oos.close();
        }
    }

    public boolean setPassword(String oldValue, String newValue) {
        if (!oldValue.equals(this.password)) {
            return false;
        }
        this.password = newValue;
        this.needsSaving = true;
        return true;
    }
}

