/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.misc;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class AcceleratorHook
implements Listener {
    private ArrayList actionList = new ArrayList(5);

    public AcceleratorHook(Control ctrl) {
        ctrl.addListener(1, (Listener)this);
        ctrl.addListener(2, (Listener)this);
    }

    public void add(IAction action) {
        if (action.getAccelerator() == 0) {
            return;
        }
        this.actionList.add(new ActionItem(action.getAccelerator(), action));
    }

    public void add(IAction action, String strAccel) {
        FakeAction fakeAction = new FakeAction("Fake\t" + strAccel);
        if (fakeAction.getAccelerator() == 0) {
            return;
        }
        this.actionList.add(new ActionItem(fakeAction.getAccelerator(), action));
    }

    private ActionItem findItem(IAction action) {
        Iterator iter = this.actionList.iterator();
        while (iter.hasNext()) {
            ActionItem item = (ActionItem)iter.next();
            if (item.action != action) continue;
            return item;
        }
        return null;
    }

    private ActionItem findItem(Event e) {
        int accel = this.getAccel(e);
        if (accel == 0) {
            return null;
        }
        Iterator iter = this.actionList.iterator();
        while (iter.hasNext()) {
            ActionItem item = (ActionItem)iter.next();
            if (item.accelerator != accel) continue;
            return item;
        }
        return null;
    }

    private int getAccel(Event e) {
        int key = Character.toUpperCase(e.character);
        int mods = 0;
        if ((e.stateMask & 0x10000) > 0) {
            mods |= 0x10000;
        }
        if ((e.stateMask & 0x20000) > 0) {
            mods |= 0x20000;
        }
        if ((e.stateMask & 0x40000) > 0) {
            mods |= 0x40000;
            key = key + 65 - 1;
        }
        int accel = key | mods | e.keyCode;
        return accel;
    }

    public void handleEvent(Event event) {
        ActionItem item = this.findItem(event);
        if (item != null) {
            item.action.runWithEvent(event);
        }
    }

    public void remove(IAction action) {
        ActionItem item = this.findItem(action);
        if (item != null) {
            this.actionList.remove(item);
        }
    }

    private class FakeAction
    extends Action {
        public FakeAction(String name) {
            super(name);
        }

        public void run() {
        }
    }

    private class ActionItem {
        public int accelerator;
        public IAction action;

        public ActionItem(int accel, IAction act) {
            this.accelerator = accel;
            this.action = act;
        }
    }
}

