/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.about.AboutItem;

public abstract class ProductInfoDialog
extends Dialog {
    private static final String ATT_HTTP = "http://";
    private AboutItem item;
    private boolean webBrowserOpened;
    private String webBrowser = null;
    private Cursor handCursor;
    private Cursor busyCursor;
    private boolean mouseDown = false;
    private boolean dragEvent = false;

    public ProductInfoDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void addListeners(StyledText styledText) {
        styledText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                ProductInfoDialog.this.mouseDown = true;
            }

            public void mouseUp(MouseEvent e) {
                ProductInfoDialog.this.mouseDown = false;
                StyledText text = (StyledText)e.widget;
                int offset = text.getCaretOffset();
                if (ProductInfoDialog.this.dragEvent) {
                    ProductInfoDialog.this.dragEvent = false;
                    if (ProductInfoDialog.this.item != null && ProductInfoDialog.this.item.isLinkAt(offset)) {
                        text.setCursor(ProductInfoDialog.this.handCursor);
                    }
                } else if (ProductInfoDialog.this.item != null && ProductInfoDialog.this.item.isLinkAt(offset)) {
                    text.setCursor(ProductInfoDialog.this.busyCursor);
                    ProductInfoDialog.this.openLink(ProductInfoDialog.this.item.getLinkAt(offset));
                    StyleRange selectionRange = ProductInfoDialog.this.getCurrentRange(text);
                    text.setSelectionRange(selectionRange.start, selectionRange.length);
                    text.setCursor(null);
                }
            }
        });
        styledText.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (ProductInfoDialog.this.mouseDown) {
                    if (!ProductInfoDialog.this.dragEvent) {
                        StyledText text = (StyledText)e.widget;
                        text.setCursor(null);
                    }
                    ProductInfoDialog.this.dragEvent = true;
                    return;
                }
                StyledText text = (StyledText)e.widget;
                int offset = -1;
                try {
                    offset = text.getOffsetAtLocation(new Point(e.x, e.y));
                }
                catch (IllegalArgumentException ex) {
                    // empty catch block
                }
                if (offset == -1) {
                    text.setCursor(null);
                } else if (ProductInfoDialog.this.item != null && ProductInfoDialog.this.item.isLinkAt(offset)) {
                    text.setCursor(ProductInfoDialog.this.handCursor);
                } else {
                    text.setCursor(null);
                }
            }
        });
        styledText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                StyledText text = (StyledText)e.widget;
                switch (e.detail) {
                    case 2: {
                        e.doit = true;
                        break;
                    }
                    case 16: {
                        StyleRange nextRange;
                        Point nextSelection = text.getSelection();
                        int charCount = text.getCharCount();
                        if (nextSelection.x == charCount && nextSelection.y == charCount) {
                            text.setSelection(0);
                        }
                        if ((nextRange = ProductInfoDialog.this.findNextRange(text)) == null) {
                            text.setSelection(0);
                            e.doit = true;
                            break;
                        }
                        text.setSelectionRange(nextRange.start, nextRange.length);
                        e.doit = true;
                        e.detail = 0;
                        break;
                    }
                    case 8: {
                        StyleRange previousRange;
                        Point previousSelection = text.getSelection();
                        if (previousSelection.x == 0 && previousSelection.y == 0) {
                            text.setSelection(text.getCharCount());
                        }
                        if ((previousRange = ProductInfoDialog.this.findPreviousRange(text)) == null) {
                            text.setSelection(text.getCharCount());
                            e.doit = true;
                            break;
                        }
                        text.setSelectionRange(previousRange.start, previousRange.length);
                        e.doit = true;
                        e.detail = 0;
                        break;
                    }
                }
            }
        });
        styledText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                StyledText text = (StyledText)event.widget;
                if (event.character == ' ' || event.character == '\r') {
                    if (ProductInfoDialog.this.item != null) {
                        int offset = text.getSelection().x + 1;
                        if (ProductInfoDialog.this.item.isLinkAt(offset)) {
                            text.setCursor(ProductInfoDialog.this.busyCursor);
                            ProductInfoDialog.this.openLink(ProductInfoDialog.this.item.getLinkAt(offset));
                            StyleRange selectionRange = ProductInfoDialog.this.getCurrentRange(text);
                            text.setSelectionRange(selectionRange.start, selectionRange.length);
                            text.setCursor(null);
                        }
                    }
                    return;
                }
            }
        });
    }

    protected Cursor getBusyCursor() {
        return this.busyCursor;
    }

    protected void setBusyCursor(Cursor busyCursor) {
        this.busyCursor = busyCursor;
    }

    protected Cursor getHandCursor() {
        return this.handCursor;
    }

    protected void setHandCursor(Cursor handCursor) {
        this.handCursor = handCursor;
    }

    protected AboutItem getItem() {
        return this.item;
    }

    protected void setItem(AboutItem item) {
        this.item = item;
    }

    protected StyleRange getCurrentRange(StyledText text) {
        StyleRange[] ranges = text.getStyleRanges();
        int currentSelectionEnd = text.getSelection().y;
        int currentSelectionStart = text.getSelection().x;
        for (int i = 0; i < ranges.length; ++i) {
            if (currentSelectionStart < ranges[i].start || currentSelectionEnd > ranges[i].start + ranges[i].length) continue;
            return ranges[i];
        }
        return null;
    }

    protected StyleRange findNextRange(StyledText text) {
        StyleRange[] ranges = text.getStyleRanges();
        int currentSelectionEnd = text.getSelection().y;
        for (int i = 0; i < ranges.length; ++i) {
            if (ranges[i].start < currentSelectionEnd) continue;
            return ranges[i];
        }
        return null;
    }

    protected StyleRange findPreviousRange(StyledText text) {
        StyleRange[] ranges = text.getStyleRanges();
        int currentSelectionStart = text.getSelection().x;
        for (int i = ranges.length - 1; i > -1; --i) {
            if (ranges[i].start + ranges[i].length - 1 >= currentSelectionStart) continue;
            return ranges[i];
        }
        return null;
    }

    private Process openWebBrowser(String href) throws IOException {
        Process p = null;
        if (this.webBrowser == null) {
            try {
                this.webBrowser = "netscape";
                p = Runtime.getRuntime().exec(this.webBrowser + "  " + href);
            }
            catch (IOException e) {
                p = null;
                this.webBrowser = "mozilla";
            }
        }
        if (p == null) {
            try {
                p = Runtime.getRuntime().exec(this.webBrowser + " " + href);
            }
            catch (IOException e) {
                p = null;
                throw e;
            }
        }
        return p;
    }

    private void openWebBrowserError(Display display) {
        display.asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)ProductInfoDialog.this.getShell(), (String)WorkbenchMessages.getString("ProductInfoDialog.errorTitle"), (String)WorkbenchMessages.getString("ProductInfoDialog.unableToOpenWebBrowser"));
            }
        });
    }

    protected void openLink(String href) {
        if (href.startsWith("file:")) {
            href = href.substring(5);
            while (href.startsWith("/")) {
                href = href.substring(1);
            }
            href = "file:///" + href;
        }
        final String localHref = href;
        final Display d = Display.getCurrent();
        String platform = SWT.getPlatform();
        if ("win32".equals(platform)) {
            Program.launch((String)localHref);
        } else if ("carbon".equals(platform)) {
            try {
                Runtime.getRuntime().exec("/usr/bin/open " + localHref);
            }
            catch (IOException e) {
                this.openWebBrowserError(d);
            }
        } else {
            Thread launcher = new Thread("About Link Launcher"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block9: {
                        try {
                            if (ProductInfoDialog.this.webBrowserOpened) {
                                Runtime.getRuntime().exec(ProductInfoDialog.this.webBrowser + " -remote openURL(" + localHref + ")");
                                break block9;
                            }
                            Process p = ProductInfoDialog.this.openWebBrowser(localHref);
                            ProductInfoDialog.this.webBrowserOpened = true;
                            try {
                                if (p != null) {
                                    p.waitFor();
                                }
                            }
                            catch (InterruptedException e) {
                                ProductInfoDialog.this.openWebBrowserError(d);
                            }
                            finally {
                                ProductInfoDialog.this.webBrowserOpened = false;
                            }
                        }
                        catch (IOException e) {
                            ProductInfoDialog.this.openWebBrowserError(d);
                        }
                    }
                }
            };
            launcher.start();
        }
    }

    protected boolean openBrowser(URL url) {
        if (url != null) {
            try {
                url = Platform.asLocalURL((URL)url);
            }
            catch (IOException e) {
                return false;
            }
        }
        if (url == null) {
            return false;
        }
        this.openLink(url.toString());
        return true;
    }

    protected void setBoldRanges(StyledText styledText, int[][] boldRanges) {
        for (int i = 0; i < boldRanges.length; ++i) {
            StyleRange r = new StyleRange(boldRanges[i][0], boldRanges[i][1], null, null, 1);
            styledText.setStyleRange(r);
        }
    }

    protected void setLinkRanges(StyledText styledText, int[][] linkRanges) {
        Color fg = JFaceColors.getHyperlinkText((Display)styledText.getShell().getDisplay());
        for (int i = 0; i < linkRanges.length; ++i) {
            StyleRange r = new StyleRange(linkRanges[i][0], linkRanges[i][1], fg, null);
            styledText.setStyleRange(r);
        }
    }

    protected AboutItem scan(String s) {
        int max = s.length();
        int i = s.indexOf(ATT_HTTP);
        ArrayList<int[]> linkRanges = new ArrayList<int[]>();
        ArrayList<String> links = new ArrayList<String>();
        while (i != -1) {
            int start = i;
            boolean found = false;
            i += ATT_HTTP.length();
            while (!found && i < max) {
                found = Character.isWhitespace(s.charAt(i++));
            }
            if (i != max) {
                --i;
            }
            linkRanges.add(new int[]{start, i - start});
            links.add(s.substring(start, i));
            i = s.indexOf(ATT_HTTP, i);
        }
        return new AboutItem(s, (int[][])linkRanges.toArray((T[])new int[linkRanges.size()][2]), links.toArray(new String[links.size()]));
    }
}

