/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class PropertyFileFilter
extends ViewerFilter {
    protected List fFilter;
    private Set fPropertyFiles;

    public PropertyFileFilter(List objects) {
        this.fFilter = objects;
        this.init();
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.fPropertyFiles.contains(element) && !this.fFilter.contains(element);
    }

    private void init() {
        BusyIndicator.showWhile((Display)AntUIPlugin.getStandardDisplay(), (Runnable)new Runnable(){

            public void run() {
                PropertyFileFilter.this.fPropertyFiles = new HashSet();
                PropertyFileFilter.this.traverse((IContainer)ResourcesPlugin.getWorkspace().getRoot(), PropertyFileFilter.this.fPropertyFiles);
            }
        });
    }

    private boolean traverse(IContainer container, Set set) {
        boolean added = false;
        try {
            IResource[] resources = container.members();
            for (int i = 0; i < resources.length; ++i) {
                IResource resource = resources[i];
                if (resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    String ext = file.getFileExtension();
                    if (ext == null || !ext.equalsIgnoreCase("properties")) continue;
                    set.add(file);
                    added = true;
                    continue;
                }
                if (!(resource instanceof IContainer) || !this.traverse((IContainer)resource, set)) continue;
                set.add(resource);
                added = true;
            }
        }
        catch (CoreException e) {
            // empty catch block
        }
        return added;
    }
}

