/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ant.internal.ui.model.AntUIImages;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class AntBuildTab
extends AbstractLaunchConfigurationTab {
    public static final String ATTR_BUILD_SCOPE = AntUIPlugin.getUniqueIdentifier() + ".ATTR_BUILD_SCOPE";
    public static final String ATTR_INCLUDE_REFERENCED_PROJECTS = AntUIPlugin.getUniqueIdentifier() + ".ATTR_INCLUDE_REFERENCED_PROJECTS";
    private Button fBuildButton;
    private Group fGroup;
    private Button fProjectButton;
    private Button fSpecificProjectsButton;
    private Button fWorkspaceButton;
    private Button fSelectButton;
    private Button fReferencedProjects;
    private List fProjects = new ArrayList();

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.ant.ui.ant_build_tab_context");
        GridLayout layout = new GridLayout();
        GridData gd = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gd);
        mainComposite.setFont(parent.getFont());
        this.fBuildButton = this.createCheckButton(mainComposite, AntLaunchConfigurationMessages.getString("AntBuildTab.1"));
        this.fBuildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AntBuildTab.this.updateEnabledState();
                AntBuildTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fGroup = new Group(mainComposite, 0);
        this.fGroup.setFont(mainComposite.getFont());
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        this.fGroup.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fGroup.setLayoutData((Object)gd);
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.getSource()).getSelection()) {
                    AntBuildTab.this.updateEnabledState();
                    AntBuildTab.this.updateLaunchConfigurationDialog();
                }
            }
        };
        this.fWorkspaceButton = this.createRadioButton((Composite)this.fGroup, AntLaunchConfigurationMessages.getString("AntBuildTab.2"));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fWorkspaceButton.setLayoutData((Object)gd);
        this.fWorkspaceButton.addSelectionListener((SelectionListener)adapter);
        this.fProjectButton = this.createRadioButton((Composite)this.fGroup, AntLaunchConfigurationMessages.getString("AntBuildTab.3"));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fProjectButton.setLayoutData((Object)gd);
        this.fProjectButton.addSelectionListener((SelectionListener)adapter);
        this.fSpecificProjectsButton = this.createRadioButton((Composite)this.fGroup, AntLaunchConfigurationMessages.getString("AntBuildTab.4"));
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.fSpecificProjectsButton.setLayoutData((Object)gd);
        this.fSpecificProjectsButton.addSelectionListener((SelectionListener)adapter);
        this.fSelectButton = this.createPushButton((Composite)this.fGroup, AntLaunchConfigurationMessages.getString("AntBuildTab.5"), null);
        gd = (GridData)this.fSelectButton.getLayoutData();
        gd.horizontalAlignment = 128;
        this.fSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AntBuildTab.this.selectResources();
            }
        });
        this.createVerticalSpacer(mainComposite, 1);
        this.fReferencedProjects = this.createCheckButton(mainComposite, AntLaunchConfigurationMessages.getString("AntBuildTab.6"));
    }

    private void selectResources() {
        ListSelectionDialog dialog = new ListSelectionDialog(this.getShell(), (Object)ResourcesPlugin.getWorkspace(), (IStructuredContentProvider)new ProjectsContentProvider(), (ILabelProvider)new WorkbenchLabelProvider(), AntLaunchConfigurationMessages.getString("AntBuildTab.7"));
        dialog.setInitialElementSelections(this.fProjects);
        if (dialog.open() == 1) {
            return;
        }
        Object[] res = dialog.getResult();
        this.fProjects = new ArrayList(res.length);
        for (int i = 0; i < res.length; ++i) {
            this.fProjects.add(res[i]);
        }
        this.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.updateScope(configuration);
        this.updateReferencedProjects(configuration);
        this.updateEnabledState();
    }

    private void updateReferencedProjects(ILaunchConfiguration configuration) {
        boolean ref = false;
        try {
            ref = configuration.getAttribute(ATTR_INCLUDE_REFERENCED_PROJECTS, true);
        }
        catch (CoreException e) {
            AntUIPlugin.log(AntUIPlugin.newErrorStatus("Exception reading launch configuration", e));
        }
        this.fReferencedProjects.setSelection(ref);
    }

    private void updateScope(ILaunchConfiguration configuration) {
        String scope = null;
        try {
            scope = configuration.getAttribute(ATTR_BUILD_SCOPE, (String)null);
        }
        catch (CoreException ce) {
            AntUIPlugin.log(AntUIPlugin.newErrorStatus("Exception reading launch configuration", ce));
        }
        this.fBuildButton.setSelection(scope != null);
        this.fWorkspaceButton.setSelection(false);
        this.fProjectButton.setSelection(false);
        this.fSpecificProjectsButton.setSelection(false);
        this.fProjects.clear();
        if (scope == null) {
            this.fBuildButton.setSelection(true);
            this.fWorkspaceButton.setSelection(true);
        } else if (scope.equals("${none}")) {
            this.fBuildButton.setSelection(false);
        } else if (scope.equals("${project}")) {
            this.fProjectButton.setSelection(true);
        } else if (scope.startsWith("${projects:")) {
            this.fSpecificProjectsButton.setSelection(true);
            IProject[] projects = AntBuildTab.getBuildProjects(scope);
            this.fProjects = new ArrayList(projects.length);
            for (int i = 0; i < projects.length; ++i) {
                this.fProjects.add(projects[i]);
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String scope = this.generateScopeMemento();
        configuration.setAttribute(ATTR_BUILD_SCOPE, scope);
        if (this.fReferencedProjects.getSelection()) {
            configuration.setAttribute(ATTR_INCLUDE_REFERENCED_PROJECTS, (String)null);
        } else {
            configuration.setAttribute(ATTR_INCLUDE_REFERENCED_PROJECTS, false);
        }
    }

    private String generateScopeMemento() {
        if (this.fBuildButton.getSelection()) {
            if (this.fWorkspaceButton.getSelection()) {
                return null;
            }
            if (this.fProjectButton.getSelection()) {
                return "${project}";
            }
            if (this.fSpecificProjectsButton.getSelection()) {
                return AntBuildTab.getBuildScopeAttribute(this.fProjects);
            }
            return null;
        }
        return "${none}";
    }

    public String getName() {
        return AntLaunchConfigurationMessages.getString("AntBuildTab.8");
    }

    private void updateEnabledState() {
        boolean enabled = this.fBuildButton.getSelection();
        this.fGroup.setEnabled(enabled);
        this.fWorkspaceButton.setEnabled(enabled);
        this.fProjectButton.setEnabled(enabled);
        this.fSpecificProjectsButton.setEnabled(enabled);
        this.fSelectButton.setEnabled(enabled && this.fSpecificProjectsButton.getSelection());
        if (!enabled) {
            super.setErrorMessage(null);
        }
        if (enabled && !this.fWorkspaceButton.getSelection() && !this.fProjectButton.getSelection() && !this.fSpecificProjectsButton.getSelection()) {
            this.fWorkspaceButton.setSelection(true);
        }
        this.fReferencedProjects.setEnabled(this.fBuildButton.getSelection() && (this.fProjectButton.getSelection() || this.fSpecificProjectsButton.getSelection()));
    }

    public Image getImage() {
        return AntUIImages.getImage("org.eclipse.ant.ui.IMG_BUILD_TAB");
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.fBuildButton.getSelection() && this.fSpecificProjectsButton.getSelection() && this.fProjects.isEmpty()) {
            this.setErrorMessage(AntLaunchConfigurationMessages.getString("AntBuildTab.9"));
            return false;
        }
        return true;
    }

    public static IProject[] getBuildProjects(String scope) {
        IResource resource;
        if (scope.startsWith("${projects:")) {
            String pathString = scope.substring(11, scope.length() - 1);
            if (pathString.length() > 1) {
                String[] names = pathString.split(",");
                IProject[] projects = new IProject[names.length];
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                for (int i = 0; i < names.length; ++i) {
                    projects[i] = root.getProject(names[i]);
                }
                return projects;
            }
        } else if (scope.equals("${project}") && (resource = DebugUITools.getSelectedResource()) != null) {
            return new IProject[]{resource.getProject()};
        }
        return new IProject[0];
    }

    public static String getBuildScope(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(ATTR_BUILD_SCOPE, (String)null);
    }

    public static boolean isIncludeReferencedProjects(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(ATTR_INCLUDE_REFERENCED_PROJECTS, true);
    }

    public static String getBuildScopeAttribute(List projects) {
        StringBuffer buf = new StringBuffer();
        buf.append("${projects:");
        Iterator iterator = projects.iterator();
        while (iterator.hasNext()) {
            IProject project = (IProject)iterator.next();
            buf.append(project.getName());
            if (!iterator.hasNext()) continue;
            buf.append(",");
        }
        buf.append("}");
        return buf.toString();
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    class ProjectsContentProvider
    implements IStructuredContentProvider {
        ProjectsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((IWorkspace)inputElement).getRoot().getProjects();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

