/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.model;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tools.ant.Target;
import org.eclipse.ant.internal.ui.editor.model.AntElementNode;
import org.eclipse.ant.internal.ui.editor.model.AntModelMessages;
import org.eclipse.ant.internal.ui.model.AntUIImages;
import org.eclipse.jface.resource.ImageDescriptor;

public class AntTargetNode
extends AntElementNode {
    private Target fTarget = null;

    public AntTargetNode(Target target) {
        super("target");
        this.fTarget = target;
    }

    public String getLabel() {
        String targetName = this.fTarget.getName();
        if (targetName == null) {
            targetName = "target";
            this.setProblemSeverity(1);
        }
        StringBuffer displayName = new StringBuffer(targetName);
        if (this.isDefaultTarget()) {
            displayName.append(AntModelMessages.getString("AntTargetNode.2"));
        }
        if (this.isExternal()) {
            this.appendEntityName(displayName);
        }
        return displayName.toString();
    }

    public Target getTarget() {
        return this.fTarget;
    }

    public boolean isDefaultTarget() {
        String targetName = this.fTarget.getName();
        if (targetName == null) {
            return false;
        }
        return targetName.equals(this.fTarget.getProject().getDefaultTarget());
    }

    protected ImageDescriptor getBaseImageDescriptor() {
        ImageDescriptor base = null;
        base = this.isDefaultTarget() ? AntUIImages.getImageDescriptor("org.eclipse.ant.ui.antDefaultTarget") : (this.getTarget().getDescription() == null ? AntUIImages.getImageDescriptor("org.eclipse.ant.ui.antPrivateTarget") : AntUIImages.getImageDescriptor("org.eclipse.ant.ui.antTarget"));
        return base;
    }

    public void setTarget(Target target) {
        this.fTarget = target;
    }

    public void reset() {
        super.reset();
        Hashtable currentTargets = this.fTarget.getProject().getTargets();
        if (currentTargets.get(this.fTarget.getName()) != null) {
            currentTargets.remove(this.fTarget.getName());
        }
    }

    public String checkDependencies() {
        Enumeration dependencies = this.fTarget.getDependencies();
        while (dependencies.hasMoreElements()) {
            String dependency = (String)dependencies.nextElement();
            if (this.fTarget.getProject().getTargets().get(dependency) != null) continue;
            return dependency;
        }
        return null;
    }
}

