/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor;

import org.eclipse.ant.internal.ui.editor.AbstractAntSourceViewerConfiguration;
import org.eclipse.ant.internal.ui.editor.AntAutoIndentStrategy;
import org.eclipse.ant.internal.ui.editor.AntEditor;
import org.eclipse.ant.internal.ui.editor.AntEditorCompletionProcessor;
import org.eclipse.ant.internal.ui.editor.derived.HTMLTextPresenter;
import org.eclipse.ant.internal.ui.editor.formatter.XmlDocumentFormattingStrategy;
import org.eclipse.ant.internal.ui.editor.formatter.XmlElementFormattingStrategy;
import org.eclipse.ant.internal.ui.editor.text.NotifyingReconciler;
import org.eclipse.ant.internal.ui.editor.text.XMLAnnotationHover;
import org.eclipse.ant.internal.ui.editor.text.XMLReconcilingStrategy;
import org.eclipse.ant.internal.ui.editor.text.XMLTextHover;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.ant.internal.ui.model.ColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoIndentStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;

public class AntEditorSourceViewerConfiguration
extends AbstractAntSourceViewerConfiguration {
    private AntEditor fEditor;
    private XMLTextHover fTextHover;
    private ContentAssistant contentAssistant;
    private AntAutoIndentStrategy autoIndentStrategy;

    public AntEditorSourceViewerConfiguration(AntEditor editor) {
        this.fEditor = editor;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        this.contentAssistant = new ContentAssistant();
        AntEditorCompletionProcessor processor = new AntEditorCompletionProcessor(this.fEditor.getAntModel());
        this.contentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        this.contentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__xml_tag");
        this.contentAssistant.setDocumentPartitioning("___ant_partitioning");
        IPreferenceStore store = AntUIPlugin.getDefault().getPreferenceStore();
        String triggers = store.getString("content_assist_autoactivation_triggers_java");
        if (triggers != null) {
            processor.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
        }
        this.contentAssistant.enableAutoInsert(store.getBoolean("content_assist_autoinsert"));
        this.contentAssistant.enableAutoActivation(store.getBoolean("content_assist_autoactivation"));
        this.contentAssistant.setAutoActivationDelay(store.getInt("content_assist_autoactivation_delay"));
        this.contentAssistant.setProposalPopupOrientation(10);
        this.contentAssistant.setContextInformationPopupOrientation(20);
        this.contentAssistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        ColorManager manager = ColorManager.getDefault();
        Color background = this.getColor(store, "org.eclipse.ant.ui.codeAssistProposalsBackgroundColor", manager);
        this.contentAssistant.setContextInformationPopupBackground(background);
        this.contentAssistant.setContextSelectorBackground(background);
        this.contentAssistant.setProposalSelectorBackground(background);
        Color foreground = this.getColor(store, "org.eclipse.ant.ui.codeAssistProposalsForegroundColor", manager);
        this.contentAssistant.setContextInformationPopupForeground(foreground);
        this.contentAssistant.setContextSelectorForeground(foreground);
        this.contentAssistant.setProposalSelectorForeground(foreground);
        IInformationControlCreator creator = this.getInformationControlCreator(true);
        this.contentAssistant.setInformationControlCreator(creator);
        return this.contentAssistant;
    }

    protected IInformationControlCreator getInformationControlCreator(final boolean cutDown) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int style = cutDown ? 0 : 768;
                return new DefaultInformationControl(parent, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(cutDown));
            }
        };
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        NotifyingReconciler reconciler = new NotifyingReconciler(new XMLReconcilingStrategy((ITextEditor)this.fEditor), true);
        reconciler.setDelay(500);
        reconciler.addReconcilingParticipant(this.fEditor);
        return reconciler;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new XMLAnnotationHover();
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return this.getInformationControlCreator(true);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.fTextHover == null) {
            this.fTextHover = new XMLTextHover(this.fEditor);
        }
        return this.fTextHover;
    }

    private Color getColor(IPreferenceStore store, String key, ColorManager manager) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        return manager.getColor(rgb);
    }

    protected void changeConfiguration(PropertyChangeEvent event) {
        IPreferenceStore store = AntUIPlugin.getDefault().getPreferenceStore();
        String p = event.getProperty();
        ColorManager manager = ColorManager.getDefault();
        if ("content_assist_autoactivation".equals(p)) {
            boolean enabled = store.getBoolean("content_assist_autoactivation");
            this.contentAssistant.enableAutoActivation(enabled);
        } else if ("content_assist_autoactivation_delay".equals(p) && this.contentAssistant != null) {
            int delay = store.getInt("content_assist_autoactivation_delay");
            this.contentAssistant.setAutoActivationDelay(delay);
        } else if ("org.eclipse.ant.ui.codeAssistProposalsForegroundColor".equals(p) && this.contentAssistant != null) {
            Color c = this.getColor(store, "org.eclipse.ant.ui.codeAssistProposalsForegroundColor", manager);
            this.contentAssistant.setProposalSelectorForeground(c);
        } else if ("org.eclipse.ant.ui.codeAssistProposalsBackgroundColor".equals(p) && this.contentAssistant != null) {
            Color c = this.getColor(store, "org.eclipse.ant.ui.codeAssistProposalsBackgroundColor", manager);
            this.contentAssistant.setProposalSelectorBackground(c);
        } else if ("content_assist_autoinsert".equals(p) && this.contentAssistant != null) {
            boolean enabled = store.getBoolean("content_assist_autoinsert");
            this.contentAssistant.enableAutoInsert(enabled);
        } else if ("content_assist_autoactivation_triggers_java".equals(p)) {
            this.changeContentAssistProcessor(store);
        }
    }

    private void changeContentAssistProcessor(IPreferenceStore store) {
        AntEditorCompletionProcessor cp;
        String triggers = store.getString("content_assist_autoactivation_triggers_java");
        if (triggers != null && (cp = (AntEditorCompletionProcessor)this.contentAssistant.getContentAssistProcessor("__dftl_partition_content_type")) != null) {
            cp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
        }
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        MultiPassContentFormatter formatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "__dftl_partition_content_type");
        formatter.setMasterStrategy((IFormattingStrategy)new XmlDocumentFormattingStrategy());
        formatter.setSlaveStrategy((IFormattingStrategy)new XmlElementFormattingStrategy(), "__xml_tag");
        return formatter;
    }

    public IAutoIndentStrategy getAutoIndentStrategy(ISourceViewer sourceViewer, String contentType) {
        if ("__xml_comment".equals(contentType)) {
            return super.getAutoIndentStrategy(sourceViewer, contentType);
        }
        if (this.autoIndentStrategy == null) {
            this.autoIndentStrategy = new AntAutoIndentStrategy(this.fEditor.getAntModel());
        }
        return this.autoIndentStrategy;
    }
}

