/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.builders;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.pde.internal.builders.PluginErrorReporter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SchemaHandler
extends PluginErrorReporter {
    private org.w3c.dom.Document fDocument;
    private IDocument fTextDocument;
    private FindReplaceDocumentAdapter fFindReplaceAdapter;
    private Locator fLocator;
    private Hashtable fLineTable;
    private Element fRootElement;
    private Stack fElementStack = new Stack();

    public SchemaHandler(IFile file) {
        super(file);
        this.createTextDocument(file);
        this.fLineTable = new Hashtable();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Element element = this.fDocument.createElement(qName);
        for (int i = 0; i < attributes.getLength(); ++i) {
            element.setAttribute(attributes.getQName(i), attributes.getValue(i));
        }
        Integer lineNumber = new Integer(this.fLocator.getLineNumber());
        try {
            lineNumber = this.getCorrectStartLine(qName);
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        Integer[] range = new Integer[]{lineNumber, new Integer(-1)};
        this.fLineTable.put(element, range);
        if (this.fRootElement == null) {
            this.fRootElement = element;
        } else {
            ((Element)this.fElementStack.peek()).appendChild(element);
        }
        this.fElementStack.push(element);
    }

    public void endElement(String arg0, String arg1, String arg2) throws SAXException {
        Integer[] range = (Integer[])this.fLineTable.get(this.fElementStack.pop());
        range[1] = new Integer(this.fLocator.getLineNumber());
    }

    public void setDocumentLocator(Locator locator) {
        this.fLocator = locator;
    }

    public void startDocument() throws SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            this.fDocument = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    public void endDocument() throws SAXException {
        this.fDocument.appendChild(this.fRootElement);
    }

    public void characters(char[] characters, int offset, int length) throws SAXException {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            buff.append(characters[offset + i]);
        }
        Text text = this.fDocument.createTextNode(buff.toString());
        if (this.fRootElement == null) {
            this.fDocument.appendChild(text);
        } else {
            ((Element)this.fElementStack.peek()).appendChild(text);
        }
    }

    public Node getDocumentElement() {
        Element docElement;
        if (this.fDocument != null && (docElement = this.fDocument.getDocumentElement()) != null) {
            docElement.normalize();
            return docElement;
        }
        return null;
    }

    public Hashtable getLineTable() {
        return this.fLineTable;
    }

    private void createTextDocument(IFile file) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file.getLocation().toOSString()));
            StringBuffer buffer = new StringBuffer();
            while (reader.ready()) {
                String line = reader.readLine();
                if (line == null) continue;
                buffer.append(line);
                buffer.append(System.getProperty("line.separator"));
            }
            this.fTextDocument = new Document(buffer.toString());
            this.fFindReplaceAdapter = new FindReplaceDocumentAdapter(this.fTextDocument);
            reader.close();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Integer getCorrectStartLine(String elementName) throws BadLocationException {
        int lineNumber = this.fLocator.getLineNumber();
        int colNumber = this.fLocator.getColumnNumber();
        if (colNumber < 0) {
            colNumber = this.getLastCharColumn(lineNumber);
        }
        int offset = this.fTextDocument.getLineOffset(lineNumber - 1) + colNumber - 1;
        IRegion region = this.fFindReplaceAdapter.find(offset, "<" + elementName, false, false, false, false);
        return new Integer(this.fTextDocument.getLineOfOffset(region.getOffset()) + 1);
    }

    private int getLastCharColumn(int line) throws BadLocationException {
        String lineDelimiter = this.fTextDocument.getLineDelimiter(line - 1);
        int lineDelimiterLength = lineDelimiter != null ? lineDelimiter.length() : 0;
        return this.fTextDocument.getLineLength(line - 1) - lineDelimiterLength;
    }
}

