/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ProjectPreferences
extends EclipsePreferences {
    protected boolean isLoading = false;
    private int segmentCount;
    private String qualifier;
    private IProject project;
    private IEclipsePreferences loadLevel;
    private IFile file;
    protected static Set loadedNodes = new HashSet();
    private boolean isWriting;

    public ProjectPreferences() {
        super(null, null);
    }

    private ProjectPreferences(IEclipsePreferences parent, String name) {
        super(parent, name);
        String path = this.absolutePath();
        this.segmentCount = ProjectPreferences.getSegmentCount((String)path);
        if (this.segmentCount < 2) {
            return;
        }
        String projectName = ProjectPreferences.getSegment((String)path, (int)1);
        if (projectName != null) {
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        if (this.segmentCount > 2) {
            this.qualifier = ProjectPreferences.getSegment((String)path, (int)2);
        }
    }

    protected IPath getLocation() {
        if (this.project == null || this.qualifier == null) {
            return null;
        }
        IPath path = this.project.getLocation();
        return this.computeLocation(path, this.qualifier);
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return loadedNodes.contains(node.absolutePath());
    }

    protected void loaded() {
        loadedNodes.add(this.absolutePath());
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.project == null || this.qualifier == null) {
                return null;
            }
            ProjectPreferences node = this;
            for (int i = 3; i < this.segmentCount; ++i) {
                node = (EclipsePreferences)node.parent();
            }
            this.loadLevel = node;
        }
        return this.loadLevel;
    }

    protected EclipsePreferences internalCreate(IEclipsePreferences nodeParent, String nodeName, Plugin context) {
        return new ProjectPreferences(nodeParent, nodeName);
    }

    private IFile getFile() {
        if (this.file == null) {
            if (this.project == null || this.qualifier == null) {
                return null;
            }
            this.file = ProjectPreferences.getFile(this.project, this.qualifier);
        }
        return this.file;
    }

    static IFile getFile(IProject project, String qualifier) {
        return project.getFile(new Path(".settings").append(qualifier).addFileExtension("prefs"));
    }

    static IFile getFile(IFolder folder, String qualifier) {
        Assert.isLegal(folder.getName().equals(".settings"));
        return folder.getFile(new Path(qualifier).addFileExtension("prefs"));
    }

    protected void save() throws BackingStoreException {
        IFile fileInWorkspace = this.getFile();
        if (fileInWorkspace == null) {
            if (Policy.DEBUG_PREFERENCES) {
                Policy.debug("Not saving preferences since there is no file for node: " + this.absolutePath());
            }
            return;
        }
        Properties table = this.convertToProperties(new Properties(), "");
        try {
            if (table.isEmpty()) {
                if (fileInWorkspace.exists()) {
                    IStatus status;
                    if (Policy.DEBUG_PREFERENCES) {
                        Policy.debug("Deleting preference file: " + fileInWorkspace.getFullPath());
                    }
                    if (fileInWorkspace.isReadOnly() && !(status = fileInWorkspace.getWorkspace().validateEdit(new IFile[]{fileInWorkspace}, null)).isOK()) {
                        throw new CoreException(status);
                    }
                    try {
                        fileInWorkspace.delete(true, null);
                    }
                    catch (CoreException e) {
                        String message = Policy.bind("preferences.deleteException", fileInWorkspace.getFullPath().toString());
                        this.log((IStatus)new Status(2, "org.eclipse.core.resources", 2, message, null));
                    }
                }
                return;
            }
            table.put("eclipse.preferences.version", "1");
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                table.store(output, null);
            }
            catch (IOException e) {
                String message = Policy.bind("preferences.saveProblems", this.absolutePath());
                this.log((IStatus)new Status(4, "org.eclipse.core.runtime", 4, message, (Throwable)e));
                throw new BackingStoreException(message);
            }
            finally {
                try {
                    output.close();
                }
                catch (IOException e) {}
            }
            BufferedInputStream input = new BufferedInputStream(new ByteArrayInputStream(output.toByteArray()));
            if (fileInWorkspace.exists()) {
                IStatus status;
                if (Policy.DEBUG_PREFERENCES) {
                    Policy.debug("Setting preference file contents for: " + fileInWorkspace.getFullPath());
                }
                if (fileInWorkspace.isReadOnly() && !(status = fileInWorkspace.getWorkspace().validateEdit(new IFile[]{fileInWorkspace}, null)).isOK()) {
                    throw new CoreException(status);
                }
                fileInWorkspace.setContents(input, 2, null);
            } else {
                IFolder folder = (IFolder)fileInWorkspace.getParent();
                if (!folder.exists()) {
                    if (Policy.DEBUG_PREFERENCES) {
                        Policy.debug("Creating parent preference directory: " + folder.getFullPath());
                    }
                    folder.create(0, true, null);
                }
                if (Policy.DEBUG_PREFERENCES) {
                    Policy.debug("Creating preference file: " + fileInWorkspace.getLocation());
                }
                fileInWorkspace.create((InputStream)input, 0, null);
            }
        }
        catch (CoreException e) {
            String message = Policy.bind("preferences.saveProblems", fileInWorkspace.getFullPath().toString());
            this.log((IStatus)new Status(4, "org.eclipse.core.resources", 4, message, (Throwable)e));
            throw new BackingStoreException(message);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void load() throws BackingStoreException {
        Properties fromDisk;
        block10: {
            IFile localFile = this.getFile();
            if (localFile == null || !localFile.exists()) {
                if (!Policy.DEBUG_PREFERENCES) return;
                Policy.debug("Unable to determine preference file or file does not exist for node: " + this.absolutePath());
                return;
            }
            if (Policy.DEBUG_PREFERENCES) {
                Policy.debug("Loading preferences from file: " + localFile.getFullPath());
            }
            fromDisk = new Properties();
            BufferedInputStream input = null;
            try {
                try {
                    input = new BufferedInputStream(localFile.getContents(true));
                    fromDisk.load(input);
                }
                catch (CoreException e) {
                    String message = Policy.bind("preferences.loadException", localFile.getFullPath().toString());
                    this.log((IStatus)new Status(4, "org.eclipse.core.resources", 4, message, (Throwable)e));
                    throw new BackingStoreException(message);
                }
                catch (IOException e) {
                    String message = Policy.bind("preferences.loadException", localFile.getFullPath().toString());
                    this.log((IStatus)new Status(4, "org.eclipse.core.resources", 4, message, (Throwable)e));
                    throw new BackingStoreException(message);
                }
                Object var7_4 = null;
                if (input == null) break block10;
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                if (input == null) throw throwable;
                try {
                    ((InputStream)input).close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            ((InputStream)input).close();
        }
        this.convertFromProperties(fromDisk);
    }

    public static void updatePreferences(IFile file) throws CoreException {
        IPath path = file.getFullPath();
        if (!"prefs".equals(path.getFileExtension())) {
            return;
        }
        String project = path.segment(0);
        String qualifier = path.removeFileExtension().lastSegment();
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        Preferences node = root.node("project").node(project).node(qualifier);
        String message = null;
        try {
            message = Policy.bind("preferences.syncException", node.absolutePath());
            if (!(node instanceof ProjectPreferences)) {
                return;
            }
            ProjectPreferences projectPrefs = (ProjectPreferences)node;
            if (projectPrefs.isWriting) {
                return;
            }
            projectPrefs.load();
            if ("org.eclipse.core.resources".equals(qualifier)) {
                ((Workspace)ResourcesPlugin.getWorkspace()).getCharsetManager().charsetPreferencesChanged(file.getProject());
            }
        }
        catch (BackingStoreException e) {
            Status status = new Status(4, "org.eclipse.core.resources", 4, message, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    static void removeNode(Preferences node) throws CoreException {
        String message = Policy.bind("preferences.removeNodeException", node.absolutePath());
        try {
            node.removeNode();
        }
        catch (BackingStoreException e) {
            Status status = new Status(4, "org.eclipse.core.resources", 4, message, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        String path = node.absolutePath();
        Iterator i = loadedNodes.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.startsWith(path)) continue;
            i.remove();
        }
    }

    static void deleted(IProject project) throws CoreException {
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        Preferences projectNode = root.node("project").node(project.getName());
        boolean hasResourcesSettings = ProjectPreferences.getFile(project, "org.eclipse.core.resources").exists();
        ProjectPreferences.removeNode(projectNode);
        if (hasResourcesSettings) {
            ((Workspace)ResourcesPlugin.getWorkspace()).getCharsetManager().charsetPreferencesChanged(project);
        }
    }

    static void deleted(IFile file) throws CoreException {
        IPath path = file.getFullPath();
        int count = path.segmentCount();
        if (count != 3) {
            return;
        }
        if (!".settings".equals(path.segment(1))) {
            return;
        }
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        String project = path.segment(0);
        String qualifier = path.removeFileExtension().lastSegment();
        Preferences projectNode = root.node("project").node(project);
        try {
            if (!projectNode.nodeExists(qualifier)) {
                return;
            }
        }
        catch (BackingStoreException e) {
            // empty catch block
        }
        ProjectPreferences.removeNode(projectNode.node(qualifier));
        if (qualifier.equals("org.eclipse.core.resources")) {
            ((Workspace)ResourcesPlugin.getWorkspace()).getCharsetManager().charsetPreferencesChanged(file.getProject());
        }
    }

    static void deleted(IResource resource) throws CoreException {
        switch (resource.getType()) {
            case 1: {
                ProjectPreferences.deleted((IFile)resource);
                return;
            }
            case 2: {
                ProjectPreferences.deleted((IFolder)resource);
                return;
            }
            case 4: {
                ProjectPreferences.deleted((IProject)resource);
                return;
            }
        }
    }

    static void deleted(IFolder folder) throws CoreException {
        IPath path = folder.getFullPath();
        int count = path.segmentCount();
        if (count != 2) {
            return;
        }
        if (!".settings".equals(path.segment(1))) {
            return;
        }
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        String project = path.segment(0);
        Preferences projectNode = root.node("project").node(project);
        boolean hasResourcesSettings = ProjectPreferences.getFile(folder, "org.eclipse.core.resources").exists();
        ProjectPreferences.removeNode(projectNode);
        if (hasResourcesSettings) {
            ((Workspace)ResourcesPlugin.getWorkspace()).getCharsetManager().charsetPreferencesChanged(folder.getProject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws BackingStoreException {
        this.isWriting = true;
        try {
            super.flush();
        }
        finally {
            this.isWriting = false;
        }
    }
}

