/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.properties;

import java.io.File;
import org.eclipse.core.internal.indexing.Index;
import org.eclipse.core.internal.indexing.IndexCursor;
import org.eclipse.core.internal.indexing.IndexedStore;
import org.eclipse.core.internal.indexing.IndexedStoreException;
import org.eclipse.core.internal.indexing.ObjectID;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;

public class IndexedStoreWrapper {
    private IndexedStore store;
    private IPath location;
    private static final String INDEX_NAME = "index";

    public IndexedStoreWrapper(IPath location) {
        this.location = location;
    }

    private void open() throws CoreException {
        try {
            String name = this.location.toOSString();
            this.store = IndexedStore.find(name);
            if (this.store == null) {
                this.store = new IndexedStore();
                this.store.open(name);
            }
        }
        catch (Exception e) {
            String message = Policy.bind("indexed.couldNotOpen", this.location.toOSString());
            ResourceStatus status = new ResourceStatus(272, this.location, message, e);
            throw new CoreException((IStatus)status);
        }
    }

    private void recreate() throws CoreException {
        this.close();
        File file = this.location.toFile();
        file.renameTo(this.location.addFileExtension("001").toFile());
        file.delete();
        if (!file.exists()) {
            try {
                this.open();
            }
            catch (CoreException e) {
                this.store = null;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.store == null) {
            return;
        }
        try {
            this.store.close();
        }
        catch (Exception e) {
            String message = Policy.bind("indexed.couldNotClose", this.location.toOSString());
            ResourceStatus status = new ResourceStatus(272, this.location, message, e);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
        }
        finally {
            this.store = null;
        }
    }

    public synchronized void commit() throws CoreException {
        if (this.store == null) {
            return;
        }
        try {
            this.store.commit();
        }
        catch (Exception e) {
            String message = Policy.bind("indexed.couldNotCommit", this.location.toOSString());
            ResourceStatus status = new ResourceStatus(272, this.location, message, e);
            throw new ResourceException(status);
        }
    }

    private void create() throws CoreException {
        block2: {
            try {
                this.open();
            }
            catch (CoreException e) {
                ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
                this.recreate();
                if (this.store != null) break block2;
                String message = Policy.bind("indexed.couldNotCreate", this.location.toOSString());
                ResourceStatus status = new ResourceStatus(272, this.location, message, null);
                throw new ResourceException(status);
            }
        }
    }

    private Index createIndex() throws CoreException {
        try {
            return this.getStore().createIndex(INDEX_NAME);
        }
        catch (Exception e) {
            String message = Policy.bind("indexed.couldNotCreateIndex", this.location.toOSString());
            ResourceStatus status = new ResourceStatus(272, this.location, message, e);
            throw new ResourceException(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Index getIndex() throws CoreException {
        Exception problem = null;
        try {
            try {
                Index index = this.getStore().getIndex(INDEX_NAME);
                Object var5_6 = null;
                if (problem == null) return index;
            }
            catch (IndexedStoreException e) {
                if (e.id == 11) {
                    Index index = this.createIndex();
                    Object var5_7 = null;
                    if (problem == null) return index;
                    String message = Policy.bind("indexed.couldNotGetIndex", this.location.toOSString());
                    ResourceStatus status = new ResourceStatus(271, this.location, message, problem);
                    throw new ResourceException(status);
                }
                problem = e;
                Index index = null;
                Object var5_8 = null;
                if (problem == null) return index;
                String message = Policy.bind("indexed.couldNotGetIndex", this.location.toOSString());
                ResourceStatus status = new ResourceStatus(271, this.location, message, problem);
                throw new ResourceException(status);
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                problem = e;
                Index index = null;
                Object var5_9 = null;
                if (problem == null) return index;
                String message = Policy.bind("indexed.couldNotGetIndex", this.location.toOSString());
                ResourceStatus status = new ResourceStatus(271, this.location, message, problem);
                throw new ResourceException(status);
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            if (problem != null) {
                String message = Policy.bind("indexed.couldNotGetIndex", this.location.toOSString());
                ResourceStatus status = new ResourceStatus(271, this.location, message, problem);
                throw new ResourceException(status);
            }
            throw throwable;
        }
        String message = Policy.bind("indexed.couldNotGetIndex", this.location.toOSString());
        ResourceStatus status = new ResourceStatus(271, this.location, message, problem);
        throw new ResourceException(status);
    }

    public synchronized void rollback() {
        if (this.store == null) {
            return;
        }
        try {
            this.store.rollback();
        }
        catch (Exception e) {
            String message = Policy.bind("indexed.couldNotCommit", this.location.toOSString());
            ResourceStatus status = new ResourceStatus(272, this.location, message, e);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
        }
    }

    public synchronized String getObjectAsString(ObjectID id) throws CoreException {
        try {
            return this.getStore().getObjectAsString(id);
        }
        catch (Exception e) {
            String message = Policy.bind("indexed.couldNotRead", this.location.toOSString());
            throw new ResourceException(271, this.location, message, e);
        }
    }

    private IndexedStore getStore() throws CoreException {
        if (this.store == null) {
            this.create();
        }
        return this.store;
    }

    public synchronized IndexCursor getCursor() throws CoreException {
        try {
            return this.getIndex().open();
        }
        catch (Exception e) {
            String message = Policy.bind("indexed.couldNotCreateCursor", this.location.toOSString());
            throw new ResourceException(271, this.location, message, e);
        }
    }

    public synchronized ObjectID createObject(String s) throws CoreException {
        try {
            return this.getStore().createObject(s);
        }
        catch (Exception e) {
            String message = Policy.bind("indexed.couldNotWrite", this.location.toOSString());
            throw new ResourceException(272, this.location, message, e);
        }
    }

    public synchronized ObjectID createObject(byte[] b) throws CoreException {
        try {
            return this.getStore().createObject(b);
        }
        catch (Exception e) {
            String message = Policy.bind("indexed.couldNotWrite", this.location.toOSString());
            throw new ResourceException(272, this.location, message, e);
        }
    }

    public synchronized void removeObject(ObjectID id) throws CoreException {
        try {
            this.getStore().removeObject(id);
        }
        catch (Exception e) {
            String message = Policy.bind("indexed.couldNotDelete", this.location.toOSString());
            throw new ResourceException(273, this.location, message, e);
        }
    }

    public synchronized byte[] getObject(ObjectID id) throws CoreException {
        try {
            return this.getStore().getObject(id);
        }
        catch (Exception e) {
            String message = Policy.bind("indexed.couldNotRead", this.location.toOSString());
            throw new ResourceException(271, this.location, message, e);
        }
    }

    public synchronized void reset() {
        try {
            this.recreate();
        }
        catch (CoreException e) {
            ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
        }
    }
}

